package io.dingodb.sdk.service.desc.debug;

import io.dingodb.sdk.service.ServiceCallCycles;
import io.dingodb.sdk.service.ServiceMethodBuilder;
import io.dingodb.sdk.service.entity.debug.AddRegionRequest;
import io.dingodb.sdk.service.entity.debug.AddRegionResponse;
import io.dingodb.sdk.service.entity.debug.AdjustThreadPoolSizeRequest;
import io.dingodb.sdk.service.entity.debug.AdjustThreadPoolSizeResponse;
import io.dingodb.sdk.service.entity.debug.BindCoreRequest;
import io.dingodb.sdk.service.entity.debug.BindCoreResponse;
import io.dingodb.sdk.service.entity.debug.ChangeRegionRequest;
import io.dingodb.sdk.service.entity.debug.ChangeRegionResponse;
import io.dingodb.sdk.service.entity.debug.CompactRequest;
import io.dingodb.sdk.service.entity.debug.CompactResponse;
import io.dingodb.sdk.service.entity.debug.DebugRequest;
import io.dingodb.sdk.service.entity.debug.DebugResponse;
import io.dingodb.sdk.service.entity.debug.DestroyRegionRequest;
import io.dingodb.sdk.service.entity.debug.DestroyRegionResponse;
import io.dingodb.sdk.service.entity.debug.DumpRegionRequest;
import io.dingodb.sdk.service.entity.debug.DumpRegionResponse;
import io.dingodb.sdk.service.entity.debug.GetMemoryStatsRequest;
import io.dingodb.sdk.service.entity.debug.GetMemoryStatsResponse;
import io.dingodb.sdk.service.entity.debug.MergeRegionRequest;
import io.dingodb.sdk.service.entity.debug.MergeRegionResponse;
import io.dingodb.sdk.service.entity.debug.ModifyRegionMetaRequest;
import io.dingodb.sdk.service.entity.debug.ModifyRegionMetaResponse;
import io.dingodb.sdk.service.entity.debug.ReleaseFreeMemoryRequest;
import io.dingodb.sdk.service.entity.debug.ReleaseFreeMemoryResponse;
import io.dingodb.sdk.service.entity.debug.ShowAffinityRequest;
import io.dingodb.sdk.service.entity.debug.ShowAffinityResponse;
import io.dingodb.sdk.service.entity.debug.SnapshotRequest;
import io.dingodb.sdk.service.entity.debug.SnapshotResponse;
import io.dingodb.sdk.service.entity.debug.SnapshotVectorIndexRequest;
import io.dingodb.sdk.service.entity.debug.SnapshotVectorIndexResponse;
import io.dingodb.sdk.service.entity.debug.TraceWorkQueueRequest;
import io.dingodb.sdk.service.entity.debug.TraceWorkQueueResponse;
import io.dingodb.sdk.service.entity.debug.TransferLeaderRequest;
import io.dingodb.sdk.service.entity.debug.TransferLeaderResponse;
import io.dingodb.sdk.service.entity.debug.TriggerRebuildVectorIndexRequest;
import io.dingodb.sdk.service.entity.debug.TriggerRebuildVectorIndexResponse;
import io.dingodb.sdk.service.entity.debug.TriggerSaveVectorIndexRequest;
import io.dingodb.sdk.service.entity.debug.TriggerSaveVectorIndexResponse;
import io.dingodb.sdk.service.entity.debug.TriggerVectorIndexSnapshotRequest;
import io.dingodb.sdk.service.entity.debug.TriggerVectorIndexSnapshotResponse;
import io.dingodb.sdk.service.entity.debug.UnbindCoreRequest;
import io.dingodb.sdk.service.entity.debug.UnbindCoreResponse;
import io.grpc.MethodDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DebugServiceDescriptors {
    MethodDescriptor<AddRegionRequest, AddRegionResponse> addRegion = ServiceMethodBuilder.buildUnary("dingodb.pb.debug.DebugService/AddRegion", AddRegionRequest::new, AddRegionResponse::new);

    ServiceCallCycles<AddRegionRequest, AddRegionResponse> addRegionHandlers = new ServiceCallCycles<>(addRegion, AddRegion.logger);

    MethodDescriptor<ChangeRegionRequest, ChangeRegionResponse> changeRegion = ServiceMethodBuilder.buildUnary("dingodb.pb.debug.DebugService/ChangeRegion", ChangeRegionRequest::new, ChangeRegionResponse::new);

    ServiceCallCycles<ChangeRegionRequest, ChangeRegionResponse> changeRegionHandlers = new ServiceCallCycles<>(changeRegion, ChangeRegion.logger);

    MethodDescriptor<MergeRegionRequest, MergeRegionResponse> mergeRegion = ServiceMethodBuilder.buildUnary("dingodb.pb.debug.DebugService/MergeRegion", MergeRegionRequest::new, MergeRegionResponse::new);

    ServiceCallCycles<MergeRegionRequest, MergeRegionResponse> mergeRegionHandlers = new ServiceCallCycles<>(mergeRegion, MergeRegion.logger);

    MethodDescriptor<DestroyRegionRequest, DestroyRegionResponse> destroyRegion = ServiceMethodBuilder.buildUnary("dingodb.pb.debug.DebugService/DestroyRegion", DestroyRegionRequest::new, DestroyRegionResponse::new);

    ServiceCallCycles<DestroyRegionRequest, DestroyRegionResponse> destroyRegionHandlers = new ServiceCallCycles<>(destroyRegion, DestroyRegion.logger);

    MethodDescriptor<SnapshotRequest, SnapshotResponse> snapshot = ServiceMethodBuilder.buildUnary("dingodb.pb.debug.DebugService/Snapshot", SnapshotRequest::new, SnapshotResponse::new);

    ServiceCallCycles<SnapshotRequest, SnapshotResponse> snapshotHandlers = new ServiceCallCycles<>(snapshot, Snapshot.logger);

    MethodDescriptor<TransferLeaderRequest, TransferLeaderResponse> transferLeader = ServiceMethodBuilder.buildUnary("dingodb.pb.debug.DebugService/TransferLeader", TransferLeaderRequest::new, TransferLeaderResponse::new);

    ServiceCallCycles<TransferLeaderRequest, TransferLeaderResponse> transferLeaderHandlers = new ServiceCallCycles<>(transferLeader, TransferLeader.logger);

    MethodDescriptor<ModifyRegionMetaRequest, ModifyRegionMetaResponse> modifyRegionMeta = ServiceMethodBuilder.buildUnary("dingodb.pb.debug.DebugService/ModifyRegionMeta", ModifyRegionMetaRequest::new, ModifyRegionMetaResponse::new);

    ServiceCallCycles<ModifyRegionMetaRequest, ModifyRegionMetaResponse> modifyRegionMetaHandlers = new ServiceCallCycles<>(modifyRegionMeta, ModifyRegionMeta.logger);

    MethodDescriptor<SnapshotVectorIndexRequest, SnapshotVectorIndexResponse> snapshotVectorIndex = ServiceMethodBuilder.buildUnary("dingodb.pb.debug.DebugService/SnapshotVectorIndex", SnapshotVectorIndexRequest::new, SnapshotVectorIndexResponse::new);

    ServiceCallCycles<SnapshotVectorIndexRequest, SnapshotVectorIndexResponse> snapshotVectorIndexHandlers = new ServiceCallCycles<>(snapshotVectorIndex, SnapshotVectorIndex.logger);

    MethodDescriptor<TriggerVectorIndexSnapshotRequest, TriggerVectorIndexSnapshotResponse> triggerVectorIndexSnapshot = ServiceMethodBuilder.buildUnary("dingodb.pb.debug.DebugService/TriggerVectorIndexSnapshot", TriggerVectorIndexSnapshotRequest::new, TriggerVectorIndexSnapshotResponse::new);

    ServiceCallCycles<TriggerVectorIndexSnapshotRequest, TriggerVectorIndexSnapshotResponse> triggerVectorIndexSnapshotHandlers = new ServiceCallCycles<>(triggerVectorIndexSnapshot, TriggerVectorIndexSnapshot.logger);

    MethodDescriptor<TriggerRebuildVectorIndexRequest, TriggerRebuildVectorIndexResponse> triggerRebuildVectorIndex = ServiceMethodBuilder.buildUnary("dingodb.pb.debug.DebugService/TriggerRebuildVectorIndex", TriggerRebuildVectorIndexRequest::new, TriggerRebuildVectorIndexResponse::new);

    ServiceCallCycles<TriggerRebuildVectorIndexRequest, TriggerRebuildVectorIndexResponse> triggerRebuildVectorIndexHandlers = new ServiceCallCycles<>(triggerRebuildVectorIndex, TriggerRebuildVectorIndex.logger);

    MethodDescriptor<TriggerSaveVectorIndexRequest, TriggerSaveVectorIndexResponse> triggerSaveVectorIndex = ServiceMethodBuilder.buildUnary("dingodb.pb.debug.DebugService/TriggerSaveVectorIndex", TriggerSaveVectorIndexRequest::new, TriggerSaveVectorIndexResponse::new);

    ServiceCallCycles<TriggerSaveVectorIndexRequest, TriggerSaveVectorIndexResponse> triggerSaveVectorIndexHandlers = new ServiceCallCycles<>(triggerSaveVectorIndex, TriggerSaveVectorIndex.logger);

    MethodDescriptor<CompactRequest, CompactResponse> compact = ServiceMethodBuilder.buildUnary("dingodb.pb.debug.DebugService/Compact", CompactRequest::new, CompactResponse::new);

    ServiceCallCycles<CompactRequest, CompactResponse> compactHandlers = new ServiceCallCycles<>(compact, Compact.logger);

    MethodDescriptor<DebugRequest, DebugResponse> debug = ServiceMethodBuilder.buildUnary("dingodb.pb.debug.DebugService/Debug", DebugRequest::new, DebugResponse::new);

    ServiceCallCycles<DebugRequest, DebugResponse> debugHandlers = new ServiceCallCycles<>(debug, Debug.logger);

    MethodDescriptor<GetMemoryStatsRequest, GetMemoryStatsResponse> getMemoryStats = ServiceMethodBuilder.buildUnary("dingodb.pb.debug.DebugService/GetMemoryStats", GetMemoryStatsRequest::new, GetMemoryStatsResponse::new);

    ServiceCallCycles<GetMemoryStatsRequest, GetMemoryStatsResponse> getMemoryStatsHandlers = new ServiceCallCycles<>(getMemoryStats, GetMemoryStats.logger);

    MethodDescriptor<ReleaseFreeMemoryRequest, ReleaseFreeMemoryResponse> releaseFreeMemory = ServiceMethodBuilder.buildUnary("dingodb.pb.debug.DebugService/ReleaseFreeMemory", ReleaseFreeMemoryRequest::new, ReleaseFreeMemoryResponse::new);

    ServiceCallCycles<ReleaseFreeMemoryRequest, ReleaseFreeMemoryResponse> releaseFreeMemoryHandlers = new ServiceCallCycles<>(releaseFreeMemory, ReleaseFreeMemory.logger);

    MethodDescriptor<TraceWorkQueueRequest, TraceWorkQueueResponse> traceWorkQueue = ServiceMethodBuilder.buildUnary("dingodb.pb.debug.DebugService/TraceWorkQueue", TraceWorkQueueRequest::new, TraceWorkQueueResponse::new);

    ServiceCallCycles<TraceWorkQueueRequest, TraceWorkQueueResponse> traceWorkQueueHandlers = new ServiceCallCycles<>(traceWorkQueue, TraceWorkQueue.logger);

    MethodDescriptor<AdjustThreadPoolSizeRequest, AdjustThreadPoolSizeResponse> adjustThreadPoolSize = ServiceMethodBuilder.buildUnary("dingodb.pb.debug.DebugService/AdjustThreadPoolSize", AdjustThreadPoolSizeRequest::new, AdjustThreadPoolSizeResponse::new);

    ServiceCallCycles<AdjustThreadPoolSizeRequest, AdjustThreadPoolSizeResponse> adjustThreadPoolSizeHandlers = new ServiceCallCycles<>(adjustThreadPoolSize, AdjustThreadPoolSize.logger);

    MethodDescriptor<BindCoreRequest, BindCoreResponse> bindCore = ServiceMethodBuilder.buildUnary("dingodb.pb.debug.DebugService/BindCore", BindCoreRequest::new, BindCoreResponse::new);

    ServiceCallCycles<BindCoreRequest, BindCoreResponse> bindCoreHandlers = new ServiceCallCycles<>(bindCore, BindCore.logger);

    MethodDescriptor<UnbindCoreRequest, UnbindCoreResponse> unbindCore = ServiceMethodBuilder.buildUnary("dingodb.pb.debug.DebugService/UnbindCore", UnbindCoreRequest::new, UnbindCoreResponse::new);

    ServiceCallCycles<UnbindCoreRequest, UnbindCoreResponse> unbindCoreHandlers = new ServiceCallCycles<>(unbindCore, UnbindCore.logger);

    MethodDescriptor<ShowAffinityRequest, ShowAffinityResponse> showAffinity = ServiceMethodBuilder.buildUnary("dingodb.pb.debug.DebugService/ShowAffinity", ShowAffinityRequest::new, ShowAffinityResponse::new);

    ServiceCallCycles<ShowAffinityRequest, ShowAffinityResponse> showAffinityHandlers = new ServiceCallCycles<>(showAffinity, ShowAffinity.logger);

    MethodDescriptor<DumpRegionRequest, DumpRegionResponse> dumpRegion = ServiceMethodBuilder.buildUnary("dingodb.pb.debug.DebugService/DumpRegion", DumpRegionRequest::new, DumpRegionResponse::new);

    ServiceCallCycles<DumpRegionRequest, DumpRegionResponse> dumpRegionHandlers = new ServiceCallCycles<>(dumpRegion, DumpRegion.logger);

    final class AddRegion {
        public static final Logger logger = LoggerFactory.getLogger(AddRegion.class);
    }

    final class ChangeRegion {
        public static final Logger logger = LoggerFactory.getLogger(ChangeRegion.class);
    }

    final class MergeRegion {
        public static final Logger logger = LoggerFactory.getLogger(MergeRegion.class);
    }

    final class DestroyRegion {
        public static final Logger logger = LoggerFactory.getLogger(DestroyRegion.class);
    }

    final class Snapshot {
        public static final Logger logger = LoggerFactory.getLogger(Snapshot.class);
    }

    final class TransferLeader {
        public static final Logger logger = LoggerFactory.getLogger(TransferLeader.class);
    }

    final class ModifyRegionMeta {
        public static final Logger logger = LoggerFactory.getLogger(ModifyRegionMeta.class);
    }

    final class SnapshotVectorIndex {
        public static final Logger logger = LoggerFactory.getLogger(SnapshotVectorIndex.class);
    }

    final class TriggerVectorIndexSnapshot {
        public static final Logger logger = LoggerFactory.getLogger(TriggerVectorIndexSnapshot.class);
    }

    final class TriggerRebuildVectorIndex {
        public static final Logger logger = LoggerFactory.getLogger(TriggerRebuildVectorIndex.class);
    }

    final class TriggerSaveVectorIndex {
        public static final Logger logger = LoggerFactory.getLogger(TriggerSaveVectorIndex.class);
    }

    final class Compact {
        public static final Logger logger = LoggerFactory.getLogger(Compact.class);
    }

    final class Debug {
        public static final Logger logger = LoggerFactory.getLogger(Debug.class);
    }

    final class GetMemoryStats {
        public static final Logger logger = LoggerFactory.getLogger(GetMemoryStats.class);
    }

    final class ReleaseFreeMemory {
        public static final Logger logger = LoggerFactory.getLogger(ReleaseFreeMemory.class);
    }

    final class TraceWorkQueue {
        public static final Logger logger = LoggerFactory.getLogger(TraceWorkQueue.class);
    }

    final class AdjustThreadPoolSize {
        public static final Logger logger = LoggerFactory.getLogger(AdjustThreadPoolSize.class);
    }

    final class BindCore {
        public static final Logger logger = LoggerFactory.getLogger(BindCore.class);
    }

    final class UnbindCore {
        public static final Logger logger = LoggerFactory.getLogger(UnbindCore.class);
    }

    final class ShowAffinity {
        public static final Logger logger = LoggerFactory.getLogger(ShowAffinity.class);
    }

    final class DumpRegion {
        public static final Logger logger = LoggerFactory.getLogger(DumpRegion.class);
    }
}
