package io.dingodb.sdk.service.desc.coordinator;

import io.dingodb.sdk.service.ServiceCallCycles;
import io.dingodb.sdk.service.ServiceMethodBuilder;
import io.dingodb.sdk.service.entity.coordinator.PushHeartbeatRequest;
import io.dingodb.sdk.service.entity.coordinator.PushHeartbeatResponse;
import io.dingodb.sdk.service.entity.coordinator.PushStoreOperationRequest;
import io.dingodb.sdk.service.entity.coordinator.PushStoreOperationResponse;
import io.grpc.MethodDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PushServiceDescriptors {
    MethodDescriptor<PushHeartbeatRequest, PushHeartbeatResponse> pushHeartbeat = ServiceMethodBuilder.buildUnary("dingodb.pb.push.PushService/PushHeartbeat", PushHeartbeatRequest::new, PushHeartbeatResponse::new);

    ServiceCallCycles<PushHeartbeatRequest, PushHeartbeatResponse> pushHeartbeatHandlers = new ServiceCallCycles<>(pushHeartbeat, PushHeartbeat.logger);

    MethodDescriptor<PushStoreOperationRequest, PushStoreOperationResponse> pushStoreOperation = ServiceMethodBuilder.buildUnary("dingodb.pb.push.PushService/PushStoreOperation", PushStoreOperationRequest::new, PushStoreOperationResponse::new);

    ServiceCallCycles<PushStoreOperationRequest, PushStoreOperationResponse> pushStoreOperationHandlers = new ServiceCallCycles<>(pushStoreOperation, PushStoreOperation.logger);

    final class PushHeartbeat {
        public static final Logger logger = LoggerFactory.getLogger(PushHeartbeat.class);
    }

    final class PushStoreOperation {
        public static final Logger logger = LoggerFactory.getLogger(PushStoreOperation.class);
    }
}
