package io.dingodb.sdk.service.desc.coordinator;

import io.dingodb.sdk.service.ServiceCallCycles;
import io.dingodb.sdk.service.ServiceMethodBuilder;
import io.dingodb.sdk.service.entity.coordinator.AddDeletedRegionMapRequest;
import io.dingodb.sdk.service.entity.coordinator.AddDeletedRegionMapResponse;
import io.dingodb.sdk.service.entity.coordinator.AddStoreOperationRequest;
import io.dingodb.sdk.service.entity.coordinator.AddStoreOperationResponse;
import io.dingodb.sdk.service.entity.coordinator.BalanceLeaderRequest;
import io.dingodb.sdk.service.entity.coordinator.BalanceLeaderResponse;
import io.dingodb.sdk.service.entity.coordinator.BalanceRegionRequest;
import io.dingodb.sdk.service.entity.coordinator.BalanceRegionResponse;
import io.dingodb.sdk.service.entity.coordinator.ChangePeerRegionRequest;
import io.dingodb.sdk.service.entity.coordinator.ChangePeerRegionResponse;
import io.dingodb.sdk.service.entity.coordinator.CleanDeletedRegionMapRequest;
import io.dingodb.sdk.service.entity.coordinator.CleanDeletedRegionMapResponse;
import io.dingodb.sdk.service.entity.coordinator.CleanJobListRequest;
import io.dingodb.sdk.service.entity.coordinator.CleanJobListResponse;
import io.dingodb.sdk.service.entity.coordinator.CleanStoreOperationRequest;
import io.dingodb.sdk.service.entity.coordinator.CleanStoreOperationResponse;
import io.dingodb.sdk.service.entity.coordinator.ConfigCoordinatorRequest;
import io.dingodb.sdk.service.entity.coordinator.ConfigCoordinatorResponse;
import io.dingodb.sdk.service.entity.coordinator.ControlConfigRequest;
import io.dingodb.sdk.service.entity.coordinator.ControlConfigResponse;
import io.dingodb.sdk.service.entity.coordinator.CreateExecutorRequest;
import io.dingodb.sdk.service.entity.coordinator.CreateExecutorResponse;
import io.dingodb.sdk.service.entity.coordinator.CreateExecutorUserRequest;
import io.dingodb.sdk.service.entity.coordinator.CreateExecutorUserResponse;
import io.dingodb.sdk.service.entity.coordinator.CreateIdsRequest;
import io.dingodb.sdk.service.entity.coordinator.CreateIdsResponse;
import io.dingodb.sdk.service.entity.coordinator.CreateRegionIdRequest;
import io.dingodb.sdk.service.entity.coordinator.CreateRegionIdResponse;
import io.dingodb.sdk.service.entity.coordinator.CreateRegionRequest;
import io.dingodb.sdk.service.entity.coordinator.CreateRegionResponse;
import io.dingodb.sdk.service.entity.coordinator.CreateStoreRequest;
import io.dingodb.sdk.service.entity.coordinator.CreateStoreResponse;
import io.dingodb.sdk.service.entity.coordinator.DeleteExecutorRequest;
import io.dingodb.sdk.service.entity.coordinator.DeleteExecutorResponse;
import io.dingodb.sdk.service.entity.coordinator.DeleteExecutorUserRequest;
import io.dingodb.sdk.service.entity.coordinator.DeleteExecutorUserResponse;
import io.dingodb.sdk.service.entity.coordinator.DeleteRegionMetricsRequest;
import io.dingodb.sdk.service.entity.coordinator.DeleteRegionMetricsResponse;
import io.dingodb.sdk.service.entity.coordinator.DeleteStoreMetricsRequest;
import io.dingodb.sdk.service.entity.coordinator.DeleteStoreMetricsResponse;
import io.dingodb.sdk.service.entity.coordinator.DeleteStoreRequest;
import io.dingodb.sdk.service.entity.coordinator.DeleteStoreResponse;
import io.dingodb.sdk.service.entity.coordinator.DropRegionPermanentlyRequest;
import io.dingodb.sdk.service.entity.coordinator.DropRegionPermanentlyResponse;
import io.dingodb.sdk.service.entity.coordinator.DropRegionRequest;
import io.dingodb.sdk.service.entity.coordinator.DropRegionResponse;
import io.dingodb.sdk.service.entity.coordinator.ExecutorHeartbeatRequest;
import io.dingodb.sdk.service.entity.coordinator.ExecutorHeartbeatResponse;
import io.dingodb.sdk.service.entity.coordinator.GetCoordinatorMapRequest;
import io.dingodb.sdk.service.entity.coordinator.GetCoordinatorMapResponse;
import io.dingodb.sdk.service.entity.coordinator.GetDeletedRegionMapRequest;
import io.dingodb.sdk.service.entity.coordinator.GetDeletedRegionMapResponse;
import io.dingodb.sdk.service.entity.coordinator.GetExecutorMapRequest;
import io.dingodb.sdk.service.entity.coordinator.GetExecutorMapResponse;
import io.dingodb.sdk.service.entity.coordinator.GetExecutorUserMapRequest;
import io.dingodb.sdk.service.entity.coordinator.GetExecutorUserMapResponse;
import io.dingodb.sdk.service.entity.coordinator.GetGCSafePointRequest;
import io.dingodb.sdk.service.entity.coordinator.GetGCSafePointResponse;
import io.dingodb.sdk.service.entity.coordinator.GetJobListRequest;
import io.dingodb.sdk.service.entity.coordinator.GetJobListResponse;
import io.dingodb.sdk.service.entity.coordinator.GetMDSListRequest;
import io.dingodb.sdk.service.entity.coordinator.GetMDSListResponse;
import io.dingodb.sdk.service.entity.coordinator.GetOrphanRegionRequest;
import io.dingodb.sdk.service.entity.coordinator.GetOrphanRegionResponse;
import io.dingodb.sdk.service.entity.coordinator.GetRangeRegionMapRequest;
import io.dingodb.sdk.service.entity.coordinator.GetRangeRegionMapResponse;
import io.dingodb.sdk.service.entity.coordinator.GetRegionCmdRequest;
import io.dingodb.sdk.service.entity.coordinator.GetRegionCmdResponse;
import io.dingodb.sdk.service.entity.coordinator.GetRegionCountRequest;
import io.dingodb.sdk.service.entity.coordinator.GetRegionCountResponse;
import io.dingodb.sdk.service.entity.coordinator.GetRegionMapRequest;
import io.dingodb.sdk.service.entity.coordinator.GetRegionMapResponse;
import io.dingodb.sdk.service.entity.coordinator.GetRegionMetricsRequest;
import io.dingodb.sdk.service.entity.coordinator.GetRegionMetricsResponse;
import io.dingodb.sdk.service.entity.coordinator.GetStoreMapRequest;
import io.dingodb.sdk.service.entity.coordinator.GetStoreMapResponse;
import io.dingodb.sdk.service.entity.coordinator.GetStoreMetricsRequest;
import io.dingodb.sdk.service.entity.coordinator.GetStoreMetricsResponse;
import io.dingodb.sdk.service.entity.coordinator.GetStoreOperationRequest;
import io.dingodb.sdk.service.entity.coordinator.GetStoreOperationResponse;
import io.dingodb.sdk.service.entity.coordinator.GetStoreOwnMetricsRequest;
import io.dingodb.sdk.service.entity.coordinator.GetStoreOwnMetricsResponse;
import io.dingodb.sdk.service.entity.coordinator.HelloRequest;
import io.dingodb.sdk.service.entity.coordinator.HelloResponse;
import io.dingodb.sdk.service.entity.coordinator.MDSHeartbeatRequest;
import io.dingodb.sdk.service.entity.coordinator.MDSHeartbeatResponse;
import io.dingodb.sdk.service.entity.coordinator.MergeRegionRequest;
import io.dingodb.sdk.service.entity.coordinator.MergeRegionResponse;
import io.dingodb.sdk.service.entity.coordinator.QueryRegionRequest;
import io.dingodb.sdk.service.entity.coordinator.QueryRegionResponse;
import io.dingodb.sdk.service.entity.coordinator.RaftControlRequest;
import io.dingodb.sdk.service.entity.coordinator.RaftControlResponse;
import io.dingodb.sdk.service.entity.coordinator.RegisterBackupRequest;
import io.dingodb.sdk.service.entity.coordinator.RegisterBackupResponse;
import io.dingodb.sdk.service.entity.coordinator.RegisterBackupStatusRequest;
import io.dingodb.sdk.service.entity.coordinator.RegisterBackupStatusResponse;
import io.dingodb.sdk.service.entity.coordinator.RegisterRestoreRequest;
import io.dingodb.sdk.service.entity.coordinator.RegisterRestoreResponse;
import io.dingodb.sdk.service.entity.coordinator.RegisterRestoreStatusRequest;
import io.dingodb.sdk.service.entity.coordinator.RegisterRestoreStatusResponse;
import io.dingodb.sdk.service.entity.coordinator.RemoveStoreOperationRequest;
import io.dingodb.sdk.service.entity.coordinator.RemoveStoreOperationResponse;
import io.dingodb.sdk.service.entity.coordinator.ScanRegionsRequest;
import io.dingodb.sdk.service.entity.coordinator.ScanRegionsResponse;
import io.dingodb.sdk.service.entity.coordinator.SplitRegionRequest;
import io.dingodb.sdk.service.entity.coordinator.SplitRegionResponse;
import io.dingodb.sdk.service.entity.coordinator.StoreHeartbeatRequest;
import io.dingodb.sdk.service.entity.coordinator.StoreHeartbeatResponse;
import io.dingodb.sdk.service.entity.coordinator.TransferLeaderRegionRequest;
import io.dingodb.sdk.service.entity.coordinator.TransferLeaderRegionResponse;
import io.dingodb.sdk.service.entity.coordinator.UnRegisterBackupRequest;
import io.dingodb.sdk.service.entity.coordinator.UnRegisterBackupResponse;
import io.dingodb.sdk.service.entity.coordinator.UnRegisterRestoreRequest;
import io.dingodb.sdk.service.entity.coordinator.UnRegisterRestoreResponse;
import io.dingodb.sdk.service.entity.coordinator.UpdateExecutorUserRequest;
import io.dingodb.sdk.service.entity.coordinator.UpdateExecutorUserResponse;
import io.dingodb.sdk.service.entity.coordinator.UpdateGCSafePointRequest;
import io.dingodb.sdk.service.entity.coordinator.UpdateGCSafePointResponse;
import io.dingodb.sdk.service.entity.coordinator.UpdateRegionCmdStatusRequest;
import io.dingodb.sdk.service.entity.coordinator.UpdateRegionCmdStatusResponse;
import io.dingodb.sdk.service.entity.coordinator.UpdateStoreRequest;
import io.dingodb.sdk.service.entity.coordinator.UpdateStoreResponse;
import io.grpc.MethodDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CoordinatorServiceDescriptors {
    MethodDescriptor<HelloRequest, HelloResponse> hello = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/Hello", HelloRequest::new, HelloResponse::new);

    ServiceCallCycles<HelloRequest, HelloResponse> helloHandlers = new ServiceCallCycles<>(hello, Hello.logger);

    MethodDescriptor<HelloRequest, HelloResponse> getMemoryInfo = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/GetMemoryInfo", HelloRequest::new, HelloResponse::new);

    ServiceCallCycles<HelloRequest, HelloResponse> getMemoryInfoHandlers = new ServiceCallCycles<>(getMemoryInfo, GetMemoryInfo.logger);

    MethodDescriptor<StoreHeartbeatRequest, StoreHeartbeatResponse> storeHeartbeat = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/StoreHeartbeat", StoreHeartbeatRequest::new, StoreHeartbeatResponse::new);

    ServiceCallCycles<StoreHeartbeatRequest, StoreHeartbeatResponse> storeHeartbeatHandlers = new ServiceCallCycles<>(storeHeartbeat, StoreHeartbeat.logger);

    MethodDescriptor<GetRegionMapRequest, GetRegionMapResponse> getRegionMap = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/GetRegionMap", GetRegionMapRequest::new, GetRegionMapResponse::new);

    ServiceCallCycles<GetRegionMapRequest, GetRegionMapResponse> getRegionMapHandlers = new ServiceCallCycles<>(getRegionMap, GetRegionMap.logger);

    MethodDescriptor<GetDeletedRegionMapRequest, GetDeletedRegionMapResponse> getDeletedRegionMap = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/GetDeletedRegionMap", GetDeletedRegionMapRequest::new, GetDeletedRegionMapResponse::new);

    ServiceCallCycles<GetDeletedRegionMapRequest, GetDeletedRegionMapResponse> getDeletedRegionMapHandlers = new ServiceCallCycles<>(getDeletedRegionMap, GetDeletedRegionMap.logger);

    MethodDescriptor<AddDeletedRegionMapRequest, AddDeletedRegionMapResponse> addDeletedRegionMap = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/AddDeletedRegionMap", AddDeletedRegionMapRequest::new, AddDeletedRegionMapResponse::new);

    ServiceCallCycles<AddDeletedRegionMapRequest, AddDeletedRegionMapResponse> addDeletedRegionMapHandlers = new ServiceCallCycles<>(addDeletedRegionMap, AddDeletedRegionMap.logger);

    MethodDescriptor<CleanDeletedRegionMapRequest, CleanDeletedRegionMapResponse> cleanDeletedRegionMap = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/CleanDeletedRegionMap", CleanDeletedRegionMapRequest::new, CleanDeletedRegionMapResponse::new);

    ServiceCallCycles<CleanDeletedRegionMapRequest, CleanDeletedRegionMapResponse> cleanDeletedRegionMapHandlers = new ServiceCallCycles<>(cleanDeletedRegionMap, CleanDeletedRegionMap.logger);

    MethodDescriptor<GetRegionCountRequest, GetRegionCountResponse> getRegionCount = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/GetRegionCount", GetRegionCountRequest::new, GetRegionCountResponse::new);

    ServiceCallCycles<GetRegionCountRequest, GetRegionCountResponse> getRegionCountHandlers = new ServiceCallCycles<>(getRegionCount, GetRegionCount.logger);

    MethodDescriptor<GetStoreMapRequest, GetStoreMapResponse> getStoreMap = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/GetStoreMap", GetStoreMapRequest::new, GetStoreMapResponse::new);

    ServiceCallCycles<GetStoreMapRequest, GetStoreMapResponse> getStoreMapHandlers = new ServiceCallCycles<>(getStoreMap, GetStoreMap.logger);

    MethodDescriptor<GetStoreMetricsRequest, GetStoreMetricsResponse> getStoreMetrics = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/GetStoreMetrics", GetStoreMetricsRequest::new, GetStoreMetricsResponse::new);

    ServiceCallCycles<GetStoreMetricsRequest, GetStoreMetricsResponse> getStoreMetricsHandlers = new ServiceCallCycles<>(getStoreMetrics, GetStoreMetrics.logger);

    MethodDescriptor<DeleteStoreMetricsRequest, DeleteStoreMetricsResponse> deleteStoreMetrics = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/DeleteStoreMetrics", DeleteStoreMetricsRequest::new, DeleteStoreMetricsResponse::new);

    ServiceCallCycles<DeleteStoreMetricsRequest, DeleteStoreMetricsResponse> deleteStoreMetricsHandlers = new ServiceCallCycles<>(deleteStoreMetrics, DeleteStoreMetrics.logger);

    MethodDescriptor<GetRegionMetricsRequest, GetRegionMetricsResponse> getRegionMetrics = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/GetRegionMetrics", GetRegionMetricsRequest::new, GetRegionMetricsResponse::new);

    ServiceCallCycles<GetRegionMetricsRequest, GetRegionMetricsResponse> getRegionMetricsHandlers = new ServiceCallCycles<>(getRegionMetrics, GetRegionMetrics.logger);

    MethodDescriptor<DeleteRegionMetricsRequest, DeleteRegionMetricsResponse> deleteRegionMetrics = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/DeleteRegionMetrics", DeleteRegionMetricsRequest::new, DeleteRegionMetricsResponse::new);

    ServiceCallCycles<DeleteRegionMetricsRequest, DeleteRegionMetricsResponse> deleteRegionMetricsHandlers = new ServiceCallCycles<>(deleteRegionMetrics, DeleteRegionMetrics.logger);

    MethodDescriptor<CreateStoreRequest, CreateStoreResponse> createStore = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/CreateStore", CreateStoreRequest::new, CreateStoreResponse::new);

    ServiceCallCycles<CreateStoreRequest, CreateStoreResponse> createStoreHandlers = new ServiceCallCycles<>(createStore, CreateStore.logger);

    MethodDescriptor<DeleteStoreRequest, DeleteStoreResponse> deleteStore = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/DeleteStore", DeleteStoreRequest::new, DeleteStoreResponse::new);

    ServiceCallCycles<DeleteStoreRequest, DeleteStoreResponse> deleteStoreHandlers = new ServiceCallCycles<>(deleteStore, DeleteStore.logger);

    MethodDescriptor<UpdateStoreRequest, UpdateStoreResponse> updateStore = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/UpdateStore", UpdateStoreRequest::new, UpdateStoreResponse::new);

    ServiceCallCycles<UpdateStoreRequest, UpdateStoreResponse> updateStoreHandlers = new ServiceCallCycles<>(updateStore, UpdateStore.logger);

    MethodDescriptor<GetStoreOwnMetricsRequest, GetStoreOwnMetricsResponse> getStoreOwnMetrics = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/GetStoreOwnMetrics", GetStoreOwnMetricsRequest::new, GetStoreOwnMetricsResponse::new);

    ServiceCallCycles<GetStoreOwnMetricsRequest, GetStoreOwnMetricsResponse> getStoreOwnMetricsHandlers = new ServiceCallCycles<>(getStoreOwnMetrics, GetStoreOwnMetrics.logger);

    MethodDescriptor<ExecutorHeartbeatRequest, ExecutorHeartbeatResponse> executorHeartbeat = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/ExecutorHeartbeat", ExecutorHeartbeatRequest::new, ExecutorHeartbeatResponse::new);

    ServiceCallCycles<ExecutorHeartbeatRequest, ExecutorHeartbeatResponse> executorHeartbeatHandlers = new ServiceCallCycles<>(executorHeartbeat, ExecutorHeartbeat.logger);

    MethodDescriptor<CreateExecutorRequest, CreateExecutorResponse> createExecutor = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/CreateExecutor", CreateExecutorRequest::new, CreateExecutorResponse::new);

    ServiceCallCycles<CreateExecutorRequest, CreateExecutorResponse> createExecutorHandlers = new ServiceCallCycles<>(createExecutor, CreateExecutor.logger);

    MethodDescriptor<DeleteExecutorRequest, DeleteExecutorResponse> deleteExecutor = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/DeleteExecutor", DeleteExecutorRequest::new, DeleteExecutorResponse::new);

    ServiceCallCycles<DeleteExecutorRequest, DeleteExecutorResponse> deleteExecutorHandlers = new ServiceCallCycles<>(deleteExecutor, DeleteExecutor.logger);

    MethodDescriptor<GetExecutorMapRequest, GetExecutorMapResponse> getExecutorMap = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/GetExecutorMap", GetExecutorMapRequest::new, GetExecutorMapResponse::new);

    ServiceCallCycles<GetExecutorMapRequest, GetExecutorMapResponse> getExecutorMapHandlers = new ServiceCallCycles<>(getExecutorMap, GetExecutorMap.logger);

    MethodDescriptor<CreateExecutorUserRequest, CreateExecutorUserResponse> createExecutorUser = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/CreateExecutorUser", CreateExecutorUserRequest::new, CreateExecutorUserResponse::new);

    ServiceCallCycles<CreateExecutorUserRequest, CreateExecutorUserResponse> createExecutorUserHandlers = new ServiceCallCycles<>(createExecutorUser, CreateExecutorUser.logger);

    MethodDescriptor<DeleteExecutorUserRequest, DeleteExecutorUserResponse> deleteExecutorUser = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/DeleteExecutorUser", DeleteExecutorUserRequest::new, DeleteExecutorUserResponse::new);

    ServiceCallCycles<DeleteExecutorUserRequest, DeleteExecutorUserResponse> deleteExecutorUserHandlers = new ServiceCallCycles<>(deleteExecutorUser, DeleteExecutorUser.logger);

    MethodDescriptor<UpdateExecutorUserRequest, UpdateExecutorUserResponse> updateExecutorUser = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/UpdateExecutorUser", UpdateExecutorUserRequest::new, UpdateExecutorUserResponse::new);

    ServiceCallCycles<UpdateExecutorUserRequest, UpdateExecutorUserResponse> updateExecutorUserHandlers = new ServiceCallCycles<>(updateExecutorUser, UpdateExecutorUser.logger);

    MethodDescriptor<GetExecutorUserMapRequest, GetExecutorUserMapResponse> getExecutorUserMap = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/GetExecutorUserMap", GetExecutorUserMapRequest::new, GetExecutorUserMapResponse::new);

    ServiceCallCycles<GetExecutorUserMapRequest, GetExecutorUserMapResponse> getExecutorUserMapHandlers = new ServiceCallCycles<>(getExecutorUserMap, GetExecutorUserMap.logger);

    MethodDescriptor<GetCoordinatorMapRequest, GetCoordinatorMapResponse> getCoordinatorMap = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/GetCoordinatorMap", GetCoordinatorMapRequest::new, GetCoordinatorMapResponse::new);

    ServiceCallCycles<GetCoordinatorMapRequest, GetCoordinatorMapResponse> getCoordinatorMapHandlers = new ServiceCallCycles<>(getCoordinatorMap, GetCoordinatorMap.logger);

    MethodDescriptor<ConfigCoordinatorRequest, ConfigCoordinatorResponse> configCoordinator = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/ConfigCoordinator", ConfigCoordinatorRequest::new, ConfigCoordinatorResponse::new);

    ServiceCallCycles<ConfigCoordinatorRequest, ConfigCoordinatorResponse> configCoordinatorHandlers = new ServiceCallCycles<>(configCoordinator, ConfigCoordinator.logger);

    MethodDescriptor<CreateRegionIdRequest, CreateRegionIdResponse> createRegionId = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/CreateRegionId", CreateRegionIdRequest::new, CreateRegionIdResponse::new);

    ServiceCallCycles<CreateRegionIdRequest, CreateRegionIdResponse> createRegionIdHandlers = new ServiceCallCycles<>(createRegionId, CreateRegionId.logger);

    MethodDescriptor<QueryRegionRequest, QueryRegionResponse> queryRegion = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/QueryRegion", QueryRegionRequest::new, QueryRegionResponse::new);

    ServiceCallCycles<QueryRegionRequest, QueryRegionResponse> queryRegionHandlers = new ServiceCallCycles<>(queryRegion, QueryRegion.logger);

    MethodDescriptor<CreateRegionRequest, CreateRegionResponse> createRegion = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/CreateRegion", CreateRegionRequest::new, CreateRegionResponse::new);

    ServiceCallCycles<CreateRegionRequest, CreateRegionResponse> createRegionHandlers = new ServiceCallCycles<>(createRegion, CreateRegion.logger);

    MethodDescriptor<DropRegionRequest, DropRegionResponse> dropRegion = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/DropRegion", DropRegionRequest::new, DropRegionResponse::new);

    ServiceCallCycles<DropRegionRequest, DropRegionResponse> dropRegionHandlers = new ServiceCallCycles<>(dropRegion, DropRegion.logger);

    MethodDescriptor<DropRegionPermanentlyRequest, DropRegionPermanentlyResponse> dropRegionPermanently = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/DropRegionPermanently", DropRegionPermanentlyRequest::new, DropRegionPermanentlyResponse::new);

    ServiceCallCycles<DropRegionPermanentlyRequest, DropRegionPermanentlyResponse> dropRegionPermanentlyHandlers = new ServiceCallCycles<>(dropRegionPermanently, DropRegionPermanently.logger);

    MethodDescriptor<SplitRegionRequest, SplitRegionResponse> splitRegion = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/SplitRegion", SplitRegionRequest::new, SplitRegionResponse::new);

    ServiceCallCycles<SplitRegionRequest, SplitRegionResponse> splitRegionHandlers = new ServiceCallCycles<>(splitRegion, SplitRegion.logger);

    MethodDescriptor<MergeRegionRequest, MergeRegionResponse> mergeRegion = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/MergeRegion", MergeRegionRequest::new, MergeRegionResponse::new);

    ServiceCallCycles<MergeRegionRequest, MergeRegionResponse> mergeRegionHandlers = new ServiceCallCycles<>(mergeRegion, MergeRegion.logger);

    MethodDescriptor<ChangePeerRegionRequest, ChangePeerRegionResponse> changePeerRegion = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/ChangePeerRegion", ChangePeerRegionRequest::new, ChangePeerRegionResponse::new);

    ServiceCallCycles<ChangePeerRegionRequest, ChangePeerRegionResponse> changePeerRegionHandlers = new ServiceCallCycles<>(changePeerRegion, ChangePeerRegion.logger);

    MethodDescriptor<TransferLeaderRegionRequest, TransferLeaderRegionResponse> transferLeaderRegion = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/TransferLeaderRegion", TransferLeaderRegionRequest::new, TransferLeaderRegionResponse::new);

    ServiceCallCycles<TransferLeaderRegionRequest, TransferLeaderRegionResponse> transferLeaderRegionHandlers = new ServiceCallCycles<>(transferLeaderRegion, TransferLeaderRegion.logger);

    MethodDescriptor<GetOrphanRegionRequest, GetOrphanRegionResponse> getOrphanRegion = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/GetOrphanRegion", GetOrphanRegionRequest::new, GetOrphanRegionResponse::new);

    ServiceCallCycles<GetOrphanRegionRequest, GetOrphanRegionResponse> getOrphanRegionHandlers = new ServiceCallCycles<>(getOrphanRegion, GetOrphanRegion.logger);

    MethodDescriptor<ScanRegionsRequest, ScanRegionsResponse> scanRegions = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/ScanRegions", ScanRegionsRequest::new, ScanRegionsResponse::new);

    ServiceCallCycles<ScanRegionsRequest, ScanRegionsResponse> scanRegionsHandlers = new ServiceCallCycles<>(scanRegions, ScanRegions.logger);

    MethodDescriptor<GetRangeRegionMapRequest, GetRangeRegionMapResponse> getRangeRegionMap = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/GetRangeRegionMap", GetRangeRegionMapRequest::new, GetRangeRegionMapResponse::new);

    ServiceCallCycles<GetRangeRegionMapRequest, GetRangeRegionMapResponse> getRangeRegionMapHandlers = new ServiceCallCycles<>(getRangeRegionMap, GetRangeRegionMap.logger);

    MethodDescriptor<GetStoreOperationRequest, GetStoreOperationResponse> getStoreOperation = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/GetStoreOperation", GetStoreOperationRequest::new, GetStoreOperationResponse::new);

    ServiceCallCycles<GetStoreOperationRequest, GetStoreOperationResponse> getStoreOperationHandlers = new ServiceCallCycles<>(getStoreOperation, GetStoreOperation.logger);

    MethodDescriptor<CleanStoreOperationRequest, CleanStoreOperationResponse> cleanStoreOperation = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/CleanStoreOperation", CleanStoreOperationRequest::new, CleanStoreOperationResponse::new);

    ServiceCallCycles<CleanStoreOperationRequest, CleanStoreOperationResponse> cleanStoreOperationHandlers = new ServiceCallCycles<>(cleanStoreOperation, CleanStoreOperation.logger);

    MethodDescriptor<AddStoreOperationRequest, AddStoreOperationResponse> addStoreOperation = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/AddStoreOperation", AddStoreOperationRequest::new, AddStoreOperationResponse::new);

    ServiceCallCycles<AddStoreOperationRequest, AddStoreOperationResponse> addStoreOperationHandlers = new ServiceCallCycles<>(addStoreOperation, AddStoreOperation.logger);

    MethodDescriptor<RemoveStoreOperationRequest, RemoveStoreOperationResponse> removeStoreOperation = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/RemoveStoreOperation", RemoveStoreOperationRequest::new, RemoveStoreOperationResponse::new);

    ServiceCallCycles<RemoveStoreOperationRequest, RemoveStoreOperationResponse> removeStoreOperationHandlers = new ServiceCallCycles<>(removeStoreOperation, RemoveStoreOperation.logger);

    MethodDescriptor<GetRegionCmdRequest, GetRegionCmdResponse> getRegionCmd = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/GetRegionCmd", GetRegionCmdRequest::new, GetRegionCmdResponse::new);

    ServiceCallCycles<GetRegionCmdRequest, GetRegionCmdResponse> getRegionCmdHandlers = new ServiceCallCycles<>(getRegionCmd, GetRegionCmd.logger);

    MethodDescriptor<GetJobListRequest, GetJobListResponse> getJobList = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/GetJobList", GetJobListRequest::new, GetJobListResponse::new);

    ServiceCallCycles<GetJobListRequest, GetJobListResponse> getJobListHandlers = new ServiceCallCycles<>(getJobList, GetJobList.logger);

    MethodDescriptor<CleanJobListRequest, CleanJobListResponse> cleanJobList = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/CleanJobList", CleanJobListRequest::new, CleanJobListResponse::new);

    ServiceCallCycles<CleanJobListRequest, CleanJobListResponse> cleanJobListHandlers = new ServiceCallCycles<>(cleanJobList, CleanJobList.logger);

    MethodDescriptor<UpdateRegionCmdStatusRequest, UpdateRegionCmdStatusResponse> updateRegionCmdStatus = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/UpdateRegionCmdStatus", UpdateRegionCmdStatusRequest::new, UpdateRegionCmdStatusResponse::new);

    ServiceCallCycles<UpdateRegionCmdStatusRequest, UpdateRegionCmdStatusResponse> updateRegionCmdStatusHandlers = new ServiceCallCycles<>(updateRegionCmdStatus, UpdateRegionCmdStatus.logger);

    MethodDescriptor<RaftControlRequest, RaftControlResponse> raftControl = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/RaftControl", RaftControlRequest::new, RaftControlResponse::new);

    ServiceCallCycles<RaftControlRequest, RaftControlResponse> raftControlHandlers = new ServiceCallCycles<>(raftControl, RaftControl.logger);

    MethodDescriptor<UpdateGCSafePointRequest, UpdateGCSafePointResponse> updateGCSafePoint = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/UpdateGCSafePoint", UpdateGCSafePointRequest::new, UpdateGCSafePointResponse::new);

    ServiceCallCycles<UpdateGCSafePointRequest, UpdateGCSafePointResponse> updateGCSafePointHandlers = new ServiceCallCycles<>(updateGCSafePoint, UpdateGCSafePoint.logger);

    MethodDescriptor<GetGCSafePointRequest, GetGCSafePointResponse> getGCSafePoint = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/GetGCSafePoint", GetGCSafePointRequest::new, GetGCSafePointResponse::new);

    ServiceCallCycles<GetGCSafePointRequest, GetGCSafePointResponse> getGCSafePointHandlers = new ServiceCallCycles<>(getGCSafePoint, GetGCSafePoint.logger);

    MethodDescriptor<BalanceLeaderRequest, BalanceLeaderResponse> balanceLeader = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/BalanceLeader", BalanceLeaderRequest::new, BalanceLeaderResponse::new);

    ServiceCallCycles<BalanceLeaderRequest, BalanceLeaderResponse> balanceLeaderHandlers = new ServiceCallCycles<>(balanceLeader, BalanceLeader.logger);

    MethodDescriptor<BalanceRegionRequest, BalanceRegionResponse> balanceRegion = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/BalanceRegion", BalanceRegionRequest::new, BalanceRegionResponse::new);

    ServiceCallCycles<BalanceRegionRequest, BalanceRegionResponse> balanceRegionHandlers = new ServiceCallCycles<>(balanceRegion, BalanceRegion.logger);

    MethodDescriptor<CreateIdsRequest, CreateIdsResponse> createIds = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/CreateIds", CreateIdsRequest::new, CreateIdsResponse::new);

    ServiceCallCycles<CreateIdsRequest, CreateIdsResponse> createIdsHandlers = new ServiceCallCycles<>(createIds, CreateIds.logger);

    MethodDescriptor<MDSHeartbeatRequest, MDSHeartbeatResponse> mDSHeartbeat = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/MDSHeartbeat", MDSHeartbeatRequest::new, MDSHeartbeatResponse::new);

    ServiceCallCycles<MDSHeartbeatRequest, MDSHeartbeatResponse> mDSHeartbeatHandlers = new ServiceCallCycles<>(mDSHeartbeat, MDSHeartbeat.logger);

    MethodDescriptor<GetMDSListRequest, GetMDSListResponse> getMDSList = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/GetMDSList", GetMDSListRequest::new, GetMDSListResponse::new);

    ServiceCallCycles<GetMDSListRequest, GetMDSListResponse> getMDSListHandlers = new ServiceCallCycles<>(getMDSList, GetMDSList.logger);

    MethodDescriptor<RegisterBackupRequest, RegisterBackupResponse> registerBackup = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/RegisterBackup", RegisterBackupRequest::new, RegisterBackupResponse::new);

    ServiceCallCycles<RegisterBackupRequest, RegisterBackupResponse> registerBackupHandlers = new ServiceCallCycles<>(registerBackup, RegisterBackup.logger);

    MethodDescriptor<UnRegisterBackupRequest, UnRegisterBackupResponse> unRegisterBackup = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/UnRegisterBackup", UnRegisterBackupRequest::new, UnRegisterBackupResponse::new);

    ServiceCallCycles<UnRegisterBackupRequest, UnRegisterBackupResponse> unRegisterBackupHandlers = new ServiceCallCycles<>(unRegisterBackup, UnRegisterBackup.logger);

    MethodDescriptor<ControlConfigRequest, ControlConfigResponse> controlConfig = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/ControlConfig", ControlConfigRequest::new, ControlConfigResponse::new);

    ServiceCallCycles<ControlConfigRequest, ControlConfigResponse> controlConfigHandlers = new ServiceCallCycles<>(controlConfig, ControlConfig.logger);

    MethodDescriptor<RegisterBackupStatusRequest, RegisterBackupStatusResponse> registerBackupStatus = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/RegisterBackupStatus", RegisterBackupStatusRequest::new, RegisterBackupStatusResponse::new);

    ServiceCallCycles<RegisterBackupStatusRequest, RegisterBackupStatusResponse> registerBackupStatusHandlers = new ServiceCallCycles<>(registerBackupStatus, RegisterBackupStatus.logger);

    MethodDescriptor<RegisterRestoreRequest, RegisterRestoreResponse> registerRestore = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/RegisterRestore", RegisterRestoreRequest::new, RegisterRestoreResponse::new);

    ServiceCallCycles<RegisterRestoreRequest, RegisterRestoreResponse> registerRestoreHandlers = new ServiceCallCycles<>(registerRestore, RegisterRestore.logger);

    MethodDescriptor<UnRegisterRestoreRequest, UnRegisterRestoreResponse> unRegisterRestore = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/UnRegisterRestore", UnRegisterRestoreRequest::new, UnRegisterRestoreResponse::new);

    ServiceCallCycles<UnRegisterRestoreRequest, UnRegisterRestoreResponse> unRegisterRestoreHandlers = new ServiceCallCycles<>(unRegisterRestore, UnRegisterRestore.logger);

    MethodDescriptor<RegisterRestoreStatusRequest, RegisterRestoreStatusResponse> registerRestoreStatus = ServiceMethodBuilder.buildUnary("dingodb.pb.coordinator.CoordinatorService/RegisterRestoreStatus", RegisterRestoreStatusRequest::new, RegisterRestoreStatusResponse::new);

    ServiceCallCycles<RegisterRestoreStatusRequest, RegisterRestoreStatusResponse> registerRestoreStatusHandlers = new ServiceCallCycles<>(registerRestoreStatus, RegisterRestoreStatus.logger);

    final class Hello {
        public static final Logger logger = LoggerFactory.getLogger(Hello.class);
    }

    final class GetMemoryInfo {
        public static final Logger logger = LoggerFactory.getLogger(GetMemoryInfo.class);
    }

    final class StoreHeartbeat {
        public static final Logger logger = LoggerFactory.getLogger(StoreHeartbeat.class);
    }

    final class GetRegionMap {
        public static final Logger logger = LoggerFactory.getLogger(GetRegionMap.class);
    }

    final class GetDeletedRegionMap {
        public static final Logger logger = LoggerFactory.getLogger(GetDeletedRegionMap.class);
    }

    final class AddDeletedRegionMap {
        public static final Logger logger = LoggerFactory.getLogger(AddDeletedRegionMap.class);
    }

    final class CleanDeletedRegionMap {
        public static final Logger logger = LoggerFactory.getLogger(CleanDeletedRegionMap.class);
    }

    final class GetRegionCount {
        public static final Logger logger = LoggerFactory.getLogger(GetRegionCount.class);
    }

    final class GetStoreMap {
        public static final Logger logger = LoggerFactory.getLogger(GetStoreMap.class);
    }

    final class GetStoreMetrics {
        public static final Logger logger = LoggerFactory.getLogger(GetStoreMetrics.class);
    }

    final class DeleteStoreMetrics {
        public static final Logger logger = LoggerFactory.getLogger(DeleteStoreMetrics.class);
    }

    final class GetRegionMetrics {
        public static final Logger logger = LoggerFactory.getLogger(GetRegionMetrics.class);
    }

    final class DeleteRegionMetrics {
        public static final Logger logger = LoggerFactory.getLogger(DeleteRegionMetrics.class);
    }

    final class CreateStore {
        public static final Logger logger = LoggerFactory.getLogger(CreateStore.class);
    }

    final class DeleteStore {
        public static final Logger logger = LoggerFactory.getLogger(DeleteStore.class);
    }

    final class UpdateStore {
        public static final Logger logger = LoggerFactory.getLogger(UpdateStore.class);
    }

    final class GetStoreOwnMetrics {
        public static final Logger logger = LoggerFactory.getLogger(GetStoreOwnMetrics.class);
    }

    final class ExecutorHeartbeat {
        public static final Logger logger = LoggerFactory.getLogger(ExecutorHeartbeat.class);
    }

    final class CreateExecutor {
        public static final Logger logger = LoggerFactory.getLogger(CreateExecutor.class);
    }

    final class DeleteExecutor {
        public static final Logger logger = LoggerFactory.getLogger(DeleteExecutor.class);
    }

    final class GetExecutorMap {
        public static final Logger logger = LoggerFactory.getLogger(GetExecutorMap.class);
    }

    final class CreateExecutorUser {
        public static final Logger logger = LoggerFactory.getLogger(CreateExecutorUser.class);
    }

    final class DeleteExecutorUser {
        public static final Logger logger = LoggerFactory.getLogger(DeleteExecutorUser.class);
    }

    final class UpdateExecutorUser {
        public static final Logger logger = LoggerFactory.getLogger(UpdateExecutorUser.class);
    }

    final class GetExecutorUserMap {
        public static final Logger logger = LoggerFactory.getLogger(GetExecutorUserMap.class);
    }

    final class GetCoordinatorMap {
        public static final Logger logger = LoggerFactory.getLogger(GetCoordinatorMap.class);
    }

    final class ConfigCoordinator {
        public static final Logger logger = LoggerFactory.getLogger(ConfigCoordinator.class);
    }

    final class CreateRegionId {
        public static final Logger logger = LoggerFactory.getLogger(CreateRegionId.class);
    }

    final class QueryRegion {
        public static final Logger logger = LoggerFactory.getLogger(QueryRegion.class);
    }

    final class CreateRegion {
        public static final Logger logger = LoggerFactory.getLogger(CreateRegion.class);
    }

    final class DropRegion {
        public static final Logger logger = LoggerFactory.getLogger(DropRegion.class);
    }

    final class DropRegionPermanently {
        public static final Logger logger = LoggerFactory.getLogger(DropRegionPermanently.class);
    }

    final class SplitRegion {
        public static final Logger logger = LoggerFactory.getLogger(SplitRegion.class);
    }

    final class MergeRegion {
        public static final Logger logger = LoggerFactory.getLogger(MergeRegion.class);
    }

    final class ChangePeerRegion {
        public static final Logger logger = LoggerFactory.getLogger(ChangePeerRegion.class);
    }

    final class TransferLeaderRegion {
        public static final Logger logger = LoggerFactory.getLogger(TransferLeaderRegion.class);
    }

    final class GetOrphanRegion {
        public static final Logger logger = LoggerFactory.getLogger(GetOrphanRegion.class);
    }

    final class ScanRegions {
        public static final Logger logger = LoggerFactory.getLogger(ScanRegions.class);
    }

    final class GetRangeRegionMap {
        public static final Logger logger = LoggerFactory.getLogger(GetRangeRegionMap.class);
    }

    final class GetStoreOperation {
        public static final Logger logger = LoggerFactory.getLogger(GetStoreOperation.class);
    }

    final class CleanStoreOperation {
        public static final Logger logger = LoggerFactory.getLogger(CleanStoreOperation.class);
    }

    final class AddStoreOperation {
        public static final Logger logger = LoggerFactory.getLogger(AddStoreOperation.class);
    }

    final class RemoveStoreOperation {
        public static final Logger logger = LoggerFactory.getLogger(RemoveStoreOperation.class);
    }

    final class GetRegionCmd {
        public static final Logger logger = LoggerFactory.getLogger(GetRegionCmd.class);
    }

    final class GetJobList {
        public static final Logger logger = LoggerFactory.getLogger(GetJobList.class);
    }

    final class CleanJobList {
        public static final Logger logger = LoggerFactory.getLogger(CleanJobList.class);
    }

    final class UpdateRegionCmdStatus {
        public static final Logger logger = LoggerFactory.getLogger(UpdateRegionCmdStatus.class);
    }

    final class RaftControl {
        public static final Logger logger = LoggerFactory.getLogger(RaftControl.class);
    }

    final class UpdateGCSafePoint {
        public static final Logger logger = LoggerFactory.getLogger(UpdateGCSafePoint.class);
    }

    final class GetGCSafePoint {
        public static final Logger logger = LoggerFactory.getLogger(GetGCSafePoint.class);
    }

    final class BalanceLeader {
        public static final Logger logger = LoggerFactory.getLogger(BalanceLeader.class);
    }

    final class BalanceRegion {
        public static final Logger logger = LoggerFactory.getLogger(BalanceRegion.class);
    }

    final class CreateIds {
        public static final Logger logger = LoggerFactory.getLogger(CreateIds.class);
    }

    final class MDSHeartbeat {
        public static final Logger logger = LoggerFactory.getLogger(MDSHeartbeat.class);
    }

    final class GetMDSList {
        public static final Logger logger = LoggerFactory.getLogger(GetMDSList.class);
    }

    final class RegisterBackup {
        public static final Logger logger = LoggerFactory.getLogger(RegisterBackup.class);
    }

    final class UnRegisterBackup {
        public static final Logger logger = LoggerFactory.getLogger(UnRegisterBackup.class);
    }

    final class ControlConfig {
        public static final Logger logger = LoggerFactory.getLogger(ControlConfig.class);
    }

    final class RegisterBackupStatus {
        public static final Logger logger = LoggerFactory.getLogger(RegisterBackupStatus.class);
    }

    final class RegisterRestore {
        public static final Logger logger = LoggerFactory.getLogger(RegisterRestore.class);
    }

    final class UnRegisterRestore {
        public static final Logger logger = LoggerFactory.getLogger(UnRegisterRestore.class);
    }

    final class RegisterRestoreStatus {
        public static final Logger logger = LoggerFactory.getLogger(RegisterRestoreStatus.class);
    }
}
