package io.dingodb.sdk.service;

import static io.dingodb.sdk.service.desc.version.VersionServiceDescriptors.*;

import io.dingodb.sdk.service.entity.version.CompactionRequest;
import io.dingodb.sdk.service.entity.version.CompactionResponse;
import io.dingodb.sdk.service.entity.version.DeleteRangeRequest;
import io.dingodb.sdk.service.entity.version.DeleteRangeResponse;
import io.dingodb.sdk.service.entity.version.GetCurrVersionRequest;
import io.dingodb.sdk.service.entity.version.GetCurrVersionResponse;
import io.dingodb.sdk.service.entity.version.GetNewVersionRequest;
import io.dingodb.sdk.service.entity.version.GetNewVersionResponse;
import io.dingodb.sdk.service.entity.version.GetRawKvIndexRequest;
import io.dingodb.sdk.service.entity.version.GetRawKvIndexResponse;
import io.dingodb.sdk.service.entity.version.GetRawKvRevRequest;
import io.dingodb.sdk.service.entity.version.GetRawKvRevResponse;
import io.dingodb.sdk.service.entity.version.HelloRequest;
import io.dingodb.sdk.service.entity.version.HelloResponse;
import io.dingodb.sdk.service.entity.version.LeaseGrantRequest;
import io.dingodb.sdk.service.entity.version.LeaseGrantResponse;
import io.dingodb.sdk.service.entity.version.LeaseQueryRequest;
import io.dingodb.sdk.service.entity.version.LeaseQueryResponse;
import io.dingodb.sdk.service.entity.version.LeaseRenewRequest;
import io.dingodb.sdk.service.entity.version.LeaseRenewResponse;
import io.dingodb.sdk.service.entity.version.LeaseRevokeRequest;
import io.dingodb.sdk.service.entity.version.LeaseRevokeResponse;
import io.dingodb.sdk.service.entity.version.ListLeasesRequest;
import io.dingodb.sdk.service.entity.version.ListLeasesResponse;
import io.dingodb.sdk.service.entity.version.PutRequest;
import io.dingodb.sdk.service.entity.version.PutResponse;
import io.dingodb.sdk.service.entity.version.RangeRequest;
import io.dingodb.sdk.service.entity.version.RangeResponse;
import io.dingodb.sdk.service.entity.version.WatchRequest;
import io.dingodb.sdk.service.entity.version.WatchResponse;
import lombok.AllArgsConstructor;
import lombok.Getter;

public interface VersionService extends Service<VersionService> {
    @Deprecated
    default HelloResponse hello(HelloRequest request) {
        return hello(System.identityHashCode(request), request);
    }

    default HelloResponse hello(long requestId, HelloRequest request) {
        return getCaller().call(hello, requestId, request, helloHandlers);
    }

    @Deprecated
    default HelloResponse getMemoryInfo(HelloRequest request) {
        return getMemoryInfo(System.identityHashCode(request), request);
    }

    default HelloResponse getMemoryInfo(long requestId, HelloRequest request) {
        return getCaller().call(getMemoryInfo, requestId, request, getMemoryInfoHandlers);
    }

    @Deprecated
    default GetCurrVersionResponse getCurrVersion(GetCurrVersionRequest request) {
        return getCurrVersion(System.identityHashCode(request), request);
    }

    default GetCurrVersionResponse getCurrVersion(long requestId, GetCurrVersionRequest request) {
        return getCaller().call(getCurrVersion, requestId, request, getCurrVersionHandlers);
    }

    @Deprecated
    default GetNewVersionResponse getNewVersion(GetNewVersionRequest request) {
        return getNewVersion(System.identityHashCode(request), request);
    }

    default GetNewVersionResponse getNewVersion(long requestId, GetNewVersionRequest request) {
        return getCaller().call(getNewVersion, requestId, request, getNewVersionHandlers);
    }

    @Deprecated
    default RangeResponse kvRange(RangeRequest request) {
        return kvRange(System.identityHashCode(request), request);
    }

    default RangeResponse kvRange(long requestId, RangeRequest request) {
        return getCaller().call(kvRange, requestId, request, kvRangeHandlers);
    }

    @Deprecated
    default PutResponse kvPut(PutRequest request) {
        return kvPut(System.identityHashCode(request), request);
    }

    default PutResponse kvPut(long requestId, PutRequest request) {
        return getCaller().call(kvPut, requestId, request, kvPutHandlers);
    }

    @Deprecated
    default DeleteRangeResponse kvDeleteRange(DeleteRangeRequest request) {
        return kvDeleteRange(System.identityHashCode(request), request);
    }

    default DeleteRangeResponse kvDeleteRange(long requestId, DeleteRangeRequest request) {
        return getCaller().call(kvDeleteRange, requestId, request, kvDeleteRangeHandlers);
    }

    @Deprecated
    default CompactionResponse kvCompaction(CompactionRequest request) {
        return kvCompaction(System.identityHashCode(request), request);
    }

    default CompactionResponse kvCompaction(long requestId, CompactionRequest request) {
        return getCaller().call(kvCompaction, requestId, request, kvCompactionHandlers);
    }

    @Deprecated
    default LeaseGrantResponse leaseGrant(LeaseGrantRequest request) {
        return leaseGrant(System.identityHashCode(request), request);
    }

    default LeaseGrantResponse leaseGrant(long requestId, LeaseGrantRequest request) {
        return getCaller().call(leaseGrant, requestId, request, leaseGrantHandlers);
    }

    @Deprecated
    default LeaseRevokeResponse leaseRevoke(LeaseRevokeRequest request) {
        return leaseRevoke(System.identityHashCode(request), request);
    }

    default LeaseRevokeResponse leaseRevoke(long requestId, LeaseRevokeRequest request) {
        return getCaller().call(leaseRevoke, requestId, request, leaseRevokeHandlers);
    }

    @Deprecated
    default LeaseRenewResponse leaseRenew(LeaseRenewRequest request) {
        return leaseRenew(System.identityHashCode(request), request);
    }

    default LeaseRenewResponse leaseRenew(long requestId, LeaseRenewRequest request) {
        return getCaller().call(leaseRenew, requestId, request, leaseRenewHandlers);
    }

    @Deprecated
    default LeaseQueryResponse leaseQuery(LeaseQueryRequest request) {
        return leaseQuery(System.identityHashCode(request), request);
    }

    default LeaseQueryResponse leaseQuery(long requestId, LeaseQueryRequest request) {
        return getCaller().call(leaseQuery, requestId, request, leaseQueryHandlers);
    }

    @Deprecated
    default ListLeasesResponse listLeases(ListLeasesRequest request) {
        return listLeases(System.identityHashCode(request), request);
    }

    default ListLeasesResponse listLeases(long requestId, ListLeasesRequest request) {
        return getCaller().call(listLeases, requestId, request, listLeasesHandlers);
    }

    @Deprecated
    default WatchResponse watch(WatchRequest request) {
        return watch(System.identityHashCode(request), request);
    }

    default WatchResponse watch(long requestId, WatchRequest request) {
        return getCaller().call(watch, requestId, request, watchHandlers);
    }

    @Deprecated
    default GetRawKvIndexResponse getRawKvIndex(GetRawKvIndexRequest request) {
        return getRawKvIndex(System.identityHashCode(request), request);
    }

    default GetRawKvIndexResponse getRawKvIndex(long requestId, GetRawKvIndexRequest request) {
        return getCaller().call(getRawKvIndex, requestId, request, getRawKvIndexHandlers);
    }

    @Deprecated
    default GetRawKvRevResponse getRawKvRev(GetRawKvRevRequest request) {
        return getRawKvRev(System.identityHashCode(request), request);
    }

    default GetRawKvRevResponse getRawKvRev(long requestId, GetRawKvRevRequest request) {
        return getCaller().call(getRawKvRev, requestId, request, getRawKvRevHandlers);
    }

    Caller<VersionService> getCaller();

    @Getter
    @AllArgsConstructor
    class Impl implements VersionService {
        public final Caller<VersionService> caller;
    }
}
