package io.dingodb.sdk.service;

import static io.dingodb.sdk.service.desc.util.UtilServiceDescriptors.*;

import io.dingodb.sdk.service.entity.index.VectorCalcDistanceRequest;
import io.dingodb.sdk.service.entity.index.VectorCalcDistanceResponse;
import lombok.AllArgsConstructor;
import lombok.Getter;

public interface UtilService extends Service<UtilService> {
    @Deprecated
    default VectorCalcDistanceResponse vectorCalcDistance(VectorCalcDistanceRequest request) {
        return vectorCalcDistance(System.identityHashCode(request), request);
    }

    default VectorCalcDistanceResponse vectorCalcDistance(long requestId,
            VectorCalcDistanceRequest request) {
        return getCaller().call(vectorCalcDistance, requestId, request, vectorCalcDistanceHandlers);
    }

    Caller<UtilService> getCaller();

    @Getter
    @AllArgsConstructor
    class Impl implements UtilService {
        public final Caller<UtilService> caller;
    }
}
