package io.dingodb.sdk.service;

import static io.dingodb.sdk.service.desc.store.StoreServiceDescriptors.*;

import io.dingodb.sdk.service.entity.store.BackupDataRequest;
import io.dingodb.sdk.service.entity.store.BackupDataResponse;
import io.dingodb.sdk.service.entity.store.BackupMetaRequest;
import io.dingodb.sdk.service.entity.store.BackupMetaResponse;
import io.dingodb.sdk.service.entity.store.ControlConfigRequest;
import io.dingodb.sdk.service.entity.store.ControlConfigResponse;
import io.dingodb.sdk.service.entity.store.HelloRequest;
import io.dingodb.sdk.service.entity.store.HelloResponse;
import io.dingodb.sdk.service.entity.store.KvBatchCompareAndSetRequest;
import io.dingodb.sdk.service.entity.store.KvBatchCompareAndSetResponse;
import io.dingodb.sdk.service.entity.store.KvBatchDeleteRequest;
import io.dingodb.sdk.service.entity.store.KvBatchDeleteResponse;
import io.dingodb.sdk.service.entity.store.KvBatchGetRequest;
import io.dingodb.sdk.service.entity.store.KvBatchGetResponse;
import io.dingodb.sdk.service.entity.store.KvBatchPutIfAbsentRequest;
import io.dingodb.sdk.service.entity.store.KvBatchPutIfAbsentResponse;
import io.dingodb.sdk.service.entity.store.KvBatchPutRequest;
import io.dingodb.sdk.service.entity.store.KvBatchPutResponse;
import io.dingodb.sdk.service.entity.store.KvCompareAndSetRequest;
import io.dingodb.sdk.service.entity.store.KvCompareAndSetResponse;
import io.dingodb.sdk.service.entity.store.KvDeleteRangeRequest;
import io.dingodb.sdk.service.entity.store.KvDeleteRangeResponse;
import io.dingodb.sdk.service.entity.store.KvGetRequest;
import io.dingodb.sdk.service.entity.store.KvGetResponse;
import io.dingodb.sdk.service.entity.store.KvPutIfAbsentRequest;
import io.dingodb.sdk.service.entity.store.KvPutIfAbsentResponse;
import io.dingodb.sdk.service.entity.store.KvPutRequest;
import io.dingodb.sdk.service.entity.store.KvPutResponse;
import io.dingodb.sdk.service.entity.store.KvScanBeginRequest;
import io.dingodb.sdk.service.entity.store.KvScanBeginRequestV2;
import io.dingodb.sdk.service.entity.store.KvScanBeginResponse;
import io.dingodb.sdk.service.entity.store.KvScanBeginResponseV2;
import io.dingodb.sdk.service.entity.store.KvScanContinueRequest;
import io.dingodb.sdk.service.entity.store.KvScanContinueRequestV2;
import io.dingodb.sdk.service.entity.store.KvScanContinueResponse;
import io.dingodb.sdk.service.entity.store.KvScanContinueResponseV2;
import io.dingodb.sdk.service.entity.store.KvScanReleaseRequest;
import io.dingodb.sdk.service.entity.store.KvScanReleaseRequestV2;
import io.dingodb.sdk.service.entity.store.KvScanReleaseResponse;
import io.dingodb.sdk.service.entity.store.KvScanReleaseResponseV2;
import io.dingodb.sdk.service.entity.store.RestoreDataRequest;
import io.dingodb.sdk.service.entity.store.RestoreDataResponse;
import io.dingodb.sdk.service.entity.store.RestoreMetaRequest;
import io.dingodb.sdk.service.entity.store.RestoreMetaResponse;
import io.dingodb.sdk.service.entity.store.TxnBatchGetRequest;
import io.dingodb.sdk.service.entity.store.TxnBatchGetResponse;
import io.dingodb.sdk.service.entity.store.TxnBatchRollbackRequest;
import io.dingodb.sdk.service.entity.store.TxnBatchRollbackResponse;
import io.dingodb.sdk.service.entity.store.TxnCheckSecondaryLocksRequest;
import io.dingodb.sdk.service.entity.store.TxnCheckSecondaryLocksResponse;
import io.dingodb.sdk.service.entity.store.TxnCheckTxnStatusRequest;
import io.dingodb.sdk.service.entity.store.TxnCheckTxnStatusResponse;
import io.dingodb.sdk.service.entity.store.TxnCommitRequest;
import io.dingodb.sdk.service.entity.store.TxnCommitResponse;
import io.dingodb.sdk.service.entity.store.TxnDeleteRangeRequest;
import io.dingodb.sdk.service.entity.store.TxnDeleteRangeResponse;
import io.dingodb.sdk.service.entity.store.TxnDumpRequest;
import io.dingodb.sdk.service.entity.store.TxnDumpResponse;
import io.dingodb.sdk.service.entity.store.TxnGcRequest;
import io.dingodb.sdk.service.entity.store.TxnGcResponse;
import io.dingodb.sdk.service.entity.store.TxnGetRequest;
import io.dingodb.sdk.service.entity.store.TxnGetResponse;
import io.dingodb.sdk.service.entity.store.TxnHeartBeatRequest;
import io.dingodb.sdk.service.entity.store.TxnHeartBeatResponse;
import io.dingodb.sdk.service.entity.store.TxnPessimisticLockRequest;
import io.dingodb.sdk.service.entity.store.TxnPessimisticLockResponse;
import io.dingodb.sdk.service.entity.store.TxnPessimisticRollbackRequest;
import io.dingodb.sdk.service.entity.store.TxnPessimisticRollbackResponse;
import io.dingodb.sdk.service.entity.store.TxnPrewriteRequest;
import io.dingodb.sdk.service.entity.store.TxnPrewriteResponse;
import io.dingodb.sdk.service.entity.store.TxnResolveLockRequest;
import io.dingodb.sdk.service.entity.store.TxnResolveLockResponse;
import io.dingodb.sdk.service.entity.store.TxnScanLockRequest;
import io.dingodb.sdk.service.entity.store.TxnScanLockResponse;
import io.dingodb.sdk.service.entity.store.TxnScanRequest;
import io.dingodb.sdk.service.entity.store.TxnScanResponse;
import lombok.AllArgsConstructor;
import lombok.Getter;

public interface StoreService extends Service<StoreService> {
    @Deprecated
    default HelloResponse hello(HelloRequest request) {
        return hello(System.identityHashCode(request), request);
    }

    default HelloResponse hello(long requestId, HelloRequest request) {
        return getCaller().call(hello, requestId, request, helloHandlers);
    }

    @Deprecated
    default HelloResponse getMemoryInfo(HelloRequest request) {
        return getMemoryInfo(System.identityHashCode(request), request);
    }

    default HelloResponse getMemoryInfo(long requestId, HelloRequest request) {
        return getCaller().call(getMemoryInfo, requestId, request, getMemoryInfoHandlers);
    }

    @Deprecated
    default KvGetResponse kvGet(KvGetRequest request) {
        return kvGet(System.identityHashCode(request), request);
    }

    default KvGetResponse kvGet(long requestId, KvGetRequest request) {
        return getCaller().call(kvGet, requestId, request, kvGetHandlers);
    }

    @Deprecated
    default KvBatchGetResponse kvBatchGet(KvBatchGetRequest request) {
        return kvBatchGet(System.identityHashCode(request), request);
    }

    default KvBatchGetResponse kvBatchGet(long requestId, KvBatchGetRequest request) {
        return getCaller().call(kvBatchGet, requestId, request, kvBatchGetHandlers);
    }

    @Deprecated
    default KvPutResponse kvPut(KvPutRequest request) {
        return kvPut(System.identityHashCode(request), request);
    }

    default KvPutResponse kvPut(long requestId, KvPutRequest request) {
        return getCaller().call(kvPut, requestId, request, kvPutHandlers);
    }

    @Deprecated
    default KvBatchPutResponse kvBatchPut(KvBatchPutRequest request) {
        return kvBatchPut(System.identityHashCode(request), request);
    }

    default KvBatchPutResponse kvBatchPut(long requestId, KvBatchPutRequest request) {
        return getCaller().call(kvBatchPut, requestId, request, kvBatchPutHandlers);
    }

    @Deprecated
    default KvPutIfAbsentResponse kvPutIfAbsent(KvPutIfAbsentRequest request) {
        return kvPutIfAbsent(System.identityHashCode(request), request);
    }

    default KvPutIfAbsentResponse kvPutIfAbsent(long requestId, KvPutIfAbsentRequest request) {
        return getCaller().call(kvPutIfAbsent, requestId, request, kvPutIfAbsentHandlers);
    }

    @Deprecated
    default KvBatchPutIfAbsentResponse kvBatchPutIfAbsent(KvBatchPutIfAbsentRequest request) {
        return kvBatchPutIfAbsent(System.identityHashCode(request), request);
    }

    default KvBatchPutIfAbsentResponse kvBatchPutIfAbsent(long requestId,
            KvBatchPutIfAbsentRequest request) {
        return getCaller().call(kvBatchPutIfAbsent, requestId, request, kvBatchPutIfAbsentHandlers);
    }

    @Deprecated
    default KvBatchDeleteResponse kvBatchDelete(KvBatchDeleteRequest request) {
        return kvBatchDelete(System.identityHashCode(request), request);
    }

    default KvBatchDeleteResponse kvBatchDelete(long requestId, KvBatchDeleteRequest request) {
        return getCaller().call(kvBatchDelete, requestId, request, kvBatchDeleteHandlers);
    }

    @Deprecated
    default KvDeleteRangeResponse kvDeleteRange(KvDeleteRangeRequest request) {
        return kvDeleteRange(System.identityHashCode(request), request);
    }

    default KvDeleteRangeResponse kvDeleteRange(long requestId, KvDeleteRangeRequest request) {
        return getCaller().call(kvDeleteRange, requestId, request, kvDeleteRangeHandlers);
    }

    @Deprecated
    default KvCompareAndSetResponse kvCompareAndSet(KvCompareAndSetRequest request) {
        return kvCompareAndSet(System.identityHashCode(request), request);
    }

    default KvCompareAndSetResponse kvCompareAndSet(long requestId,
            KvCompareAndSetRequest request) {
        return getCaller().call(kvCompareAndSet, requestId, request, kvCompareAndSetHandlers);
    }

    @Deprecated
    default KvBatchCompareAndSetResponse kvBatchCompareAndSet(KvBatchCompareAndSetRequest request) {
        return kvBatchCompareAndSet(System.identityHashCode(request), request);
    }

    default KvBatchCompareAndSetResponse kvBatchCompareAndSet(long requestId,
            KvBatchCompareAndSetRequest request) {
        return getCaller().call(kvBatchCompareAndSet, requestId, request, kvBatchCompareAndSetHandlers);
    }

    @Deprecated
    default KvScanBeginResponse kvScanBegin(KvScanBeginRequest request) {
        return kvScanBegin(System.identityHashCode(request), request);
    }

    default KvScanBeginResponse kvScanBegin(long requestId, KvScanBeginRequest request) {
        return getCaller().call(kvScanBegin, requestId, request, kvScanBeginHandlers);
    }

    @Deprecated
    default KvScanContinueResponse kvScanContinue(KvScanContinueRequest request) {
        return kvScanContinue(System.identityHashCode(request), request);
    }

    default KvScanContinueResponse kvScanContinue(long requestId, KvScanContinueRequest request) {
        return getCaller().call(kvScanContinue, requestId, request, kvScanContinueHandlers);
    }

    @Deprecated
    default KvScanReleaseResponse kvScanRelease(KvScanReleaseRequest request) {
        return kvScanRelease(System.identityHashCode(request), request);
    }

    default KvScanReleaseResponse kvScanRelease(long requestId, KvScanReleaseRequest request) {
        return getCaller().call(kvScanRelease, requestId, request, kvScanReleaseHandlers);
    }

    @Deprecated
    default KvScanBeginResponseV2 kvScanBeginV2(KvScanBeginRequestV2 request) {
        return kvScanBeginV2(System.identityHashCode(request), request);
    }

    default KvScanBeginResponseV2 kvScanBeginV2(long requestId, KvScanBeginRequestV2 request) {
        return getCaller().call(kvScanBeginV2, requestId, request, kvScanBeginV2Handlers);
    }

    @Deprecated
    default KvScanContinueResponseV2 kvScanContinueV2(KvScanContinueRequestV2 request) {
        return kvScanContinueV2(System.identityHashCode(request), request);
    }

    default KvScanContinueResponseV2 kvScanContinueV2(long requestId,
            KvScanContinueRequestV2 request) {
        return getCaller().call(kvScanContinueV2, requestId, request, kvScanContinueV2Handlers);
    }

    @Deprecated
    default KvScanReleaseResponseV2 kvScanReleaseV2(KvScanReleaseRequestV2 request) {
        return kvScanReleaseV2(System.identityHashCode(request), request);
    }

    default KvScanReleaseResponseV2 kvScanReleaseV2(long requestId,
            KvScanReleaseRequestV2 request) {
        return getCaller().call(kvScanReleaseV2, requestId, request, kvScanReleaseV2Handlers);
    }

    @Deprecated
    default TxnGetResponse txnGet(TxnGetRequest request) {
        return txnGet(System.identityHashCode(request), request);
    }

    default TxnGetResponse txnGet(long requestId, TxnGetRequest request) {
        return getCaller().call(txnGet, requestId, request, txnGetHandlers);
    }

    @Deprecated
    default TxnBatchGetResponse txnBatchGet(TxnBatchGetRequest request) {
        return txnBatchGet(System.identityHashCode(request), request);
    }

    default TxnBatchGetResponse txnBatchGet(long requestId, TxnBatchGetRequest request) {
        return getCaller().call(txnBatchGet, requestId, request, txnBatchGetHandlers);
    }

    @Deprecated
    default TxnScanResponse txnScan(TxnScanRequest request) {
        return txnScan(System.identityHashCode(request), request);
    }

    default TxnScanResponse txnScan(long requestId, TxnScanRequest request) {
        return getCaller().call(txnScan, requestId, request, txnScanHandlers);
    }

    @Deprecated
    default TxnDumpResponse txnDump(TxnDumpRequest request) {
        return txnDump(System.identityHashCode(request), request);
    }

    default TxnDumpResponse txnDump(long requestId, TxnDumpRequest request) {
        return getCaller().call(txnDump, requestId, request, txnDumpHandlers);
    }

    @Deprecated
    default TxnPessimisticLockResponse txnPessimisticLock(TxnPessimisticLockRequest request) {
        return txnPessimisticLock(System.identityHashCode(request), request);
    }

    default TxnPessimisticLockResponse txnPessimisticLock(long requestId,
            TxnPessimisticLockRequest request) {
        return getCaller().call(txnPessimisticLock, requestId, request, txnPessimisticLockHandlers);
    }

    @Deprecated
    default TxnPessimisticRollbackResponse txnPessimisticRollback(
            TxnPessimisticRollbackRequest request) {
        return txnPessimisticRollback(System.identityHashCode(request), request);
    }

    default TxnPessimisticRollbackResponse txnPessimisticRollback(long requestId,
            TxnPessimisticRollbackRequest request) {
        return getCaller().call(txnPessimisticRollback, requestId, request, txnPessimisticRollbackHandlers);
    }

    @Deprecated
    default TxnPrewriteResponse txnPrewrite(TxnPrewriteRequest request) {
        return txnPrewrite(System.identityHashCode(request), request);
    }

    default TxnPrewriteResponse txnPrewrite(long requestId, TxnPrewriteRequest request) {
        return getCaller().call(txnPrewrite, requestId, request, txnPrewriteHandlers);
    }

    @Deprecated
    default TxnCommitResponse txnCommit(TxnCommitRequest request) {
        return txnCommit(System.identityHashCode(request), request);
    }

    default TxnCommitResponse txnCommit(long requestId, TxnCommitRequest request) {
        return getCaller().call(txnCommit, requestId, request, txnCommitHandlers);
    }

    @Deprecated
    default TxnCheckTxnStatusResponse txnCheckTxnStatus(TxnCheckTxnStatusRequest request) {
        return txnCheckTxnStatus(System.identityHashCode(request), request);
    }

    default TxnCheckTxnStatusResponse txnCheckTxnStatus(long requestId,
            TxnCheckTxnStatusRequest request) {
        return getCaller().call(txnCheckTxnStatus, requestId, request, txnCheckTxnStatusHandlers);
    }

    @Deprecated
    default TxnResolveLockResponse txnResolveLock(TxnResolveLockRequest request) {
        return txnResolveLock(System.identityHashCode(request), request);
    }

    default TxnResolveLockResponse txnResolveLock(long requestId, TxnResolveLockRequest request) {
        return getCaller().call(txnResolveLock, requestId, request, txnResolveLockHandlers);
    }

    @Deprecated
    default TxnBatchRollbackResponse txnBatchRollback(TxnBatchRollbackRequest request) {
        return txnBatchRollback(System.identityHashCode(request), request);
    }

    default TxnBatchRollbackResponse txnBatchRollback(long requestId,
            TxnBatchRollbackRequest request) {
        return getCaller().call(txnBatchRollback, requestId, request, txnBatchRollbackHandlers);
    }

    @Deprecated
    default TxnScanLockResponse txnScanLock(TxnScanLockRequest request) {
        return txnScanLock(System.identityHashCode(request), request);
    }

    default TxnScanLockResponse txnScanLock(long requestId, TxnScanLockRequest request) {
        return getCaller().call(txnScanLock, requestId, request, txnScanLockHandlers);
    }

    @Deprecated
    default TxnHeartBeatResponse txnHeartBeat(TxnHeartBeatRequest request) {
        return txnHeartBeat(System.identityHashCode(request), request);
    }

    default TxnHeartBeatResponse txnHeartBeat(long requestId, TxnHeartBeatRequest request) {
        return getCaller().call(txnHeartBeat, requestId, request, txnHeartBeatHandlers);
    }

    @Deprecated
    default TxnGcResponse txnGc(TxnGcRequest request) {
        return txnGc(System.identityHashCode(request), request);
    }

    default TxnGcResponse txnGc(long requestId, TxnGcRequest request) {
        return getCaller().call(txnGc, requestId, request, txnGcHandlers);
    }

    @Deprecated
    default TxnDeleteRangeResponse txnDeleteRange(TxnDeleteRangeRequest request) {
        return txnDeleteRange(System.identityHashCode(request), request);
    }

    default TxnDeleteRangeResponse txnDeleteRange(long requestId, TxnDeleteRangeRequest request) {
        return getCaller().call(txnDeleteRange, requestId, request, txnDeleteRangeHandlers);
    }

    @Deprecated
    default TxnCheckSecondaryLocksResponse txnCheckSecondaryLocks(
            TxnCheckSecondaryLocksRequest request) {
        return txnCheckSecondaryLocks(System.identityHashCode(request), request);
    }

    default TxnCheckSecondaryLocksResponse txnCheckSecondaryLocks(long requestId,
            TxnCheckSecondaryLocksRequest request) {
        return getCaller().call(txnCheckSecondaryLocks, requestId, request, txnCheckSecondaryLocksHandlers);
    }

    @Deprecated
    default BackupDataResponse backupData(BackupDataRequest request) {
        return backupData(System.identityHashCode(request), request);
    }

    default BackupDataResponse backupData(long requestId, BackupDataRequest request) {
        return getCaller().call(backupData, requestId, request, backupDataHandlers);
    }

    @Deprecated
    default BackupMetaResponse backupMeta(BackupMetaRequest request) {
        return backupMeta(System.identityHashCode(request), request);
    }

    default BackupMetaResponse backupMeta(long requestId, BackupMetaRequest request) {
        return getCaller().call(backupMeta, requestId, request, backupMetaHandlers);
    }

    @Deprecated
    default ControlConfigResponse controlConfig(ControlConfigRequest request) {
        return controlConfig(System.identityHashCode(request), request);
    }

    default ControlConfigResponse controlConfig(long requestId, ControlConfigRequest request) {
        return getCaller().call(controlConfig, requestId, request, controlConfigHandlers);
    }

    @Deprecated
    default RestoreDataResponse restoreData(RestoreDataRequest request) {
        return restoreData(System.identityHashCode(request), request);
    }

    default RestoreDataResponse restoreData(long requestId, RestoreDataRequest request) {
        return getCaller().call(restoreData, requestId, request, restoreDataHandlers);
    }

    @Deprecated
    default RestoreMetaResponse restoreMeta(RestoreMetaRequest request) {
        return restoreMeta(System.identityHashCode(request), request);
    }

    default RestoreMetaResponse restoreMeta(long requestId, RestoreMetaRequest request) {
        return getCaller().call(restoreMeta, requestId, request, restoreMetaHandlers);
    }

    Caller<StoreService> getCaller();

    @Getter
    @AllArgsConstructor
    class Impl implements StoreService {
        public final Caller<StoreService> caller;
    }
}
