package io.dingodb.sdk.service;

import static io.dingodb.sdk.service.desc.coordinator.PushServiceDescriptors.*;

import io.dingodb.sdk.service.entity.coordinator.PushHeartbeatRequest;
import io.dingodb.sdk.service.entity.coordinator.PushHeartbeatResponse;
import io.dingodb.sdk.service.entity.coordinator.PushStoreOperationRequest;
import io.dingodb.sdk.service.entity.coordinator.PushStoreOperationResponse;
import lombok.AllArgsConstructor;
import lombok.Getter;

public interface PushService extends Service<PushService> {
    @Deprecated
    default PushHeartbeatResponse pushHeartbeat(PushHeartbeatRequest request) {
        return pushHeartbeat(System.identityHashCode(request), request);
    }

    default PushHeartbeatResponse pushHeartbeat(long requestId, PushHeartbeatRequest request) {
        return getCaller().call(pushHeartbeat, requestId, request, pushHeartbeatHandlers);
    }

    @Deprecated
    default PushStoreOperationResponse pushStoreOperation(PushStoreOperationRequest request) {
        return pushStoreOperation(System.identityHashCode(request), request);
    }

    default PushStoreOperationResponse pushStoreOperation(long requestId,
            PushStoreOperationRequest request) {
        return getCaller().call(pushStoreOperation, requestId, request, pushStoreOperationHandlers);
    }

    Caller<PushService> getCaller();

    @Getter
    @AllArgsConstructor
    class Impl implements PushService {
        public final Caller<PushService> caller;
    }
}
