package io.dingodb.sdk.service;

import static io.dingodb.sdk.service.desc.node.NodeServiceDescriptors.*;

import io.dingodb.sdk.service.entity.node.ChangeLogLevelRequest;
import io.dingodb.sdk.service.entity.node.ChangeLogLevelResponse;
import io.dingodb.sdk.service.entity.node.CheckVectorIndexRequest;
import io.dingodb.sdk.service.entity.node.CheckVectorIndexResponse;
import io.dingodb.sdk.service.entity.node.CommitMergeRequest;
import io.dingodb.sdk.service.entity.node.CommitMergeResponse;
import io.dingodb.sdk.service.entity.node.DeleteFailPointRequest;
import io.dingodb.sdk.service.entity.node.DeleteFailPointResponse;
import io.dingodb.sdk.service.entity.node.GetFailPointRequest;
import io.dingodb.sdk.service.entity.node.GetFailPointResponse;
import io.dingodb.sdk.service.entity.node.GetLogLevelRequest;
import io.dingodb.sdk.service.entity.node.GetLogLevelResponse;
import io.dingodb.sdk.service.entity.node.GetMemoryStatsRequest;
import io.dingodb.sdk.service.entity.node.GetMemoryStatsResponse;
import io.dingodb.sdk.service.entity.node.GetNodeInfoRequest;
import io.dingodb.sdk.service.entity.node.GetNodeInfoResponse;
import io.dingodb.sdk.service.entity.node.GetRaftStatusRequest;
import io.dingodb.sdk.service.entity.node.GetRaftStatusResponse;
import io.dingodb.sdk.service.entity.node.GetRegionInfoRequest;
import io.dingodb.sdk.service.entity.node.GetRegionInfoResponse;
import io.dingodb.sdk.service.entity.node.GetVectorIndexSnapshotRequest;
import io.dingodb.sdk.service.entity.node.GetVectorIndexSnapshotResponse;
import io.dingodb.sdk.service.entity.node.InstallVectorIndexSnapshotRequest;
import io.dingodb.sdk.service.entity.node.InstallVectorIndexSnapshotResponse;
import io.dingodb.sdk.service.entity.node.MetricsRequest;
import io.dingodb.sdk.service.entity.node.MetricsResponse;
import io.dingodb.sdk.service.entity.node.ReleaseFreeMemoryRequest;
import io.dingodb.sdk.service.entity.node.ReleaseFreeMemoryResponse;
import io.dingodb.sdk.service.entity.node.SetFailPointRequest;
import io.dingodb.sdk.service.entity.node.SetFailPointResponse;
import lombok.AllArgsConstructor;
import lombok.Getter;

public interface NodeService extends Service<NodeService> {
    @Deprecated
    default GetNodeInfoResponse getNodeInfo(GetNodeInfoRequest request) {
        return getNodeInfo(System.identityHashCode(request), request);
    }

    default GetNodeInfoResponse getNodeInfo(long requestId, GetNodeInfoRequest request) {
        return getCaller().call(getNodeInfo, requestId, request, getNodeInfoHandlers);
    }

    @Deprecated
    default GetRegionInfoResponse getRegionInfo(GetRegionInfoRequest request) {
        return getRegionInfo(System.identityHashCode(request), request);
    }

    default GetRegionInfoResponse getRegionInfo(long requestId, GetRegionInfoRequest request) {
        return getCaller().call(getRegionInfo, requestId, request, getRegionInfoHandlers);
    }

    @Deprecated
    default GetRaftStatusResponse getRaftStatus(GetRaftStatusRequest request) {
        return getRaftStatus(System.identityHashCode(request), request);
    }

    default GetRaftStatusResponse getRaftStatus(long requestId, GetRaftStatusRequest request) {
        return getCaller().call(getRaftStatus, requestId, request, getRaftStatusHandlers);
    }

    @Deprecated
    default GetLogLevelResponse getLogLevel(GetLogLevelRequest request) {
        return getLogLevel(System.identityHashCode(request), request);
    }

    default GetLogLevelResponse getLogLevel(long requestId, GetLogLevelRequest request) {
        return getCaller().call(getLogLevel, requestId, request, getLogLevelHandlers);
    }

    @Deprecated
    default ChangeLogLevelResponse changeLogLevel(ChangeLogLevelRequest request) {
        return changeLogLevel(System.identityHashCode(request), request);
    }

    default ChangeLogLevelResponse changeLogLevel(long requestId, ChangeLogLevelRequest request) {
        return getCaller().call(changeLogLevel, requestId, request, changeLogLevelHandlers);
    }

    @Deprecated
    default MetricsResponse dingoMetrics(MetricsRequest request) {
        return dingoMetrics(System.identityHashCode(request), request);
    }

    default MetricsResponse dingoMetrics(long requestId, MetricsRequest request) {
        return getCaller().call(dingoMetrics, requestId, request, dingoMetricsHandlers);
    }

    @Deprecated
    default SetFailPointResponse setFailPoint(SetFailPointRequest request) {
        return setFailPoint(System.identityHashCode(request), request);
    }

    default SetFailPointResponse setFailPoint(long requestId, SetFailPointRequest request) {
        return getCaller().call(setFailPoint, requestId, request, setFailPointHandlers);
    }

    @Deprecated
    default GetFailPointResponse getFailPoints(GetFailPointRequest request) {
        return getFailPoints(System.identityHashCode(request), request);
    }

    default GetFailPointResponse getFailPoints(long requestId, GetFailPointRequest request) {
        return getCaller().call(getFailPoints, requestId, request, getFailPointsHandlers);
    }

    @Deprecated
    default DeleteFailPointResponse deleteFailPoints(DeleteFailPointRequest request) {
        return deleteFailPoints(System.identityHashCode(request), request);
    }

    default DeleteFailPointResponse deleteFailPoints(long requestId,
            DeleteFailPointRequest request) {
        return getCaller().call(deleteFailPoints, requestId, request, deleteFailPointsHandlers);
    }

    @Deprecated
    default InstallVectorIndexSnapshotResponse installVectorIndexSnapshot(
            InstallVectorIndexSnapshotRequest request) {
        return installVectorIndexSnapshot(System.identityHashCode(request), request);
    }

    default InstallVectorIndexSnapshotResponse installVectorIndexSnapshot(long requestId,
            InstallVectorIndexSnapshotRequest request) {
        return getCaller().call(installVectorIndexSnapshot, requestId, request, installVectorIndexSnapshotHandlers);
    }

    @Deprecated
    default GetVectorIndexSnapshotResponse getVectorIndexSnapshot(
            GetVectorIndexSnapshotRequest request) {
        return getVectorIndexSnapshot(System.identityHashCode(request), request);
    }

    default GetVectorIndexSnapshotResponse getVectorIndexSnapshot(long requestId,
            GetVectorIndexSnapshotRequest request) {
        return getCaller().call(getVectorIndexSnapshot, requestId, request, getVectorIndexSnapshotHandlers);
    }

    @Deprecated
    default CheckVectorIndexResponse checkVectorIndex(CheckVectorIndexRequest request) {
        return checkVectorIndex(System.identityHashCode(request), request);
    }

    default CheckVectorIndexResponse checkVectorIndex(long requestId,
            CheckVectorIndexRequest request) {
        return getCaller().call(checkVectorIndex, requestId, request, checkVectorIndexHandlers);
    }

    @Deprecated
    default CommitMergeResponse commitMerge(CommitMergeRequest request) {
        return commitMerge(System.identityHashCode(request), request);
    }

    default CommitMergeResponse commitMerge(long requestId, CommitMergeRequest request) {
        return getCaller().call(commitMerge, requestId, request, commitMergeHandlers);
    }

    @Deprecated
    default GetMemoryStatsResponse getMemoryStats(GetMemoryStatsRequest request) {
        return getMemoryStats(System.identityHashCode(request), request);
    }

    default GetMemoryStatsResponse getMemoryStats(long requestId, GetMemoryStatsRequest request) {
        return getCaller().call(getMemoryStats, requestId, request, getMemoryStatsHandlers);
    }

    @Deprecated
    default ReleaseFreeMemoryResponse releaseFreeMemory(ReleaseFreeMemoryRequest request) {
        return releaseFreeMemory(System.identityHashCode(request), request);
    }

    default ReleaseFreeMemoryResponse releaseFreeMemory(long requestId,
            ReleaseFreeMemoryRequest request) {
        return getCaller().call(releaseFreeMemory, requestId, request, releaseFreeMemoryHandlers);
    }

    Caller<NodeService> getCaller();

    @Getter
    @AllArgsConstructor
    class Impl implements NodeService {
        public final Caller<NodeService> caller;
    }
}
