package io.dingodb.sdk.service;

import static io.dingodb.sdk.service.desc.meta.MetaServiceDescriptors.*;

import io.dingodb.sdk.service.entity.meta.AddIndexOnTableRequest;
import io.dingodb.sdk.service.entity.meta.AddIndexOnTableResponse;
import io.dingodb.sdk.service.entity.meta.CleanDeletedIndexRequest;
import io.dingodb.sdk.service.entity.meta.CleanDeletedIndexResponse;
import io.dingodb.sdk.service.entity.meta.CleanDeletedTableRequest;
import io.dingodb.sdk.service.entity.meta.CleanDeletedTableResponse;
import io.dingodb.sdk.service.entity.meta.CreateAutoIncrementRequest;
import io.dingodb.sdk.service.entity.meta.CreateAutoIncrementResponse;
import io.dingodb.sdk.service.entity.meta.CreateAutoIncrementsRequest;
import io.dingodb.sdk.service.entity.meta.CreateAutoIncrementsResponse;
import io.dingodb.sdk.service.entity.meta.CreateIndexIdRequest;
import io.dingodb.sdk.service.entity.meta.CreateIndexIdResponse;
import io.dingodb.sdk.service.entity.meta.CreateIndexMetasRequest;
import io.dingodb.sdk.service.entity.meta.CreateIndexMetasResponse;
import io.dingodb.sdk.service.entity.meta.CreateIndexRequest;
import io.dingodb.sdk.service.entity.meta.CreateIndexResponse;
import io.dingodb.sdk.service.entity.meta.CreateOrUpdateAutoIncrementsRequest;
import io.dingodb.sdk.service.entity.meta.CreateOrUpdateAutoIncrementsResponse;
import io.dingodb.sdk.service.entity.meta.CreateSchemaRequest;
import io.dingodb.sdk.service.entity.meta.CreateSchemaResponse;
import io.dingodb.sdk.service.entity.meta.CreateSchemasRequest;
import io.dingodb.sdk.service.entity.meta.CreateSchemasResponse;
import io.dingodb.sdk.service.entity.meta.CreateTableIdRequest;
import io.dingodb.sdk.service.entity.meta.CreateTableIdResponse;
import io.dingodb.sdk.service.entity.meta.CreateTableIdsRequest;
import io.dingodb.sdk.service.entity.meta.CreateTableIdsResponse;
import io.dingodb.sdk.service.entity.meta.CreateTableRequest;
import io.dingodb.sdk.service.entity.meta.CreateTableResponse;
import io.dingodb.sdk.service.entity.meta.CreateTablesRequest;
import io.dingodb.sdk.service.entity.meta.CreateTablesResponse;
import io.dingodb.sdk.service.entity.meta.CreateTenantRequest;
import io.dingodb.sdk.service.entity.meta.CreateTenantResponse;
import io.dingodb.sdk.service.entity.meta.CreateTenantsRequest;
import io.dingodb.sdk.service.entity.meta.CreateTenantsResponse;
import io.dingodb.sdk.service.entity.meta.DeleteAutoIncrementRequest;
import io.dingodb.sdk.service.entity.meta.DeleteAutoIncrementResponse;
import io.dingodb.sdk.service.entity.meta.DropIndexOnTableRequest;
import io.dingodb.sdk.service.entity.meta.DropIndexOnTableResponse;
import io.dingodb.sdk.service.entity.meta.DropIndexRequest;
import io.dingodb.sdk.service.entity.meta.DropIndexResponse;
import io.dingodb.sdk.service.entity.meta.DropSchemaRequest;
import io.dingodb.sdk.service.entity.meta.DropSchemaResponse;
import io.dingodb.sdk.service.entity.meta.DropTableRequest;
import io.dingodb.sdk.service.entity.meta.DropTableResponse;
import io.dingodb.sdk.service.entity.meta.DropTablesRequest;
import io.dingodb.sdk.service.entity.meta.DropTablesResponse;
import io.dingodb.sdk.service.entity.meta.DropTenantRequest;
import io.dingodb.sdk.service.entity.meta.DropTenantResponse;
import io.dingodb.sdk.service.entity.meta.ExportMetaRequest;
import io.dingodb.sdk.service.entity.meta.ExportMetaResponse;
import io.dingodb.sdk.service.entity.meta.GenerateAutoIncrementRequest;
import io.dingodb.sdk.service.entity.meta.GenerateAutoIncrementResponse;
import io.dingodb.sdk.service.entity.meta.GenerateTableIdsRequest;
import io.dingodb.sdk.service.entity.meta.GenerateTableIdsResponse;
import io.dingodb.sdk.service.entity.meta.GetAutoIncrementRequest;
import io.dingodb.sdk.service.entity.meta.GetAutoIncrementResponse;
import io.dingodb.sdk.service.entity.meta.GetAutoIncrementsRequest;
import io.dingodb.sdk.service.entity.meta.GetAutoIncrementsResponse;
import io.dingodb.sdk.service.entity.meta.GetDeletedIndexRequest;
import io.dingodb.sdk.service.entity.meta.GetDeletedIndexResponse;
import io.dingodb.sdk.service.entity.meta.GetDeletedTableRequest;
import io.dingodb.sdk.service.entity.meta.GetDeletedTableResponse;
import io.dingodb.sdk.service.entity.meta.GetIndexByNameRequest;
import io.dingodb.sdk.service.entity.meta.GetIndexByNameResponse;
import io.dingodb.sdk.service.entity.meta.GetIndexMetricsRequest;
import io.dingodb.sdk.service.entity.meta.GetIndexMetricsResponse;
import io.dingodb.sdk.service.entity.meta.GetIndexRangeRequest;
import io.dingodb.sdk.service.entity.meta.GetIndexRangeResponse;
import io.dingodb.sdk.service.entity.meta.GetIndexRequest;
import io.dingodb.sdk.service.entity.meta.GetIndexResponse;
import io.dingodb.sdk.service.entity.meta.GetIndexesCountRequest;
import io.dingodb.sdk.service.entity.meta.GetIndexesCountResponse;
import io.dingodb.sdk.service.entity.meta.GetIndexesRequest;
import io.dingodb.sdk.service.entity.meta.GetIndexesResponse;
import io.dingodb.sdk.service.entity.meta.GetSchemaByNameRequest;
import io.dingodb.sdk.service.entity.meta.GetSchemaByNameResponse;
import io.dingodb.sdk.service.entity.meta.GetSchemaRequest;
import io.dingodb.sdk.service.entity.meta.GetSchemaResponse;
import io.dingodb.sdk.service.entity.meta.GetSchemasRequest;
import io.dingodb.sdk.service.entity.meta.GetSchemasResponse;
import io.dingodb.sdk.service.entity.meta.GetTableByNameRequest;
import io.dingodb.sdk.service.entity.meta.GetTableByNameResponse;
import io.dingodb.sdk.service.entity.meta.GetTableMetricsRequest;
import io.dingodb.sdk.service.entity.meta.GetTableMetricsResponse;
import io.dingodb.sdk.service.entity.meta.GetTableRangeRequest;
import io.dingodb.sdk.service.entity.meta.GetTableRangeResponse;
import io.dingodb.sdk.service.entity.meta.GetTableRequest;
import io.dingodb.sdk.service.entity.meta.GetTableResponse;
import io.dingodb.sdk.service.entity.meta.GetTablesBySchemaRequest;
import io.dingodb.sdk.service.entity.meta.GetTablesBySchemaResponse;
import io.dingodb.sdk.service.entity.meta.GetTablesCountRequest;
import io.dingodb.sdk.service.entity.meta.GetTablesCountResponse;
import io.dingodb.sdk.service.entity.meta.GetTablesRequest;
import io.dingodb.sdk.service.entity.meta.GetTablesResponse;
import io.dingodb.sdk.service.entity.meta.GetTenantsRequest;
import io.dingodb.sdk.service.entity.meta.GetTenantsResponse;
import io.dingodb.sdk.service.entity.meta.HelloRequest;
import io.dingodb.sdk.service.entity.meta.HelloResponse;
import io.dingodb.sdk.service.entity.meta.ImportIdEpochTypeRequest;
import io.dingodb.sdk.service.entity.meta.ImportIdEpochTypeResponse;
import io.dingodb.sdk.service.entity.meta.ImportMetaRequest;
import io.dingodb.sdk.service.entity.meta.ImportMetaResponse;
import io.dingodb.sdk.service.entity.meta.ListWatchRequest;
import io.dingodb.sdk.service.entity.meta.ListWatchResponse;
import io.dingodb.sdk.service.entity.meta.SaveIdEpochTypeRequest;
import io.dingodb.sdk.service.entity.meta.SaveIdEpochTypeResponse;
import io.dingodb.sdk.service.entity.meta.SwitchAutoSplitRequest;
import io.dingodb.sdk.service.entity.meta.SwitchAutoSplitResponse;
import io.dingodb.sdk.service.entity.meta.TsoRequest;
import io.dingodb.sdk.service.entity.meta.TsoResponse;
import io.dingodb.sdk.service.entity.meta.UpdateAutoIncrementRequest;
import io.dingodb.sdk.service.entity.meta.UpdateAutoIncrementResponse;
import io.dingodb.sdk.service.entity.meta.UpdateIndexRequest;
import io.dingodb.sdk.service.entity.meta.UpdateIndexResponse;
import io.dingodb.sdk.service.entity.meta.UpdateTablesRequest;
import io.dingodb.sdk.service.entity.meta.UpdateTablesResponse;
import io.dingodb.sdk.service.entity.meta.UpdateTenantRequest;
import io.dingodb.sdk.service.entity.meta.UpdateTenantResponse;
import io.dingodb.sdk.service.entity.meta.WatchRequest;
import io.dingodb.sdk.service.entity.meta.WatchResponse;
import lombok.AllArgsConstructor;
import lombok.Getter;

public interface MetaService extends Service<MetaService> {
    @Deprecated
    default HelloResponse hello(HelloRequest request) {
        return hello(System.identityHashCode(request), request);
    }

    default HelloResponse hello(long requestId, HelloRequest request) {
        return getCaller().call(hello, requestId, request, helloHandlers);
    }

    @Deprecated
    default HelloResponse getMemoryInfo(HelloRequest request) {
        return getMemoryInfo(System.identityHashCode(request), request);
    }

    default HelloResponse getMemoryInfo(long requestId, HelloRequest request) {
        return getCaller().call(getMemoryInfo, requestId, request, getMemoryInfoHandlers);
    }

    @Deprecated
    default TsoResponse getTsoInfo(TsoRequest request) {
        return getTsoInfo(System.identityHashCode(request), request);
    }

    default TsoResponse getTsoInfo(long requestId, TsoRequest request) {
        return getCaller().call(getTsoInfo, requestId, request, getTsoInfoHandlers);
    }

    @Deprecated
    default GetSchemasResponse getSchemas(GetSchemasRequest request) {
        return getSchemas(System.identityHashCode(request), request);
    }

    default GetSchemasResponse getSchemas(long requestId, GetSchemasRequest request) {
        return getCaller().call(getSchemas, requestId, request, getSchemasHandlers);
    }

    @Deprecated
    default GetSchemaResponse getSchema(GetSchemaRequest request) {
        return getSchema(System.identityHashCode(request), request);
    }

    default GetSchemaResponse getSchema(long requestId, GetSchemaRequest request) {
        return getCaller().call(getSchema, requestId, request, getSchemaHandlers);
    }

    @Deprecated
    default GetSchemaByNameResponse getSchemaByName(GetSchemaByNameRequest request) {
        return getSchemaByName(System.identityHashCode(request), request);
    }

    default GetSchemaByNameResponse getSchemaByName(long requestId,
            GetSchemaByNameRequest request) {
        return getCaller().call(getSchemaByName, requestId, request, getSchemaByNameHandlers);
    }

    @Deprecated
    default GetTablesBySchemaResponse getTablesBySchema(GetTablesBySchemaRequest request) {
        return getTablesBySchema(System.identityHashCode(request), request);
    }

    default GetTablesBySchemaResponse getTablesBySchema(long requestId,
            GetTablesBySchemaRequest request) {
        return getCaller().call(getTablesBySchema, requestId, request, getTablesBySchemaHandlers);
    }

    @Deprecated
    default GetTablesCountResponse getTablesCount(GetTablesCountRequest request) {
        return getTablesCount(System.identityHashCode(request), request);
    }

    default GetTablesCountResponse getTablesCount(long requestId, GetTablesCountRequest request) {
        return getCaller().call(getTablesCount, requestId, request, getTablesCountHandlers);
    }

    @Deprecated
    default GetTableResponse getTable(GetTableRequest request) {
        return getTable(System.identityHashCode(request), request);
    }

    default GetTableResponse getTable(long requestId, GetTableRequest request) {
        return getCaller().call(getTable, requestId, request, getTableHandlers);
    }

    @Deprecated
    default GetTableByNameResponse getTableByName(GetTableByNameRequest request) {
        return getTableByName(System.identityHashCode(request), request);
    }

    default GetTableByNameResponse getTableByName(long requestId, GetTableByNameRequest request) {
        return getCaller().call(getTableByName, requestId, request, getTableByNameHandlers);
    }

    @Deprecated
    default GetTableRangeResponse getTableRange(GetTableRangeRequest request) {
        return getTableRange(System.identityHashCode(request), request);
    }

    default GetTableRangeResponse getTableRange(long requestId, GetTableRangeRequest request) {
        return getCaller().call(getTableRange, requestId, request, getTableRangeHandlers);
    }

    @Deprecated
    default GetTableMetricsResponse getTableMetrics(GetTableMetricsRequest request) {
        return getTableMetrics(System.identityHashCode(request), request);
    }

    default GetTableMetricsResponse getTableMetrics(long requestId,
            GetTableMetricsRequest request) {
        return getCaller().call(getTableMetrics, requestId, request, getTableMetricsHandlers);
    }

    @Deprecated
    default CreateTableIdResponse createTableId(CreateTableIdRequest request) {
        return createTableId(System.identityHashCode(request), request);
    }

    default CreateTableIdResponse createTableId(long requestId, CreateTableIdRequest request) {
        return getCaller().call(createTableId, requestId, request, createTableIdHandlers);
    }

    @Deprecated
    default CreateTableIdsResponse createTableIds(CreateTableIdsRequest request) {
        return createTableIds(System.identityHashCode(request), request);
    }

    default CreateTableIdsResponse createTableIds(long requestId, CreateTableIdsRequest request) {
        return getCaller().call(createTableIds, requestId, request, createTableIdsHandlers);
    }

    @Deprecated
    default CreateTableResponse createTable(CreateTableRequest request) {
        return createTable(System.identityHashCode(request), request);
    }

    default CreateTableResponse createTable(long requestId, CreateTableRequest request) {
        return getCaller().call(createTable, requestId, request, createTableHandlers);
    }

    @Deprecated
    default DropTableResponse dropTable(DropTableRequest request) {
        return dropTable(System.identityHashCode(request), request);
    }

    default DropTableResponse dropTable(long requestId, DropTableRequest request) {
        return getCaller().call(dropTable, requestId, request, dropTableHandlers);
    }

    @Deprecated
    default GenerateTableIdsResponse generateTableIds(GenerateTableIdsRequest request) {
        return generateTableIds(System.identityHashCode(request), request);
    }

    default GenerateTableIdsResponse generateTableIds(long requestId,
            GenerateTableIdsRequest request) {
        return getCaller().call(generateTableIds, requestId, request, generateTableIdsHandlers);
    }

    @Deprecated
    default CreateTablesResponse createTables(CreateTablesRequest request) {
        return createTables(System.identityHashCode(request), request);
    }

    default CreateTablesResponse createTables(long requestId, CreateTablesRequest request) {
        return getCaller().call(createTables, requestId, request, createTablesHandlers);
    }

    @Deprecated
    default UpdateTablesResponse updateTables(UpdateTablesRequest request) {
        return updateTables(System.identityHashCode(request), request);
    }

    default UpdateTablesResponse updateTables(long requestId, UpdateTablesRequest request) {
        return getCaller().call(updateTables, requestId, request, updateTablesHandlers);
    }

    @Deprecated
    default AddIndexOnTableResponse addIndexOnTable(AddIndexOnTableRequest request) {
        return addIndexOnTable(System.identityHashCode(request), request);
    }

    default AddIndexOnTableResponse addIndexOnTable(long requestId,
            AddIndexOnTableRequest request) {
        return getCaller().call(addIndexOnTable, requestId, request, addIndexOnTableHandlers);
    }

    @Deprecated
    default DropIndexOnTableResponse dropIndexOnTable(DropIndexOnTableRequest request) {
        return dropIndexOnTable(System.identityHashCode(request), request);
    }

    default DropIndexOnTableResponse dropIndexOnTable(long requestId,
            DropIndexOnTableRequest request) {
        return getCaller().call(dropIndexOnTable, requestId, request, dropIndexOnTableHandlers);
    }

    @Deprecated
    default GetTablesResponse getTables(GetTablesRequest request) {
        return getTables(System.identityHashCode(request), request);
    }

    default GetTablesResponse getTables(long requestId, GetTablesRequest request) {
        return getCaller().call(getTables, requestId, request, getTablesHandlers);
    }

    @Deprecated
    default DropTablesResponse dropTables(DropTablesRequest request) {
        return dropTables(System.identityHashCode(request), request);
    }

    default DropTablesResponse dropTables(long requestId, DropTablesRequest request) {
        return getCaller().call(dropTables, requestId, request, dropTablesHandlers);
    }

    @Deprecated
    default GetIndexesResponse getIndexes(GetIndexesRequest request) {
        return getIndexes(System.identityHashCode(request), request);
    }

    default GetIndexesResponse getIndexes(long requestId, GetIndexesRequest request) {
        return getCaller().call(getIndexes, requestId, request, getIndexesHandlers);
    }

    @Deprecated
    default GetIndexesCountResponse getIndexesCount(GetIndexesCountRequest request) {
        return getIndexesCount(System.identityHashCode(request), request);
    }

    default GetIndexesCountResponse getIndexesCount(long requestId,
            GetIndexesCountRequest request) {
        return getCaller().call(getIndexesCount, requestId, request, getIndexesCountHandlers);
    }

    @Deprecated
    default GetIndexResponse getIndex(GetIndexRequest request) {
        return getIndex(System.identityHashCode(request), request);
    }

    default GetIndexResponse getIndex(long requestId, GetIndexRequest request) {
        return getCaller().call(getIndex, requestId, request, getIndexHandlers);
    }

    @Deprecated
    default GetIndexByNameResponse getIndexByName(GetIndexByNameRequest request) {
        return getIndexByName(System.identityHashCode(request), request);
    }

    default GetIndexByNameResponse getIndexByName(long requestId, GetIndexByNameRequest request) {
        return getCaller().call(getIndexByName, requestId, request, getIndexByNameHandlers);
    }

    @Deprecated
    default GetIndexRangeResponse getIndexRange(GetIndexRangeRequest request) {
        return getIndexRange(System.identityHashCode(request), request);
    }

    default GetIndexRangeResponse getIndexRange(long requestId, GetIndexRangeRequest request) {
        return getCaller().call(getIndexRange, requestId, request, getIndexRangeHandlers);
    }

    @Deprecated
    default GetIndexMetricsResponse getIndexMetrics(GetIndexMetricsRequest request) {
        return getIndexMetrics(System.identityHashCode(request), request);
    }

    default GetIndexMetricsResponse getIndexMetrics(long requestId,
            GetIndexMetricsRequest request) {
        return getCaller().call(getIndexMetrics, requestId, request, getIndexMetricsHandlers);
    }

    @Deprecated
    default CreateIndexIdResponse createIndexId(CreateIndexIdRequest request) {
        return createIndexId(System.identityHashCode(request), request);
    }

    default CreateIndexIdResponse createIndexId(long requestId, CreateIndexIdRequest request) {
        return getCaller().call(createIndexId, requestId, request, createIndexIdHandlers);
    }

    @Deprecated
    default CreateIndexResponse createIndex(CreateIndexRequest request) {
        return createIndex(System.identityHashCode(request), request);
    }

    default CreateIndexResponse createIndex(long requestId, CreateIndexRequest request) {
        return getCaller().call(createIndex, requestId, request, createIndexHandlers);
    }

    @Deprecated
    default UpdateIndexResponse updateIndex(UpdateIndexRequest request) {
        return updateIndex(System.identityHashCode(request), request);
    }

    default UpdateIndexResponse updateIndex(long requestId, UpdateIndexRequest request) {
        return getCaller().call(updateIndex, requestId, request, updateIndexHandlers);
    }

    @Deprecated
    default DropIndexResponse dropIndex(DropIndexRequest request) {
        return dropIndex(System.identityHashCode(request), request);
    }

    default DropIndexResponse dropIndex(long requestId, DropIndexRequest request) {
        return getCaller().call(dropIndex, requestId, request, dropIndexHandlers);
    }

    @Deprecated
    default CreateSchemaResponse createSchema(CreateSchemaRequest request) {
        return createSchema(System.identityHashCode(request), request);
    }

    default CreateSchemaResponse createSchema(long requestId, CreateSchemaRequest request) {
        return getCaller().call(createSchema, requestId, request, createSchemaHandlers);
    }

    @Deprecated
    default DropSchemaResponse dropSchema(DropSchemaRequest request) {
        return dropSchema(System.identityHashCode(request), request);
    }

    default DropSchemaResponse dropSchema(long requestId, DropSchemaRequest request) {
        return getCaller().call(dropSchema, requestId, request, dropSchemaHandlers);
    }

    @Deprecated
    default GetAutoIncrementsResponse getAutoIncrements(GetAutoIncrementsRequest request) {
        return getAutoIncrements(System.identityHashCode(request), request);
    }

    default GetAutoIncrementsResponse getAutoIncrements(long requestId,
            GetAutoIncrementsRequest request) {
        return getCaller().call(getAutoIncrements, requestId, request, getAutoIncrementsHandlers);
    }

    @Deprecated
    default GetAutoIncrementResponse getAutoIncrement(GetAutoIncrementRequest request) {
        return getAutoIncrement(System.identityHashCode(request), request);
    }

    default GetAutoIncrementResponse getAutoIncrement(long requestId,
            GetAutoIncrementRequest request) {
        return getCaller().call(getAutoIncrement, requestId, request, getAutoIncrementHandlers);
    }

    @Deprecated
    default CreateAutoIncrementResponse createAutoIncrement(CreateAutoIncrementRequest request) {
        return createAutoIncrement(System.identityHashCode(request), request);
    }

    default CreateAutoIncrementResponse createAutoIncrement(long requestId,
            CreateAutoIncrementRequest request) {
        return getCaller().call(createAutoIncrement, requestId, request, createAutoIncrementHandlers);
    }

    @Deprecated
    default CreateAutoIncrementsResponse createAutoIncrements(CreateAutoIncrementsRequest request) {
        return createAutoIncrements(System.identityHashCode(request), request);
    }

    default CreateAutoIncrementsResponse createAutoIncrements(long requestId,
            CreateAutoIncrementsRequest request) {
        return getCaller().call(createAutoIncrements, requestId, request, createAutoIncrementsHandlers);
    }

    @Deprecated
    default UpdateAutoIncrementResponse updateAutoIncrement(UpdateAutoIncrementRequest request) {
        return updateAutoIncrement(System.identityHashCode(request), request);
    }

    default UpdateAutoIncrementResponse updateAutoIncrement(long requestId,
            UpdateAutoIncrementRequest request) {
        return getCaller().call(updateAutoIncrement, requestId, request, updateAutoIncrementHandlers);
    }

    @Deprecated
    default GenerateAutoIncrementResponse generateAutoIncrement(
            GenerateAutoIncrementRequest request) {
        return generateAutoIncrement(System.identityHashCode(request), request);
    }

    default GenerateAutoIncrementResponse generateAutoIncrement(long requestId,
            GenerateAutoIncrementRequest request) {
        return getCaller().call(generateAutoIncrement, requestId, request, generateAutoIncrementHandlers);
    }

    @Deprecated
    default DeleteAutoIncrementResponse deleteAutoIncrement(DeleteAutoIncrementRequest request) {
        return deleteAutoIncrement(System.identityHashCode(request), request);
    }

    default DeleteAutoIncrementResponse deleteAutoIncrement(long requestId,
            DeleteAutoIncrementRequest request) {
        return getCaller().call(deleteAutoIncrement, requestId, request, deleteAutoIncrementHandlers);
    }

    @Deprecated
    default SwitchAutoSplitResponse switchAutoSplit(SwitchAutoSplitRequest request) {
        return switchAutoSplit(System.identityHashCode(request), request);
    }

    default SwitchAutoSplitResponse switchAutoSplit(long requestId,
            SwitchAutoSplitRequest request) {
        return getCaller().call(switchAutoSplit, requestId, request, switchAutoSplitHandlers);
    }

    @Deprecated
    default TsoResponse tsoService(TsoRequest request) {
        return tsoService(System.identityHashCode(request), request);
    }

    default TsoResponse tsoService(long requestId, TsoRequest request) {
        return getCaller().call(tsoService, requestId, request, tsoServiceHandlers);
    }

    @Deprecated
    default GetDeletedTableResponse getDeletedTable(GetDeletedTableRequest request) {
        return getDeletedTable(System.identityHashCode(request), request);
    }

    default GetDeletedTableResponse getDeletedTable(long requestId,
            GetDeletedTableRequest request) {
        return getCaller().call(getDeletedTable, requestId, request, getDeletedTableHandlers);
    }

    @Deprecated
    default CleanDeletedTableResponse cleanDeletedTable(CleanDeletedTableRequest request) {
        return cleanDeletedTable(System.identityHashCode(request), request);
    }

    default CleanDeletedTableResponse cleanDeletedTable(long requestId,
            CleanDeletedTableRequest request) {
        return getCaller().call(cleanDeletedTable, requestId, request, cleanDeletedTableHandlers);
    }

    @Deprecated
    default GetDeletedIndexResponse getDeletedIndex(GetDeletedIndexRequest request) {
        return getDeletedIndex(System.identityHashCode(request), request);
    }

    default GetDeletedIndexResponse getDeletedIndex(long requestId,
            GetDeletedIndexRequest request) {
        return getCaller().call(getDeletedIndex, requestId, request, getDeletedIndexHandlers);
    }

    @Deprecated
    default CleanDeletedIndexResponse cleanDeletedIndex(CleanDeletedIndexRequest request) {
        return cleanDeletedIndex(System.identityHashCode(request), request);
    }

    default CleanDeletedIndexResponse cleanDeletedIndex(long requestId,
            CleanDeletedIndexRequest request) {
        return getCaller().call(cleanDeletedIndex, requestId, request, cleanDeletedIndexHandlers);
    }

    @Deprecated
    default WatchResponse watch(WatchRequest request) {
        return watch(System.identityHashCode(request), request);
    }

    default WatchResponse watch(long requestId, WatchRequest request) {
        return getCaller().call(watch, requestId, request, watchHandlers);
    }

    @Deprecated
    default ListWatchResponse listWatch(ListWatchRequest request) {
        return listWatch(System.identityHashCode(request), request);
    }

    default ListWatchResponse listWatch(long requestId, ListWatchRequest request) {
        return getCaller().call(listWatch, requestId, request, listWatchHandlers);
    }

    @Deprecated
    default CreateTenantResponse createTenant(CreateTenantRequest request) {
        return createTenant(System.identityHashCode(request), request);
    }

    default CreateTenantResponse createTenant(long requestId, CreateTenantRequest request) {
        return getCaller().call(createTenant, requestId, request, createTenantHandlers);
    }

    @Deprecated
    default DropTenantResponse dropTenant(DropTenantRequest request) {
        return dropTenant(System.identityHashCode(request), request);
    }

    default DropTenantResponse dropTenant(long requestId, DropTenantRequest request) {
        return getCaller().call(dropTenant, requestId, request, dropTenantHandlers);
    }

    @Deprecated
    default UpdateTenantResponse updateTenant(UpdateTenantRequest request) {
        return updateTenant(System.identityHashCode(request), request);
    }

    default UpdateTenantResponse updateTenant(long requestId, UpdateTenantRequest request) {
        return getCaller().call(updateTenant, requestId, request, updateTenantHandlers);
    }

    @Deprecated
    default GetTenantsResponse getTenants(GetTenantsRequest request) {
        return getTenants(System.identityHashCode(request), request);
    }

    default GetTenantsResponse getTenants(long requestId, GetTenantsRequest request) {
        return getCaller().call(getTenants, requestId, request, getTenantsHandlers);
    }

    @Deprecated
    default ExportMetaResponse exportMeta(ExportMetaRequest request) {
        return exportMeta(System.identityHashCode(request), request);
    }

    default ExportMetaResponse exportMeta(long requestId, ExportMetaRequest request) {
        return getCaller().call(exportMeta, requestId, request, exportMetaHandlers);
    }

    @Deprecated
    default SaveIdEpochTypeResponse saveIdEpochType(SaveIdEpochTypeRequest request) {
        return saveIdEpochType(System.identityHashCode(request), request);
    }

    default SaveIdEpochTypeResponse saveIdEpochType(long requestId,
            SaveIdEpochTypeRequest request) {
        return getCaller().call(saveIdEpochType, requestId, request, saveIdEpochTypeHandlers);
    }

    @Deprecated
    default ImportMetaResponse importMeta(ImportMetaRequest request) {
        return importMeta(System.identityHashCode(request), request);
    }

    default ImportMetaResponse importMeta(long requestId, ImportMetaRequest request) {
        return getCaller().call(importMeta, requestId, request, importMetaHandlers);
    }

    @Deprecated
    default ImportIdEpochTypeResponse importIdEpochType(ImportIdEpochTypeRequest request) {
        return importIdEpochType(System.identityHashCode(request), request);
    }

    default ImportIdEpochTypeResponse importIdEpochType(long requestId,
            ImportIdEpochTypeRequest request) {
        return getCaller().call(importIdEpochType, requestId, request, importIdEpochTypeHandlers);
    }

    @Deprecated
    default CreateOrUpdateAutoIncrementsResponse createOrUpdateAutoIncrements(
            CreateOrUpdateAutoIncrementsRequest request) {
        return createOrUpdateAutoIncrements(System.identityHashCode(request), request);
    }

    default CreateOrUpdateAutoIncrementsResponse createOrUpdateAutoIncrements(long requestId,
            CreateOrUpdateAutoIncrementsRequest request) {
        return getCaller().call(createOrUpdateAutoIncrements, requestId, request, createOrUpdateAutoIncrementsHandlers);
    }

    @Deprecated
    default CreateTenantsResponse createTenants(CreateTenantsRequest request) {
        return createTenants(System.identityHashCode(request), request);
    }

    default CreateTenantsResponse createTenants(long requestId, CreateTenantsRequest request) {
        return getCaller().call(createTenants, requestId, request, createTenantsHandlers);
    }

    @Deprecated
    default CreateSchemasResponse createSchemas(CreateSchemasRequest request) {
        return createSchemas(System.identityHashCode(request), request);
    }

    default CreateSchemasResponse createSchemas(long requestId, CreateSchemasRequest request) {
        return getCaller().call(createSchemas, requestId, request, createSchemasHandlers);
    }

    @Deprecated
    default CreateIndexMetasResponse createIndexMetas(CreateIndexMetasRequest request) {
        return createIndexMetas(System.identityHashCode(request), request);
    }

    default CreateIndexMetasResponse createIndexMetas(long requestId,
            CreateIndexMetasRequest request) {
        return getCaller().call(createIndexMetas, requestId, request, createIndexMetasHandlers);
    }

    Caller<MetaService> getCaller();

    @Getter
    @AllArgsConstructor
    class Impl implements MetaService {
        public final Caller<MetaService> caller;
    }
}
