package io.dingodb.sdk.service;

import static io.dingodb.sdk.service.desc.index.IndexServiceDescriptors.*;

import io.dingodb.sdk.service.entity.index.HelloRequest;
import io.dingodb.sdk.service.entity.index.HelloResponse;
import io.dingodb.sdk.service.entity.index.VectorAddRequest;
import io.dingodb.sdk.service.entity.index.VectorAddResponse;
import io.dingodb.sdk.service.entity.index.VectorBatchQueryRequest;
import io.dingodb.sdk.service.entity.index.VectorBatchQueryResponse;
import io.dingodb.sdk.service.entity.index.VectorBuildRequest;
import io.dingodb.sdk.service.entity.index.VectorBuildResponse;
import io.dingodb.sdk.service.entity.index.VectorCountMemoryRequest;
import io.dingodb.sdk.service.entity.index.VectorCountMemoryResponse;
import io.dingodb.sdk.service.entity.index.VectorCountRequest;
import io.dingodb.sdk.service.entity.index.VectorCountResponse;
import io.dingodb.sdk.service.entity.index.VectorDeleteRequest;
import io.dingodb.sdk.service.entity.index.VectorDeleteResponse;
import io.dingodb.sdk.service.entity.index.VectorDumpRequest;
import io.dingodb.sdk.service.entity.index.VectorDumpResponse;
import io.dingodb.sdk.service.entity.index.VectorGetBorderIdRequest;
import io.dingodb.sdk.service.entity.index.VectorGetBorderIdResponse;
import io.dingodb.sdk.service.entity.index.VectorGetRegionMetricsRequest;
import io.dingodb.sdk.service.entity.index.VectorGetRegionMetricsResponse;
import io.dingodb.sdk.service.entity.index.VectorImportRequest;
import io.dingodb.sdk.service.entity.index.VectorImportResponse;
import io.dingodb.sdk.service.entity.index.VectorLoadRequest;
import io.dingodb.sdk.service.entity.index.VectorLoadResponse;
import io.dingodb.sdk.service.entity.index.VectorResetRequest;
import io.dingodb.sdk.service.entity.index.VectorResetResponse;
import io.dingodb.sdk.service.entity.index.VectorScanQueryRequest;
import io.dingodb.sdk.service.entity.index.VectorScanQueryResponse;
import io.dingodb.sdk.service.entity.index.VectorSearchDebugRequest;
import io.dingodb.sdk.service.entity.index.VectorSearchDebugResponse;
import io.dingodb.sdk.service.entity.index.VectorSearchRequest;
import io.dingodb.sdk.service.entity.index.VectorSearchResponse;
import io.dingodb.sdk.service.entity.index.VectorStatusRequest;
import io.dingodb.sdk.service.entity.index.VectorStatusResponse;
import io.dingodb.sdk.service.entity.store.BackupDataRequest;
import io.dingodb.sdk.service.entity.store.BackupDataResponse;
import io.dingodb.sdk.service.entity.store.ControlConfigRequest;
import io.dingodb.sdk.service.entity.store.ControlConfigResponse;
import io.dingodb.sdk.service.entity.store.RestoreDataRequest;
import io.dingodb.sdk.service.entity.store.RestoreDataResponse;
import io.dingodb.sdk.service.entity.store.TxnBatchGetRequest;
import io.dingodb.sdk.service.entity.store.TxnBatchGetResponse;
import io.dingodb.sdk.service.entity.store.TxnBatchRollbackRequest;
import io.dingodb.sdk.service.entity.store.TxnBatchRollbackResponse;
import io.dingodb.sdk.service.entity.store.TxnCheckTxnStatusRequest;
import io.dingodb.sdk.service.entity.store.TxnCheckTxnStatusResponse;
import io.dingodb.sdk.service.entity.store.TxnCommitRequest;
import io.dingodb.sdk.service.entity.store.TxnCommitResponse;
import io.dingodb.sdk.service.entity.store.TxnDeleteRangeRequest;
import io.dingodb.sdk.service.entity.store.TxnDeleteRangeResponse;
import io.dingodb.sdk.service.entity.store.TxnDumpRequest;
import io.dingodb.sdk.service.entity.store.TxnDumpResponse;
import io.dingodb.sdk.service.entity.store.TxnGcRequest;
import io.dingodb.sdk.service.entity.store.TxnGcResponse;
import io.dingodb.sdk.service.entity.store.TxnGetRequest;
import io.dingodb.sdk.service.entity.store.TxnGetResponse;
import io.dingodb.sdk.service.entity.store.TxnHeartBeatRequest;
import io.dingodb.sdk.service.entity.store.TxnHeartBeatResponse;
import io.dingodb.sdk.service.entity.store.TxnPessimisticLockRequest;
import io.dingodb.sdk.service.entity.store.TxnPessimisticLockResponse;
import io.dingodb.sdk.service.entity.store.TxnPessimisticRollbackRequest;
import io.dingodb.sdk.service.entity.store.TxnPessimisticRollbackResponse;
import io.dingodb.sdk.service.entity.store.TxnPrewriteRequest;
import io.dingodb.sdk.service.entity.store.TxnPrewriteResponse;
import io.dingodb.sdk.service.entity.store.TxnResolveLockRequest;
import io.dingodb.sdk.service.entity.store.TxnResolveLockResponse;
import io.dingodb.sdk.service.entity.store.TxnScanLockRequest;
import io.dingodb.sdk.service.entity.store.TxnScanLockResponse;
import io.dingodb.sdk.service.entity.store.TxnScanRequest;
import io.dingodb.sdk.service.entity.store.TxnScanResponse;
import lombok.AllArgsConstructor;
import lombok.Getter;

public interface IndexService extends Service<IndexService> {
    @Deprecated
    default HelloResponse hello(HelloRequest request) {
        return hello(System.identityHashCode(request), request);
    }

    default HelloResponse hello(long requestId, HelloRequest request) {
        return getCaller().call(hello, requestId, request, helloHandlers);
    }

    @Deprecated
    default HelloResponse getMemoryInfo(HelloRequest request) {
        return getMemoryInfo(System.identityHashCode(request), request);
    }

    default HelloResponse getMemoryInfo(long requestId, HelloRequest request) {
        return getCaller().call(getMemoryInfo, requestId, request, getMemoryInfoHandlers);
    }

    @Deprecated
    default VectorAddResponse vectorAdd(VectorAddRequest request) {
        return vectorAdd(System.identityHashCode(request), request);
    }

    default VectorAddResponse vectorAdd(long requestId, VectorAddRequest request) {
        return getCaller().call(vectorAdd, requestId, request, vectorAddHandlers);
    }

    @Deprecated
    default VectorBatchQueryResponse vectorBatchQuery(VectorBatchQueryRequest request) {
        return vectorBatchQuery(System.identityHashCode(request), request);
    }

    default VectorBatchQueryResponse vectorBatchQuery(long requestId,
            VectorBatchQueryRequest request) {
        return getCaller().call(vectorBatchQuery, requestId, request, vectorBatchQueryHandlers);
    }

    @Deprecated
    default VectorSearchResponse vectorSearch(VectorSearchRequest request) {
        return vectorSearch(System.identityHashCode(request), request);
    }

    default VectorSearchResponse vectorSearch(long requestId, VectorSearchRequest request) {
        return getCaller().call(vectorSearch, requestId, request, vectorSearchHandlers);
    }

    @Deprecated
    default VectorDeleteResponse vectorDelete(VectorDeleteRequest request) {
        return vectorDelete(System.identityHashCode(request), request);
    }

    default VectorDeleteResponse vectorDelete(long requestId, VectorDeleteRequest request) {
        return getCaller().call(vectorDelete, requestId, request, vectorDeleteHandlers);
    }

    @Deprecated
    default VectorGetBorderIdResponse vectorGetBorderId(VectorGetBorderIdRequest request) {
        return vectorGetBorderId(System.identityHashCode(request), request);
    }

    default VectorGetBorderIdResponse vectorGetBorderId(long requestId,
            VectorGetBorderIdRequest request) {
        return getCaller().call(vectorGetBorderId, requestId, request, vectorGetBorderIdHandlers);
    }

    @Deprecated
    default VectorScanQueryResponse vectorScanQuery(VectorScanQueryRequest request) {
        return vectorScanQuery(System.identityHashCode(request), request);
    }

    default VectorScanQueryResponse vectorScanQuery(long requestId,
            VectorScanQueryRequest request) {
        return getCaller().call(vectorScanQuery, requestId, request, vectorScanQueryHandlers);
    }

    @Deprecated
    default VectorGetRegionMetricsResponse vectorGetRegionMetrics(
            VectorGetRegionMetricsRequest request) {
        return vectorGetRegionMetrics(System.identityHashCode(request), request);
    }

    default VectorGetRegionMetricsResponse vectorGetRegionMetrics(long requestId,
            VectorGetRegionMetricsRequest request) {
        return getCaller().call(vectorGetRegionMetrics, requestId, request, vectorGetRegionMetricsHandlers);
    }

    @Deprecated
    default VectorCountResponse vectorCount(VectorCountRequest request) {
        return vectorCount(System.identityHashCode(request), request);
    }

    default VectorCountResponse vectorCount(long requestId, VectorCountRequest request) {
        return getCaller().call(vectorCount, requestId, request, vectorCountHandlers);
    }

    @Deprecated
    default VectorCountMemoryResponse vectorCountMemory(VectorCountMemoryRequest request) {
        return vectorCountMemory(System.identityHashCode(request), request);
    }

    default VectorCountMemoryResponse vectorCountMemory(long requestId,
            VectorCountMemoryRequest request) {
        return getCaller().call(vectorCountMemory, requestId, request, vectorCountMemoryHandlers);
    }

    @Deprecated
    default VectorImportResponse vectorImport(VectorImportRequest request) {
        return vectorImport(System.identityHashCode(request), request);
    }

    default VectorImportResponse vectorImport(long requestId, VectorImportRequest request) {
        return getCaller().call(vectorImport, requestId, request, vectorImportHandlers);
    }

    @Deprecated
    default VectorBuildResponse vectorBuild(VectorBuildRequest request) {
        return vectorBuild(System.identityHashCode(request), request);
    }

    default VectorBuildResponse vectorBuild(long requestId, VectorBuildRequest request) {
        return getCaller().call(vectorBuild, requestId, request, vectorBuildHandlers);
    }

    @Deprecated
    default VectorLoadResponse vectorLoad(VectorLoadRequest request) {
        return vectorLoad(System.identityHashCode(request), request);
    }

    default VectorLoadResponse vectorLoad(long requestId, VectorLoadRequest request) {
        return getCaller().call(vectorLoad, requestId, request, vectorLoadHandlers);
    }

    @Deprecated
    default VectorStatusResponse vectorStatus(VectorStatusRequest request) {
        return vectorStatus(System.identityHashCode(request), request);
    }

    default VectorStatusResponse vectorStatus(long requestId, VectorStatusRequest request) {
        return getCaller().call(vectorStatus, requestId, request, vectorStatusHandlers);
    }

    @Deprecated
    default VectorResetResponse vectorReset(VectorResetRequest request) {
        return vectorReset(System.identityHashCode(request), request);
    }

    default VectorResetResponse vectorReset(long requestId, VectorResetRequest request) {
        return getCaller().call(vectorReset, requestId, request, vectorResetHandlers);
    }

    @Deprecated
    default VectorDumpResponse vectorDump(VectorDumpRequest request) {
        return vectorDump(System.identityHashCode(request), request);
    }

    default VectorDumpResponse vectorDump(long requestId, VectorDumpRequest request) {
        return getCaller().call(vectorDump, requestId, request, vectorDumpHandlers);
    }

    @Deprecated
    default VectorSearchDebugResponse vectorSearchDebug(VectorSearchDebugRequest request) {
        return vectorSearchDebug(System.identityHashCode(request), request);
    }

    default VectorSearchDebugResponse vectorSearchDebug(long requestId,
            VectorSearchDebugRequest request) {
        return getCaller().call(vectorSearchDebug, requestId, request, vectorSearchDebugHandlers);
    }

    @Deprecated
    default TxnGetResponse txnGet(TxnGetRequest request) {
        return txnGet(System.identityHashCode(request), request);
    }

    default TxnGetResponse txnGet(long requestId, TxnGetRequest request) {
        return getCaller().call(txnGet, requestId, request, txnGetHandlers);
    }

    @Deprecated
    default TxnBatchGetResponse txnBatchGet(TxnBatchGetRequest request) {
        return txnBatchGet(System.identityHashCode(request), request);
    }

    default TxnBatchGetResponse txnBatchGet(long requestId, TxnBatchGetRequest request) {
        return getCaller().call(txnBatchGet, requestId, request, txnBatchGetHandlers);
    }

    @Deprecated
    default TxnScanResponse txnScan(TxnScanRequest request) {
        return txnScan(System.identityHashCode(request), request);
    }

    default TxnScanResponse txnScan(long requestId, TxnScanRequest request) {
        return getCaller().call(txnScan, requestId, request, txnScanHandlers);
    }

    @Deprecated
    default TxnScanLockResponse txnScanLock(TxnScanLockRequest request) {
        return txnScanLock(System.identityHashCode(request), request);
    }

    default TxnScanLockResponse txnScanLock(long requestId, TxnScanLockRequest request) {
        return getCaller().call(txnScanLock, requestId, request, txnScanLockHandlers);
    }

    @Deprecated
    default TxnDumpResponse txnDump(TxnDumpRequest request) {
        return txnDump(System.identityHashCode(request), request);
    }

    default TxnDumpResponse txnDump(long requestId, TxnDumpRequest request) {
        return getCaller().call(txnDump, requestId, request, txnDumpHandlers);
    }

    @Deprecated
    default TxnPessimisticLockResponse txnPessimisticLock(TxnPessimisticLockRequest request) {
        return txnPessimisticLock(System.identityHashCode(request), request);
    }

    default TxnPessimisticLockResponse txnPessimisticLock(long requestId,
            TxnPessimisticLockRequest request) {
        return getCaller().call(txnPessimisticLock, requestId, request, txnPessimisticLockHandlers);
    }

    @Deprecated
    default TxnPessimisticRollbackResponse txnPessimisticRollback(
            TxnPessimisticRollbackRequest request) {
        return txnPessimisticRollback(System.identityHashCode(request), request);
    }

    default TxnPessimisticRollbackResponse txnPessimisticRollback(long requestId,
            TxnPessimisticRollbackRequest request) {
        return getCaller().call(txnPessimisticRollback, requestId, request, txnPessimisticRollbackHandlers);
    }

    @Deprecated
    default TxnPrewriteResponse txnPrewrite(TxnPrewriteRequest request) {
        return txnPrewrite(System.identityHashCode(request), request);
    }

    default TxnPrewriteResponse txnPrewrite(long requestId, TxnPrewriteRequest request) {
        return getCaller().call(txnPrewrite, requestId, request, txnPrewriteHandlers);
    }

    @Deprecated
    default TxnCommitResponse txnCommit(TxnCommitRequest request) {
        return txnCommit(System.identityHashCode(request), request);
    }

    default TxnCommitResponse txnCommit(long requestId, TxnCommitRequest request) {
        return getCaller().call(txnCommit, requestId, request, txnCommitHandlers);
    }

    @Deprecated
    default TxnCheckTxnStatusResponse txnCheckTxnStatus(TxnCheckTxnStatusRequest request) {
        return txnCheckTxnStatus(System.identityHashCode(request), request);
    }

    default TxnCheckTxnStatusResponse txnCheckTxnStatus(long requestId,
            TxnCheckTxnStatusRequest request) {
        return getCaller().call(txnCheckTxnStatus, requestId, request, txnCheckTxnStatusHandlers);
    }

    @Deprecated
    default TxnResolveLockResponse txnResolveLock(TxnResolveLockRequest request) {
        return txnResolveLock(System.identityHashCode(request), request);
    }

    default TxnResolveLockResponse txnResolveLock(long requestId, TxnResolveLockRequest request) {
        return getCaller().call(txnResolveLock, requestId, request, txnResolveLockHandlers);
    }

    @Deprecated
    default TxnBatchRollbackResponse txnBatchRollback(TxnBatchRollbackRequest request) {
        return txnBatchRollback(System.identityHashCode(request), request);
    }

    default TxnBatchRollbackResponse txnBatchRollback(long requestId,
            TxnBatchRollbackRequest request) {
        return getCaller().call(txnBatchRollback, requestId, request, txnBatchRollbackHandlers);
    }

    @Deprecated
    default TxnHeartBeatResponse txnHeartBeat(TxnHeartBeatRequest request) {
        return txnHeartBeat(System.identityHashCode(request), request);
    }

    default TxnHeartBeatResponse txnHeartBeat(long requestId, TxnHeartBeatRequest request) {
        return getCaller().call(txnHeartBeat, requestId, request, txnHeartBeatHandlers);
    }

    @Deprecated
    default TxnGcResponse txnGc(TxnGcRequest request) {
        return txnGc(System.identityHashCode(request), request);
    }

    default TxnGcResponse txnGc(long requestId, TxnGcRequest request) {
        return getCaller().call(txnGc, requestId, request, txnGcHandlers);
    }

    @Deprecated
    default TxnDeleteRangeResponse txnDeleteRange(TxnDeleteRangeRequest request) {
        return txnDeleteRange(System.identityHashCode(request), request);
    }

    default TxnDeleteRangeResponse txnDeleteRange(long requestId, TxnDeleteRangeRequest request) {
        return getCaller().call(txnDeleteRange, requestId, request, txnDeleteRangeHandlers);
    }

    @Deprecated
    default BackupDataResponse backupData(BackupDataRequest request) {
        return backupData(System.identityHashCode(request), request);
    }

    default BackupDataResponse backupData(long requestId, BackupDataRequest request) {
        return getCaller().call(backupData, requestId, request, backupDataHandlers);
    }

    @Deprecated
    default ControlConfigResponse controlConfig(ControlConfigRequest request) {
        return controlConfig(System.identityHashCode(request), request);
    }

    default ControlConfigResponse controlConfig(long requestId, ControlConfigRequest request) {
        return getCaller().call(controlConfig, requestId, request, controlConfigHandlers);
    }

    @Deprecated
    default RestoreDataResponse restoreData(RestoreDataRequest request) {
        return restoreData(System.identityHashCode(request), request);
    }

    default RestoreDataResponse restoreData(long requestId, RestoreDataRequest request) {
        return getCaller().call(restoreData, requestId, request, restoreDataHandlers);
    }

    Caller<IndexService> getCaller();

    @Getter
    @AllArgsConstructor
    class Impl implements IndexService {
        public final Caller<IndexService> caller;
    }
}
