package io.dingodb.sdk.service;

import static io.dingodb.sdk.service.desc.fileservice.FileServiceDescriptors.*;

import io.dingodb.sdk.service.entity.fileservice.CleanFileReaderRequest;
import io.dingodb.sdk.service.entity.fileservice.CleanFileReaderResponse;
import io.dingodb.sdk.service.entity.fileservice.GetFileRequest;
import io.dingodb.sdk.service.entity.fileservice.GetFileResponse;
import lombok.AllArgsConstructor;
import lombok.Getter;

public interface FileService extends Service<FileService> {
    @Deprecated
    default GetFileResponse getFile(GetFileRequest request) {
        return getFile(System.identityHashCode(request), request);
    }

    default GetFileResponse getFile(long requestId, GetFileRequest request) {
        return getCaller().call(getFile, requestId, request, getFileHandlers);
    }

    @Deprecated
    default CleanFileReaderResponse cleanFileReader(CleanFileReaderRequest request) {
        return cleanFileReader(System.identityHashCode(request), request);
    }

    default CleanFileReaderResponse cleanFileReader(long requestId,
            CleanFileReaderRequest request) {
        return getCaller().call(cleanFileReader, requestId, request, cleanFileReaderHandlers);
    }

    Caller<FileService> getCaller();

    @Getter
    @AllArgsConstructor
    class Impl implements FileService {
        public final Caller<FileService> caller;
    }
}
