package io.dingodb.sdk.service;

import static io.dingodb.sdk.service.desc.document.DocumentServiceDescriptors.*;

import io.dingodb.sdk.service.entity.document.DocumentAddRequest;
import io.dingodb.sdk.service.entity.document.DocumentAddResponse;
import io.dingodb.sdk.service.entity.document.DocumentBatchQueryRequest;
import io.dingodb.sdk.service.entity.document.DocumentBatchQueryResponse;
import io.dingodb.sdk.service.entity.document.DocumentCountRequest;
import io.dingodb.sdk.service.entity.document.DocumentCountResponse;
import io.dingodb.sdk.service.entity.document.DocumentDeleteRequest;
import io.dingodb.sdk.service.entity.document.DocumentDeleteResponse;
import io.dingodb.sdk.service.entity.document.DocumentGetBorderIdRequest;
import io.dingodb.sdk.service.entity.document.DocumentGetBorderIdResponse;
import io.dingodb.sdk.service.entity.document.DocumentGetRegionMetricsRequest;
import io.dingodb.sdk.service.entity.document.DocumentGetRegionMetricsResponse;
import io.dingodb.sdk.service.entity.document.DocumentScanQueryRequest;
import io.dingodb.sdk.service.entity.document.DocumentScanQueryResponse;
import io.dingodb.sdk.service.entity.document.DocumentSearchAllRequest;
import io.dingodb.sdk.service.entity.document.DocumentSearchAllResponse;
import io.dingodb.sdk.service.entity.document.DocumentSearchRequest;
import io.dingodb.sdk.service.entity.document.DocumentSearchResponse;
import io.dingodb.sdk.service.entity.document.HelloRequest;
import io.dingodb.sdk.service.entity.document.HelloResponse;
import io.dingodb.sdk.service.entity.store.BackupDataRequest;
import io.dingodb.sdk.service.entity.store.BackupDataResponse;
import io.dingodb.sdk.service.entity.store.RestoreDataRequest;
import io.dingodb.sdk.service.entity.store.RestoreDataResponse;
import io.dingodb.sdk.service.entity.store.TxnBatchGetRequest;
import io.dingodb.sdk.service.entity.store.TxnBatchGetResponse;
import io.dingodb.sdk.service.entity.store.TxnBatchRollbackRequest;
import io.dingodb.sdk.service.entity.store.TxnBatchRollbackResponse;
import io.dingodb.sdk.service.entity.store.TxnCheckTxnStatusRequest;
import io.dingodb.sdk.service.entity.store.TxnCheckTxnStatusResponse;
import io.dingodb.sdk.service.entity.store.TxnCommitRequest;
import io.dingodb.sdk.service.entity.store.TxnCommitResponse;
import io.dingodb.sdk.service.entity.store.TxnDeleteRangeRequest;
import io.dingodb.sdk.service.entity.store.TxnDeleteRangeResponse;
import io.dingodb.sdk.service.entity.store.TxnDumpRequest;
import io.dingodb.sdk.service.entity.store.TxnDumpResponse;
import io.dingodb.sdk.service.entity.store.TxnGcRequest;
import io.dingodb.sdk.service.entity.store.TxnGcResponse;
import io.dingodb.sdk.service.entity.store.TxnGetRequest;
import io.dingodb.sdk.service.entity.store.TxnGetResponse;
import io.dingodb.sdk.service.entity.store.TxnHeartBeatRequest;
import io.dingodb.sdk.service.entity.store.TxnHeartBeatResponse;
import io.dingodb.sdk.service.entity.store.TxnPessimisticLockRequest;
import io.dingodb.sdk.service.entity.store.TxnPessimisticLockResponse;
import io.dingodb.sdk.service.entity.store.TxnPessimisticRollbackRequest;
import io.dingodb.sdk.service.entity.store.TxnPessimisticRollbackResponse;
import io.dingodb.sdk.service.entity.store.TxnPrewriteRequest;
import io.dingodb.sdk.service.entity.store.TxnPrewriteResponse;
import io.dingodb.sdk.service.entity.store.TxnResolveLockRequest;
import io.dingodb.sdk.service.entity.store.TxnResolveLockResponse;
import io.dingodb.sdk.service.entity.store.TxnScanLockRequest;
import io.dingodb.sdk.service.entity.store.TxnScanLockResponse;
import io.dingodb.sdk.service.entity.store.TxnScanRequest;
import io.dingodb.sdk.service.entity.store.TxnScanResponse;
import lombok.AllArgsConstructor;
import lombok.Getter;

public interface DocumentService extends Service<DocumentService> {
    @Deprecated
    default HelloResponse hello(HelloRequest request) {
        return hello(System.identityHashCode(request), request);
    }

    default HelloResponse hello(long requestId, HelloRequest request) {
        return getCaller().call(hello, requestId, request, helloHandlers);
    }

    @Deprecated
    default HelloResponse getMemoryInfo(HelloRequest request) {
        return getMemoryInfo(System.identityHashCode(request), request);
    }

    default HelloResponse getMemoryInfo(long requestId, HelloRequest request) {
        return getCaller().call(getMemoryInfo, requestId, request, getMemoryInfoHandlers);
    }

    @Deprecated
    default DocumentAddResponse documentAdd(DocumentAddRequest request) {
        return documentAdd(System.identityHashCode(request), request);
    }

    default DocumentAddResponse documentAdd(long requestId, DocumentAddRequest request) {
        return getCaller().call(documentAdd, requestId, request, documentAddHandlers);
    }

    @Deprecated
    default DocumentBatchQueryResponse documentBatchQuery(DocumentBatchQueryRequest request) {
        return documentBatchQuery(System.identityHashCode(request), request);
    }

    default DocumentBatchQueryResponse documentBatchQuery(long requestId,
            DocumentBatchQueryRequest request) {
        return getCaller().call(documentBatchQuery, requestId, request, documentBatchQueryHandlers);
    }

    @Deprecated
    default DocumentSearchResponse documentSearch(DocumentSearchRequest request) {
        return documentSearch(System.identityHashCode(request), request);
    }

    default DocumentSearchResponse documentSearch(long requestId, DocumentSearchRequest request) {
        return getCaller().call(documentSearch, requestId, request, documentSearchHandlers);
    }

    @Deprecated
    default DocumentSearchAllResponse documentSearchAll(DocumentSearchAllRequest request) {
        return documentSearchAll(System.identityHashCode(request), request);
    }

    default DocumentSearchAllResponse documentSearchAll(long requestId,
            DocumentSearchAllRequest request) {
        return getCaller().call(documentSearchAll, requestId, request, documentSearchAllHandlers);
    }

    @Deprecated
    default DocumentDeleteResponse documentDelete(DocumentDeleteRequest request) {
        return documentDelete(System.identityHashCode(request), request);
    }

    default DocumentDeleteResponse documentDelete(long requestId, DocumentDeleteRequest request) {
        return getCaller().call(documentDelete, requestId, request, documentDeleteHandlers);
    }

    @Deprecated
    default DocumentGetBorderIdResponse documentGetBorderId(DocumentGetBorderIdRequest request) {
        return documentGetBorderId(System.identityHashCode(request), request);
    }

    default DocumentGetBorderIdResponse documentGetBorderId(long requestId,
            DocumentGetBorderIdRequest request) {
        return getCaller().call(documentGetBorderId, requestId, request, documentGetBorderIdHandlers);
    }

    @Deprecated
    default DocumentScanQueryResponse documentScanQuery(DocumentScanQueryRequest request) {
        return documentScanQuery(System.identityHashCode(request), request);
    }

    default DocumentScanQueryResponse documentScanQuery(long requestId,
            DocumentScanQueryRequest request) {
        return getCaller().call(documentScanQuery, requestId, request, documentScanQueryHandlers);
    }

    @Deprecated
    default DocumentGetRegionMetricsResponse documentGetRegionMetrics(
            DocumentGetRegionMetricsRequest request) {
        return documentGetRegionMetrics(System.identityHashCode(request), request);
    }

    default DocumentGetRegionMetricsResponse documentGetRegionMetrics(long requestId,
            DocumentGetRegionMetricsRequest request) {
        return getCaller().call(documentGetRegionMetrics, requestId, request, documentGetRegionMetricsHandlers);
    }

    @Deprecated
    default DocumentCountResponse documentCount(DocumentCountRequest request) {
        return documentCount(System.identityHashCode(request), request);
    }

    default DocumentCountResponse documentCount(long requestId, DocumentCountRequest request) {
        return getCaller().call(documentCount, requestId, request, documentCountHandlers);
    }

    @Deprecated
    default TxnGetResponse txnGet(TxnGetRequest request) {
        return txnGet(System.identityHashCode(request), request);
    }

    default TxnGetResponse txnGet(long requestId, TxnGetRequest request) {
        return getCaller().call(txnGet, requestId, request, txnGetHandlers);
    }

    @Deprecated
    default TxnBatchGetResponse txnBatchGet(TxnBatchGetRequest request) {
        return txnBatchGet(System.identityHashCode(request), request);
    }

    default TxnBatchGetResponse txnBatchGet(long requestId, TxnBatchGetRequest request) {
        return getCaller().call(txnBatchGet, requestId, request, txnBatchGetHandlers);
    }

    @Deprecated
    default TxnScanResponse txnScan(TxnScanRequest request) {
        return txnScan(System.identityHashCode(request), request);
    }

    default TxnScanResponse txnScan(long requestId, TxnScanRequest request) {
        return getCaller().call(txnScan, requestId, request, txnScanHandlers);
    }

    @Deprecated
    default TxnScanLockResponse txnScanLock(TxnScanLockRequest request) {
        return txnScanLock(System.identityHashCode(request), request);
    }

    default TxnScanLockResponse txnScanLock(long requestId, TxnScanLockRequest request) {
        return getCaller().call(txnScanLock, requestId, request, txnScanLockHandlers);
    }

    @Deprecated
    default TxnDumpResponse txnDump(TxnDumpRequest request) {
        return txnDump(System.identityHashCode(request), request);
    }

    default TxnDumpResponse txnDump(long requestId, TxnDumpRequest request) {
        return getCaller().call(txnDump, requestId, request, txnDumpHandlers);
    }

    @Deprecated
    default TxnPessimisticLockResponse txnPessimisticLock(TxnPessimisticLockRequest request) {
        return txnPessimisticLock(System.identityHashCode(request), request);
    }

    default TxnPessimisticLockResponse txnPessimisticLock(long requestId,
            TxnPessimisticLockRequest request) {
        return getCaller().call(txnPessimisticLock, requestId, request, txnPessimisticLockHandlers);
    }

    @Deprecated
    default TxnPessimisticRollbackResponse txnPessimisticRollback(
            TxnPessimisticRollbackRequest request) {
        return txnPessimisticRollback(System.identityHashCode(request), request);
    }

    default TxnPessimisticRollbackResponse txnPessimisticRollback(long requestId,
            TxnPessimisticRollbackRequest request) {
        return getCaller().call(txnPessimisticRollback, requestId, request, txnPessimisticRollbackHandlers);
    }

    @Deprecated
    default TxnPrewriteResponse txnPrewrite(TxnPrewriteRequest request) {
        return txnPrewrite(System.identityHashCode(request), request);
    }

    default TxnPrewriteResponse txnPrewrite(long requestId, TxnPrewriteRequest request) {
        return getCaller().call(txnPrewrite, requestId, request, txnPrewriteHandlers);
    }

    @Deprecated
    default TxnCommitResponse txnCommit(TxnCommitRequest request) {
        return txnCommit(System.identityHashCode(request), request);
    }

    default TxnCommitResponse txnCommit(long requestId, TxnCommitRequest request) {
        return getCaller().call(txnCommit, requestId, request, txnCommitHandlers);
    }

    @Deprecated
    default TxnCheckTxnStatusResponse txnCheckTxnStatus(TxnCheckTxnStatusRequest request) {
        return txnCheckTxnStatus(System.identityHashCode(request), request);
    }

    default TxnCheckTxnStatusResponse txnCheckTxnStatus(long requestId,
            TxnCheckTxnStatusRequest request) {
        return getCaller().call(txnCheckTxnStatus, requestId, request, txnCheckTxnStatusHandlers);
    }

    @Deprecated
    default TxnResolveLockResponse txnResolveLock(TxnResolveLockRequest request) {
        return txnResolveLock(System.identityHashCode(request), request);
    }

    default TxnResolveLockResponse txnResolveLock(long requestId, TxnResolveLockRequest request) {
        return getCaller().call(txnResolveLock, requestId, request, txnResolveLockHandlers);
    }

    @Deprecated
    default TxnBatchRollbackResponse txnBatchRollback(TxnBatchRollbackRequest request) {
        return txnBatchRollback(System.identityHashCode(request), request);
    }

    default TxnBatchRollbackResponse txnBatchRollback(long requestId,
            TxnBatchRollbackRequest request) {
        return getCaller().call(txnBatchRollback, requestId, request, txnBatchRollbackHandlers);
    }

    @Deprecated
    default TxnHeartBeatResponse txnHeartBeat(TxnHeartBeatRequest request) {
        return txnHeartBeat(System.identityHashCode(request), request);
    }

    default TxnHeartBeatResponse txnHeartBeat(long requestId, TxnHeartBeatRequest request) {
        return getCaller().call(txnHeartBeat, requestId, request, txnHeartBeatHandlers);
    }

    @Deprecated
    default TxnGcResponse txnGc(TxnGcRequest request) {
        return txnGc(System.identityHashCode(request), request);
    }

    default TxnGcResponse txnGc(long requestId, TxnGcRequest request) {
        return getCaller().call(txnGc, requestId, request, txnGcHandlers);
    }

    @Deprecated
    default TxnDeleteRangeResponse txnDeleteRange(TxnDeleteRangeRequest request) {
        return txnDeleteRange(System.identityHashCode(request), request);
    }

    default TxnDeleteRangeResponse txnDeleteRange(long requestId, TxnDeleteRangeRequest request) {
        return getCaller().call(txnDeleteRange, requestId, request, txnDeleteRangeHandlers);
    }

    @Deprecated
    default BackupDataResponse backupData(BackupDataRequest request) {
        return backupData(System.identityHashCode(request), request);
    }

    default BackupDataResponse backupData(long requestId, BackupDataRequest request) {
        return getCaller().call(backupData, requestId, request, backupDataHandlers);
    }

    @Deprecated
    default RestoreDataResponse restoreData(RestoreDataRequest request) {
        return restoreData(System.identityHashCode(request), request);
    }

    default RestoreDataResponse restoreData(long requestId, RestoreDataRequest request) {
        return getCaller().call(restoreData, requestId, request, restoreDataHandlers);
    }

    Caller<DocumentService> getCaller();

    @Getter
    @AllArgsConstructor
    class Impl implements DocumentService {
        public final Caller<DocumentService> caller;
    }
}
