package io.dingodb.sdk.service;

import static io.dingodb.sdk.service.desc.diskann.DiskAnnServiceDescriptors.*;

import io.dingodb.sdk.service.entity.diskann.VectorBuildRequest;
import io.dingodb.sdk.service.entity.diskann.VectorBuildResponse;
import io.dingodb.sdk.service.entity.diskann.VectorCloseRequest;
import io.dingodb.sdk.service.entity.diskann.VectorCloseResponse;
import io.dingodb.sdk.service.entity.diskann.VectorCountRequest;
import io.dingodb.sdk.service.entity.diskann.VectorCountResponse;
import io.dingodb.sdk.service.entity.diskann.VectorDestroyRequest;
import io.dingodb.sdk.service.entity.diskann.VectorDestroyResponse;
import io.dingodb.sdk.service.entity.diskann.VectorDumpAllRequest;
import io.dingodb.sdk.service.entity.diskann.VectorDumpAllResponse;
import io.dingodb.sdk.service.entity.diskann.VectorDumpRequest;
import io.dingodb.sdk.service.entity.diskann.VectorDumpResponse;
import io.dingodb.sdk.service.entity.diskann.VectorLoadRequest;
import io.dingodb.sdk.service.entity.diskann.VectorLoadResponse;
import io.dingodb.sdk.service.entity.diskann.VectorNewRequest;
import io.dingodb.sdk.service.entity.diskann.VectorNewResponse;
import io.dingodb.sdk.service.entity.diskann.VectorPushDataRequest;
import io.dingodb.sdk.service.entity.diskann.VectorPushDataResponse;
import io.dingodb.sdk.service.entity.diskann.VectorResetRequest;
import io.dingodb.sdk.service.entity.diskann.VectorResetResponse;
import io.dingodb.sdk.service.entity.diskann.VectorSearchRequest;
import io.dingodb.sdk.service.entity.diskann.VectorSearchResponse;
import io.dingodb.sdk.service.entity.diskann.VectorSetImportTooManyRequest;
import io.dingodb.sdk.service.entity.diskann.VectorSetImportTooManyResponse;
import io.dingodb.sdk.service.entity.diskann.VectorSetNoDataRequest;
import io.dingodb.sdk.service.entity.diskann.VectorSetNoDataResponse;
import io.dingodb.sdk.service.entity.diskann.VectorStatusRequest;
import io.dingodb.sdk.service.entity.diskann.VectorStatusResponse;
import io.dingodb.sdk.service.entity.diskann.VectorTryLoadRequest;
import io.dingodb.sdk.service.entity.diskann.VectorTryLoadResponse;
import lombok.AllArgsConstructor;
import lombok.Getter;

public interface DiskAnnService extends Service<DiskAnnService> {
    @Deprecated
    default VectorNewResponse vectorNew(VectorNewRequest request) {
        return vectorNew(System.identityHashCode(request), request);
    }

    default VectorNewResponse vectorNew(long requestId, VectorNewRequest request) {
        return getCaller().call(vectorNew, requestId, request, vectorNewHandlers);
    }

    @Deprecated
    default VectorPushDataResponse vectorPushData(VectorPushDataRequest request) {
        return vectorPushData(System.identityHashCode(request), request);
    }

    default VectorPushDataResponse vectorPushData(long requestId, VectorPushDataRequest request) {
        return getCaller().call(vectorPushData, requestId, request, vectorPushDataHandlers);
    }

    @Deprecated
    default VectorBuildResponse vectorBuild(VectorBuildRequest request) {
        return vectorBuild(System.identityHashCode(request), request);
    }

    default VectorBuildResponse vectorBuild(long requestId, VectorBuildRequest request) {
        return getCaller().call(vectorBuild, requestId, request, vectorBuildHandlers);
    }

    @Deprecated
    default VectorLoadResponse vectorLoad(VectorLoadRequest request) {
        return vectorLoad(System.identityHashCode(request), request);
    }

    default VectorLoadResponse vectorLoad(long requestId, VectorLoadRequest request) {
        return getCaller().call(vectorLoad, requestId, request, vectorLoadHandlers);
    }

    @Deprecated
    default VectorTryLoadResponse vectorTryLoad(VectorTryLoadRequest request) {
        return vectorTryLoad(System.identityHashCode(request), request);
    }

    default VectorTryLoadResponse vectorTryLoad(long requestId, VectorTryLoadRequest request) {
        return getCaller().call(vectorTryLoad, requestId, request, vectorTryLoadHandlers);
    }

    @Deprecated
    default VectorSearchResponse vectorSearch(VectorSearchRequest request) {
        return vectorSearch(System.identityHashCode(request), request);
    }

    default VectorSearchResponse vectorSearch(long requestId, VectorSearchRequest request) {
        return getCaller().call(vectorSearch, requestId, request, vectorSearchHandlers);
    }

    @Deprecated
    default VectorResetResponse vectorReset(VectorResetRequest request) {
        return vectorReset(System.identityHashCode(request), request);
    }

    default VectorResetResponse vectorReset(long requestId, VectorResetRequest request) {
        return getCaller().call(vectorReset, requestId, request, vectorResetHandlers);
    }

    @Deprecated
    default VectorCloseResponse vectorClose(VectorCloseRequest request) {
        return vectorClose(System.identityHashCode(request), request);
    }

    default VectorCloseResponse vectorClose(long requestId, VectorCloseRequest request) {
        return getCaller().call(vectorClose, requestId, request, vectorCloseHandlers);
    }

    @Deprecated
    default VectorDestroyResponse vectorDestroy(VectorDestroyRequest request) {
        return vectorDestroy(System.identityHashCode(request), request);
    }

    default VectorDestroyResponse vectorDestroy(long requestId, VectorDestroyRequest request) {
        return getCaller().call(vectorDestroy, requestId, request, vectorDestroyHandlers);
    }

    @Deprecated
    default VectorStatusResponse vectorStatus(VectorStatusRequest request) {
        return vectorStatus(System.identityHashCode(request), request);
    }

    default VectorStatusResponse vectorStatus(long requestId, VectorStatusRequest request) {
        return getCaller().call(vectorStatus, requestId, request, vectorStatusHandlers);
    }

    @Deprecated
    default VectorCountResponse vectorCount(VectorCountRequest request) {
        return vectorCount(System.identityHashCode(request), request);
    }

    default VectorCountResponse vectorCount(long requestId, VectorCountRequest request) {
        return getCaller().call(vectorCount, requestId, request, vectorCountHandlers);
    }

    @Deprecated
    default VectorSetNoDataResponse vectorSetNoData(VectorSetNoDataRequest request) {
        return vectorSetNoData(System.identityHashCode(request), request);
    }

    default VectorSetNoDataResponse vectorSetNoData(long requestId,
            VectorSetNoDataRequest request) {
        return getCaller().call(vectorSetNoData, requestId, request, vectorSetNoDataHandlers);
    }

    @Deprecated
    default VectorSetImportTooManyResponse vectorSetImportTooMany(
            VectorSetImportTooManyRequest request) {
        return vectorSetImportTooMany(System.identityHashCode(request), request);
    }

    default VectorSetImportTooManyResponse vectorSetImportTooMany(long requestId,
            VectorSetImportTooManyRequest request) {
        return getCaller().call(vectorSetImportTooMany, requestId, request, vectorSetImportTooManyHandlers);
    }

    @Deprecated
    default VectorDumpResponse vectorDump(VectorDumpRequest request) {
        return vectorDump(System.identityHashCode(request), request);
    }

    default VectorDumpResponse vectorDump(long requestId, VectorDumpRequest request) {
        return getCaller().call(vectorDump, requestId, request, vectorDumpHandlers);
    }

    @Deprecated
    default VectorDumpAllResponse vectorDumpAll(VectorDumpAllRequest request) {
        return vectorDumpAll(System.identityHashCode(request), request);
    }

    default VectorDumpAllResponse vectorDumpAll(long requestId, VectorDumpAllRequest request) {
        return getCaller().call(vectorDumpAll, requestId, request, vectorDumpAllHandlers);
    }

    Caller<DiskAnnService> getCaller();

    @Getter
    @AllArgsConstructor
    class Impl implements DiskAnnService {
        public final Caller<DiskAnnService> caller;
    }
}
