package io.dingodb.sdk.service;

import static io.dingodb.sdk.service.desc.debug.DebugServiceDescriptors.*;

import io.dingodb.sdk.service.entity.debug.AddRegionRequest;
import io.dingodb.sdk.service.entity.debug.AddRegionResponse;
import io.dingodb.sdk.service.entity.debug.AdjustThreadPoolSizeRequest;
import io.dingodb.sdk.service.entity.debug.AdjustThreadPoolSizeResponse;
import io.dingodb.sdk.service.entity.debug.BindCoreRequest;
import io.dingodb.sdk.service.entity.debug.BindCoreResponse;
import io.dingodb.sdk.service.entity.debug.ChangeRegionRequest;
import io.dingodb.sdk.service.entity.debug.ChangeRegionResponse;
import io.dingodb.sdk.service.entity.debug.CompactRequest;
import io.dingodb.sdk.service.entity.debug.CompactResponse;
import io.dingodb.sdk.service.entity.debug.DebugRequest;
import io.dingodb.sdk.service.entity.debug.DebugResponse;
import io.dingodb.sdk.service.entity.debug.DestroyRegionRequest;
import io.dingodb.sdk.service.entity.debug.DestroyRegionResponse;
import io.dingodb.sdk.service.entity.debug.DumpRegionRequest;
import io.dingodb.sdk.service.entity.debug.DumpRegionResponse;
import io.dingodb.sdk.service.entity.debug.GetMemoryStatsRequest;
import io.dingodb.sdk.service.entity.debug.GetMemoryStatsResponse;
import io.dingodb.sdk.service.entity.debug.MergeRegionRequest;
import io.dingodb.sdk.service.entity.debug.MergeRegionResponse;
import io.dingodb.sdk.service.entity.debug.ModifyRegionMetaRequest;
import io.dingodb.sdk.service.entity.debug.ModifyRegionMetaResponse;
import io.dingodb.sdk.service.entity.debug.ReleaseFreeMemoryRequest;
import io.dingodb.sdk.service.entity.debug.ReleaseFreeMemoryResponse;
import io.dingodb.sdk.service.entity.debug.ShowAffinityRequest;
import io.dingodb.sdk.service.entity.debug.ShowAffinityResponse;
import io.dingodb.sdk.service.entity.debug.SnapshotRequest;
import io.dingodb.sdk.service.entity.debug.SnapshotResponse;
import io.dingodb.sdk.service.entity.debug.SnapshotVectorIndexRequest;
import io.dingodb.sdk.service.entity.debug.SnapshotVectorIndexResponse;
import io.dingodb.sdk.service.entity.debug.TraceWorkQueueRequest;
import io.dingodb.sdk.service.entity.debug.TraceWorkQueueResponse;
import io.dingodb.sdk.service.entity.debug.TransferLeaderRequest;
import io.dingodb.sdk.service.entity.debug.TransferLeaderResponse;
import io.dingodb.sdk.service.entity.debug.TriggerRebuildVectorIndexRequest;
import io.dingodb.sdk.service.entity.debug.TriggerRebuildVectorIndexResponse;
import io.dingodb.sdk.service.entity.debug.TriggerSaveVectorIndexRequest;
import io.dingodb.sdk.service.entity.debug.TriggerSaveVectorIndexResponse;
import io.dingodb.sdk.service.entity.debug.TriggerVectorIndexSnapshotRequest;
import io.dingodb.sdk.service.entity.debug.TriggerVectorIndexSnapshotResponse;
import io.dingodb.sdk.service.entity.debug.UnbindCoreRequest;
import io.dingodb.sdk.service.entity.debug.UnbindCoreResponse;
import lombok.AllArgsConstructor;
import lombok.Getter;

public interface DebugService extends Service<DebugService> {
    @Deprecated
    default AddRegionResponse addRegion(AddRegionRequest request) {
        return addRegion(System.identityHashCode(request), request);
    }

    default AddRegionResponse addRegion(long requestId, AddRegionRequest request) {
        return getCaller().call(addRegion, requestId, request, addRegionHandlers);
    }

    @Deprecated
    default ChangeRegionResponse changeRegion(ChangeRegionRequest request) {
        return changeRegion(System.identityHashCode(request), request);
    }

    default ChangeRegionResponse changeRegion(long requestId, ChangeRegionRequest request) {
        return getCaller().call(changeRegion, requestId, request, changeRegionHandlers);
    }

    @Deprecated
    default MergeRegionResponse mergeRegion(MergeRegionRequest request) {
        return mergeRegion(System.identityHashCode(request), request);
    }

    default MergeRegionResponse mergeRegion(long requestId, MergeRegionRequest request) {
        return getCaller().call(mergeRegion, requestId, request, mergeRegionHandlers);
    }

    @Deprecated
    default DestroyRegionResponse destroyRegion(DestroyRegionRequest request) {
        return destroyRegion(System.identityHashCode(request), request);
    }

    default DestroyRegionResponse destroyRegion(long requestId, DestroyRegionRequest request) {
        return getCaller().call(destroyRegion, requestId, request, destroyRegionHandlers);
    }

    @Deprecated
    default SnapshotResponse snapshot(SnapshotRequest request) {
        return snapshot(System.identityHashCode(request), request);
    }

    default SnapshotResponse snapshot(long requestId, SnapshotRequest request) {
        return getCaller().call(snapshot, requestId, request, snapshotHandlers);
    }

    @Deprecated
    default TransferLeaderResponse transferLeader(TransferLeaderRequest request) {
        return transferLeader(System.identityHashCode(request), request);
    }

    default TransferLeaderResponse transferLeader(long requestId, TransferLeaderRequest request) {
        return getCaller().call(transferLeader, requestId, request, transferLeaderHandlers);
    }

    @Deprecated
    default ModifyRegionMetaResponse modifyRegionMeta(ModifyRegionMetaRequest request) {
        return modifyRegionMeta(System.identityHashCode(request), request);
    }

    default ModifyRegionMetaResponse modifyRegionMeta(long requestId,
            ModifyRegionMetaRequest request) {
        return getCaller().call(modifyRegionMeta, requestId, request, modifyRegionMetaHandlers);
    }

    @Deprecated
    default SnapshotVectorIndexResponse snapshotVectorIndex(SnapshotVectorIndexRequest request) {
        return snapshotVectorIndex(System.identityHashCode(request), request);
    }

    default SnapshotVectorIndexResponse snapshotVectorIndex(long requestId,
            SnapshotVectorIndexRequest request) {
        return getCaller().call(snapshotVectorIndex, requestId, request, snapshotVectorIndexHandlers);
    }

    @Deprecated
    default TriggerVectorIndexSnapshotResponse triggerVectorIndexSnapshot(
            TriggerVectorIndexSnapshotRequest request) {
        return triggerVectorIndexSnapshot(System.identityHashCode(request), request);
    }

    default TriggerVectorIndexSnapshotResponse triggerVectorIndexSnapshot(long requestId,
            TriggerVectorIndexSnapshotRequest request) {
        return getCaller().call(triggerVectorIndexSnapshot, requestId, request, triggerVectorIndexSnapshotHandlers);
    }

    @Deprecated
    default TriggerRebuildVectorIndexResponse triggerRebuildVectorIndex(
            TriggerRebuildVectorIndexRequest request) {
        return triggerRebuildVectorIndex(System.identityHashCode(request), request);
    }

    default TriggerRebuildVectorIndexResponse triggerRebuildVectorIndex(long requestId,
            TriggerRebuildVectorIndexRequest request) {
        return getCaller().call(triggerRebuildVectorIndex, requestId, request, triggerRebuildVectorIndexHandlers);
    }

    @Deprecated
    default TriggerSaveVectorIndexResponse triggerSaveVectorIndex(
            TriggerSaveVectorIndexRequest request) {
        return triggerSaveVectorIndex(System.identityHashCode(request), request);
    }

    default TriggerSaveVectorIndexResponse triggerSaveVectorIndex(long requestId,
            TriggerSaveVectorIndexRequest request) {
        return getCaller().call(triggerSaveVectorIndex, requestId, request, triggerSaveVectorIndexHandlers);
    }

    @Deprecated
    default CompactResponse compact(CompactRequest request) {
        return compact(System.identityHashCode(request), request);
    }

    default CompactResponse compact(long requestId, CompactRequest request) {
        return getCaller().call(compact, requestId, request, compactHandlers);
    }

    @Deprecated
    default DebugResponse debug(DebugRequest request) {
        return debug(System.identityHashCode(request), request);
    }

    default DebugResponse debug(long requestId, DebugRequest request) {
        return getCaller().call(debug, requestId, request, debugHandlers);
    }

    @Deprecated
    default GetMemoryStatsResponse getMemoryStats(GetMemoryStatsRequest request) {
        return getMemoryStats(System.identityHashCode(request), request);
    }

    default GetMemoryStatsResponse getMemoryStats(long requestId, GetMemoryStatsRequest request) {
        return getCaller().call(getMemoryStats, requestId, request, getMemoryStatsHandlers);
    }

    @Deprecated
    default ReleaseFreeMemoryResponse releaseFreeMemory(ReleaseFreeMemoryRequest request) {
        return releaseFreeMemory(System.identityHashCode(request), request);
    }

    default ReleaseFreeMemoryResponse releaseFreeMemory(long requestId,
            ReleaseFreeMemoryRequest request) {
        return getCaller().call(releaseFreeMemory, requestId, request, releaseFreeMemoryHandlers);
    }

    @Deprecated
    default TraceWorkQueueResponse traceWorkQueue(TraceWorkQueueRequest request) {
        return traceWorkQueue(System.identityHashCode(request), request);
    }

    default TraceWorkQueueResponse traceWorkQueue(long requestId, TraceWorkQueueRequest request) {
        return getCaller().call(traceWorkQueue, requestId, request, traceWorkQueueHandlers);
    }

    @Deprecated
    default AdjustThreadPoolSizeResponse adjustThreadPoolSize(AdjustThreadPoolSizeRequest request) {
        return adjustThreadPoolSize(System.identityHashCode(request), request);
    }

    default AdjustThreadPoolSizeResponse adjustThreadPoolSize(long requestId,
            AdjustThreadPoolSizeRequest request) {
        return getCaller().call(adjustThreadPoolSize, requestId, request, adjustThreadPoolSizeHandlers);
    }

    @Deprecated
    default BindCoreResponse bindCore(BindCoreRequest request) {
        return bindCore(System.identityHashCode(request), request);
    }

    default BindCoreResponse bindCore(long requestId, BindCoreRequest request) {
        return getCaller().call(bindCore, requestId, request, bindCoreHandlers);
    }

    @Deprecated
    default UnbindCoreResponse unbindCore(UnbindCoreRequest request) {
        return unbindCore(System.identityHashCode(request), request);
    }

    default UnbindCoreResponse unbindCore(long requestId, UnbindCoreRequest request) {
        return getCaller().call(unbindCore, requestId, request, unbindCoreHandlers);
    }

    @Deprecated
    default ShowAffinityResponse showAffinity(ShowAffinityRequest request) {
        return showAffinity(System.identityHashCode(request), request);
    }

    default ShowAffinityResponse showAffinity(long requestId, ShowAffinityRequest request) {
        return getCaller().call(showAffinity, requestId, request, showAffinityHandlers);
    }

    @Deprecated
    default DumpRegionResponse dumpRegion(DumpRegionRequest request) {
        return dumpRegion(System.identityHashCode(request), request);
    }

    default DumpRegionResponse dumpRegion(long requestId, DumpRegionRequest request) {
        return getCaller().call(dumpRegion, requestId, request, dumpRegionHandlers);
    }

    Caller<DebugService> getCaller();

    @Getter
    @AllArgsConstructor
    class Impl implements DebugService {
        public final Caller<DebugService> caller;
    }
}
