package io.dingodb.sdk.service;

import static io.dingodb.sdk.service.desc.coordinator.CoordinatorServiceDescriptors.*;

import io.dingodb.sdk.service.entity.coordinator.AddDeletedRegionMapRequest;
import io.dingodb.sdk.service.entity.coordinator.AddDeletedRegionMapResponse;
import io.dingodb.sdk.service.entity.coordinator.AddStoreOperationRequest;
import io.dingodb.sdk.service.entity.coordinator.AddStoreOperationResponse;
import io.dingodb.sdk.service.entity.coordinator.BalanceLeaderRequest;
import io.dingodb.sdk.service.entity.coordinator.BalanceLeaderResponse;
import io.dingodb.sdk.service.entity.coordinator.BalanceRegionRequest;
import io.dingodb.sdk.service.entity.coordinator.BalanceRegionResponse;
import io.dingodb.sdk.service.entity.coordinator.ChangePeerRegionRequest;
import io.dingodb.sdk.service.entity.coordinator.ChangePeerRegionResponse;
import io.dingodb.sdk.service.entity.coordinator.CleanDeletedRegionMapRequest;
import io.dingodb.sdk.service.entity.coordinator.CleanDeletedRegionMapResponse;
import io.dingodb.sdk.service.entity.coordinator.CleanJobListRequest;
import io.dingodb.sdk.service.entity.coordinator.CleanJobListResponse;
import io.dingodb.sdk.service.entity.coordinator.CleanStoreOperationRequest;
import io.dingodb.sdk.service.entity.coordinator.CleanStoreOperationResponse;
import io.dingodb.sdk.service.entity.coordinator.ConfigCoordinatorRequest;
import io.dingodb.sdk.service.entity.coordinator.ConfigCoordinatorResponse;
import io.dingodb.sdk.service.entity.coordinator.ControlConfigRequest;
import io.dingodb.sdk.service.entity.coordinator.ControlConfigResponse;
import io.dingodb.sdk.service.entity.coordinator.CreateExecutorRequest;
import io.dingodb.sdk.service.entity.coordinator.CreateExecutorResponse;
import io.dingodb.sdk.service.entity.coordinator.CreateExecutorUserRequest;
import io.dingodb.sdk.service.entity.coordinator.CreateExecutorUserResponse;
import io.dingodb.sdk.service.entity.coordinator.CreateIdsRequest;
import io.dingodb.sdk.service.entity.coordinator.CreateIdsResponse;
import io.dingodb.sdk.service.entity.coordinator.CreateRegionIdRequest;
import io.dingodb.sdk.service.entity.coordinator.CreateRegionIdResponse;
import io.dingodb.sdk.service.entity.coordinator.CreateRegionRequest;
import io.dingodb.sdk.service.entity.coordinator.CreateRegionResponse;
import io.dingodb.sdk.service.entity.coordinator.CreateStoreRequest;
import io.dingodb.sdk.service.entity.coordinator.CreateStoreResponse;
import io.dingodb.sdk.service.entity.coordinator.DeleteExecutorRequest;
import io.dingodb.sdk.service.entity.coordinator.DeleteExecutorResponse;
import io.dingodb.sdk.service.entity.coordinator.DeleteExecutorUserRequest;
import io.dingodb.sdk.service.entity.coordinator.DeleteExecutorUserResponse;
import io.dingodb.sdk.service.entity.coordinator.DeleteRegionMetricsRequest;
import io.dingodb.sdk.service.entity.coordinator.DeleteRegionMetricsResponse;
import io.dingodb.sdk.service.entity.coordinator.DeleteStoreMetricsRequest;
import io.dingodb.sdk.service.entity.coordinator.DeleteStoreMetricsResponse;
import io.dingodb.sdk.service.entity.coordinator.DeleteStoreRequest;
import io.dingodb.sdk.service.entity.coordinator.DeleteStoreResponse;
import io.dingodb.sdk.service.entity.coordinator.DropRegionPermanentlyRequest;
import io.dingodb.sdk.service.entity.coordinator.DropRegionPermanentlyResponse;
import io.dingodb.sdk.service.entity.coordinator.DropRegionRequest;
import io.dingodb.sdk.service.entity.coordinator.DropRegionResponse;
import io.dingodb.sdk.service.entity.coordinator.ExecutorHeartbeatRequest;
import io.dingodb.sdk.service.entity.coordinator.ExecutorHeartbeatResponse;
import io.dingodb.sdk.service.entity.coordinator.GetCoordinatorMapRequest;
import io.dingodb.sdk.service.entity.coordinator.GetCoordinatorMapResponse;
import io.dingodb.sdk.service.entity.coordinator.GetDeletedRegionMapRequest;
import io.dingodb.sdk.service.entity.coordinator.GetDeletedRegionMapResponse;
import io.dingodb.sdk.service.entity.coordinator.GetExecutorMapRequest;
import io.dingodb.sdk.service.entity.coordinator.GetExecutorMapResponse;
import io.dingodb.sdk.service.entity.coordinator.GetExecutorUserMapRequest;
import io.dingodb.sdk.service.entity.coordinator.GetExecutorUserMapResponse;
import io.dingodb.sdk.service.entity.coordinator.GetGCSafePointRequest;
import io.dingodb.sdk.service.entity.coordinator.GetGCSafePointResponse;
import io.dingodb.sdk.service.entity.coordinator.GetJobListRequest;
import io.dingodb.sdk.service.entity.coordinator.GetJobListResponse;
import io.dingodb.sdk.service.entity.coordinator.GetMDSListRequest;
import io.dingodb.sdk.service.entity.coordinator.GetMDSListResponse;
import io.dingodb.sdk.service.entity.coordinator.GetOrphanRegionRequest;
import io.dingodb.sdk.service.entity.coordinator.GetOrphanRegionResponse;
import io.dingodb.sdk.service.entity.coordinator.GetRangeRegionMapRequest;
import io.dingodb.sdk.service.entity.coordinator.GetRangeRegionMapResponse;
import io.dingodb.sdk.service.entity.coordinator.GetRegionCmdRequest;
import io.dingodb.sdk.service.entity.coordinator.GetRegionCmdResponse;
import io.dingodb.sdk.service.entity.coordinator.GetRegionCountRequest;
import io.dingodb.sdk.service.entity.coordinator.GetRegionCountResponse;
import io.dingodb.sdk.service.entity.coordinator.GetRegionMapRequest;
import io.dingodb.sdk.service.entity.coordinator.GetRegionMapResponse;
import io.dingodb.sdk.service.entity.coordinator.GetRegionMetricsRequest;
import io.dingodb.sdk.service.entity.coordinator.GetRegionMetricsResponse;
import io.dingodb.sdk.service.entity.coordinator.GetStoreMapRequest;
import io.dingodb.sdk.service.entity.coordinator.GetStoreMapResponse;
import io.dingodb.sdk.service.entity.coordinator.GetStoreMetricsRequest;
import io.dingodb.sdk.service.entity.coordinator.GetStoreMetricsResponse;
import io.dingodb.sdk.service.entity.coordinator.GetStoreOperationRequest;
import io.dingodb.sdk.service.entity.coordinator.GetStoreOperationResponse;
import io.dingodb.sdk.service.entity.coordinator.GetStoreOwnMetricsRequest;
import io.dingodb.sdk.service.entity.coordinator.GetStoreOwnMetricsResponse;
import io.dingodb.sdk.service.entity.coordinator.HelloRequest;
import io.dingodb.sdk.service.entity.coordinator.HelloResponse;
import io.dingodb.sdk.service.entity.coordinator.MDSHeartbeatRequest;
import io.dingodb.sdk.service.entity.coordinator.MDSHeartbeatResponse;
import io.dingodb.sdk.service.entity.coordinator.MergeRegionRequest;
import io.dingodb.sdk.service.entity.coordinator.MergeRegionResponse;
import io.dingodb.sdk.service.entity.coordinator.QueryRegionRequest;
import io.dingodb.sdk.service.entity.coordinator.QueryRegionResponse;
import io.dingodb.sdk.service.entity.coordinator.RaftControlRequest;
import io.dingodb.sdk.service.entity.coordinator.RaftControlResponse;
import io.dingodb.sdk.service.entity.coordinator.RegisterBackupRequest;
import io.dingodb.sdk.service.entity.coordinator.RegisterBackupResponse;
import io.dingodb.sdk.service.entity.coordinator.RegisterBackupStatusRequest;
import io.dingodb.sdk.service.entity.coordinator.RegisterBackupStatusResponse;
import io.dingodb.sdk.service.entity.coordinator.RegisterRestoreRequest;
import io.dingodb.sdk.service.entity.coordinator.RegisterRestoreResponse;
import io.dingodb.sdk.service.entity.coordinator.RegisterRestoreStatusRequest;
import io.dingodb.sdk.service.entity.coordinator.RegisterRestoreStatusResponse;
import io.dingodb.sdk.service.entity.coordinator.RemoveStoreOperationRequest;
import io.dingodb.sdk.service.entity.coordinator.RemoveStoreOperationResponse;
import io.dingodb.sdk.service.entity.coordinator.ScanRegionsRequest;
import io.dingodb.sdk.service.entity.coordinator.ScanRegionsResponse;
import io.dingodb.sdk.service.entity.coordinator.SplitRegionRequest;
import io.dingodb.sdk.service.entity.coordinator.SplitRegionResponse;
import io.dingodb.sdk.service.entity.coordinator.StoreHeartbeatRequest;
import io.dingodb.sdk.service.entity.coordinator.StoreHeartbeatResponse;
import io.dingodb.sdk.service.entity.coordinator.TransferLeaderRegionRequest;
import io.dingodb.sdk.service.entity.coordinator.TransferLeaderRegionResponse;
import io.dingodb.sdk.service.entity.coordinator.UnRegisterBackupRequest;
import io.dingodb.sdk.service.entity.coordinator.UnRegisterBackupResponse;
import io.dingodb.sdk.service.entity.coordinator.UnRegisterRestoreRequest;
import io.dingodb.sdk.service.entity.coordinator.UnRegisterRestoreResponse;
import io.dingodb.sdk.service.entity.coordinator.UpdateExecutorUserRequest;
import io.dingodb.sdk.service.entity.coordinator.UpdateExecutorUserResponse;
import io.dingodb.sdk.service.entity.coordinator.UpdateGCSafePointRequest;
import io.dingodb.sdk.service.entity.coordinator.UpdateGCSafePointResponse;
import io.dingodb.sdk.service.entity.coordinator.UpdateRegionCmdStatusRequest;
import io.dingodb.sdk.service.entity.coordinator.UpdateRegionCmdStatusResponse;
import io.dingodb.sdk.service.entity.coordinator.UpdateStoreRequest;
import io.dingodb.sdk.service.entity.coordinator.UpdateStoreResponse;
import lombok.AllArgsConstructor;
import lombok.Getter;

public interface CoordinatorService extends Service<CoordinatorService> {
    @Deprecated
    default HelloResponse hello(HelloRequest request) {
        return hello(System.identityHashCode(request), request);
    }

    default HelloResponse hello(long requestId, HelloRequest request) {
        return getCaller().call(hello, requestId, request, helloHandlers);
    }

    @Deprecated
    default HelloResponse getMemoryInfo(HelloRequest request) {
        return getMemoryInfo(System.identityHashCode(request), request);
    }

    default HelloResponse getMemoryInfo(long requestId, HelloRequest request) {
        return getCaller().call(getMemoryInfo, requestId, request, getMemoryInfoHandlers);
    }

    @Deprecated
    default StoreHeartbeatResponse storeHeartbeat(StoreHeartbeatRequest request) {
        return storeHeartbeat(System.identityHashCode(request), request);
    }

    default StoreHeartbeatResponse storeHeartbeat(long requestId, StoreHeartbeatRequest request) {
        return getCaller().call(storeHeartbeat, requestId, request, storeHeartbeatHandlers);
    }

    @Deprecated
    default GetRegionMapResponse getRegionMap(GetRegionMapRequest request) {
        return getRegionMap(System.identityHashCode(request), request);
    }

    default GetRegionMapResponse getRegionMap(long requestId, GetRegionMapRequest request) {
        return getCaller().call(getRegionMap, requestId, request, getRegionMapHandlers);
    }

    @Deprecated
    default GetDeletedRegionMapResponse getDeletedRegionMap(GetDeletedRegionMapRequest request) {
        return getDeletedRegionMap(System.identityHashCode(request), request);
    }

    default GetDeletedRegionMapResponse getDeletedRegionMap(long requestId,
            GetDeletedRegionMapRequest request) {
        return getCaller().call(getDeletedRegionMap, requestId, request, getDeletedRegionMapHandlers);
    }

    @Deprecated
    default AddDeletedRegionMapResponse addDeletedRegionMap(AddDeletedRegionMapRequest request) {
        return addDeletedRegionMap(System.identityHashCode(request), request);
    }

    default AddDeletedRegionMapResponse addDeletedRegionMap(long requestId,
            AddDeletedRegionMapRequest request) {
        return getCaller().call(addDeletedRegionMap, requestId, request, addDeletedRegionMapHandlers);
    }

    @Deprecated
    default CleanDeletedRegionMapResponse cleanDeletedRegionMap(
            CleanDeletedRegionMapRequest request) {
        return cleanDeletedRegionMap(System.identityHashCode(request), request);
    }

    default CleanDeletedRegionMapResponse cleanDeletedRegionMap(long requestId,
            CleanDeletedRegionMapRequest request) {
        return getCaller().call(cleanDeletedRegionMap, requestId, request, cleanDeletedRegionMapHandlers);
    }

    @Deprecated
    default GetRegionCountResponse getRegionCount(GetRegionCountRequest request) {
        return getRegionCount(System.identityHashCode(request), request);
    }

    default GetRegionCountResponse getRegionCount(long requestId, GetRegionCountRequest request) {
        return getCaller().call(getRegionCount, requestId, request, getRegionCountHandlers);
    }

    @Deprecated
    default GetStoreMapResponse getStoreMap(GetStoreMapRequest request) {
        return getStoreMap(System.identityHashCode(request), request);
    }

    default GetStoreMapResponse getStoreMap(long requestId, GetStoreMapRequest request) {
        return getCaller().call(getStoreMap, requestId, request, getStoreMapHandlers);
    }

    @Deprecated
    default GetStoreMetricsResponse getStoreMetrics(GetStoreMetricsRequest request) {
        return getStoreMetrics(System.identityHashCode(request), request);
    }

    default GetStoreMetricsResponse getStoreMetrics(long requestId,
            GetStoreMetricsRequest request) {
        return getCaller().call(getStoreMetrics, requestId, request, getStoreMetricsHandlers);
    }

    @Deprecated
    default DeleteStoreMetricsResponse deleteStoreMetrics(DeleteStoreMetricsRequest request) {
        return deleteStoreMetrics(System.identityHashCode(request), request);
    }

    default DeleteStoreMetricsResponse deleteStoreMetrics(long requestId,
            DeleteStoreMetricsRequest request) {
        return getCaller().call(deleteStoreMetrics, requestId, request, deleteStoreMetricsHandlers);
    }

    @Deprecated
    default GetRegionMetricsResponse getRegionMetrics(GetRegionMetricsRequest request) {
        return getRegionMetrics(System.identityHashCode(request), request);
    }

    default GetRegionMetricsResponse getRegionMetrics(long requestId,
            GetRegionMetricsRequest request) {
        return getCaller().call(getRegionMetrics, requestId, request, getRegionMetricsHandlers);
    }

    @Deprecated
    default DeleteRegionMetricsResponse deleteRegionMetrics(DeleteRegionMetricsRequest request) {
        return deleteRegionMetrics(System.identityHashCode(request), request);
    }

    default DeleteRegionMetricsResponse deleteRegionMetrics(long requestId,
            DeleteRegionMetricsRequest request) {
        return getCaller().call(deleteRegionMetrics, requestId, request, deleteRegionMetricsHandlers);
    }

    @Deprecated
    default CreateStoreResponse createStore(CreateStoreRequest request) {
        return createStore(System.identityHashCode(request), request);
    }

    default CreateStoreResponse createStore(long requestId, CreateStoreRequest request) {
        return getCaller().call(createStore, requestId, request, createStoreHandlers);
    }

    @Deprecated
    default DeleteStoreResponse deleteStore(DeleteStoreRequest request) {
        return deleteStore(System.identityHashCode(request), request);
    }

    default DeleteStoreResponse deleteStore(long requestId, DeleteStoreRequest request) {
        return getCaller().call(deleteStore, requestId, request, deleteStoreHandlers);
    }

    @Deprecated
    default UpdateStoreResponse updateStore(UpdateStoreRequest request) {
        return updateStore(System.identityHashCode(request), request);
    }

    default UpdateStoreResponse updateStore(long requestId, UpdateStoreRequest request) {
        return getCaller().call(updateStore, requestId, request, updateStoreHandlers);
    }

    @Deprecated
    default GetStoreOwnMetricsResponse getStoreOwnMetrics(GetStoreOwnMetricsRequest request) {
        return getStoreOwnMetrics(System.identityHashCode(request), request);
    }

    default GetStoreOwnMetricsResponse getStoreOwnMetrics(long requestId,
            GetStoreOwnMetricsRequest request) {
        return getCaller().call(getStoreOwnMetrics, requestId, request, getStoreOwnMetricsHandlers);
    }

    @Deprecated
    default ExecutorHeartbeatResponse executorHeartbeat(ExecutorHeartbeatRequest request) {
        return executorHeartbeat(System.identityHashCode(request), request);
    }

    default ExecutorHeartbeatResponse executorHeartbeat(long requestId,
            ExecutorHeartbeatRequest request) {
        return getCaller().call(executorHeartbeat, requestId, request, executorHeartbeatHandlers);
    }

    @Deprecated
    default CreateExecutorResponse createExecutor(CreateExecutorRequest request) {
        return createExecutor(System.identityHashCode(request), request);
    }

    default CreateExecutorResponse createExecutor(long requestId, CreateExecutorRequest request) {
        return getCaller().call(createExecutor, requestId, request, createExecutorHandlers);
    }

    @Deprecated
    default DeleteExecutorResponse deleteExecutor(DeleteExecutorRequest request) {
        return deleteExecutor(System.identityHashCode(request), request);
    }

    default DeleteExecutorResponse deleteExecutor(long requestId, DeleteExecutorRequest request) {
        return getCaller().call(deleteExecutor, requestId, request, deleteExecutorHandlers);
    }

    @Deprecated
    default GetExecutorMapResponse getExecutorMap(GetExecutorMapRequest request) {
        return getExecutorMap(System.identityHashCode(request), request);
    }

    default GetExecutorMapResponse getExecutorMap(long requestId, GetExecutorMapRequest request) {
        return getCaller().call(getExecutorMap, requestId, request, getExecutorMapHandlers);
    }

    @Deprecated
    default CreateExecutorUserResponse createExecutorUser(CreateExecutorUserRequest request) {
        return createExecutorUser(System.identityHashCode(request), request);
    }

    default CreateExecutorUserResponse createExecutorUser(long requestId,
            CreateExecutorUserRequest request) {
        return getCaller().call(createExecutorUser, requestId, request, createExecutorUserHandlers);
    }

    @Deprecated
    default DeleteExecutorUserResponse deleteExecutorUser(DeleteExecutorUserRequest request) {
        return deleteExecutorUser(System.identityHashCode(request), request);
    }

    default DeleteExecutorUserResponse deleteExecutorUser(long requestId,
            DeleteExecutorUserRequest request) {
        return getCaller().call(deleteExecutorUser, requestId, request, deleteExecutorUserHandlers);
    }

    @Deprecated
    default UpdateExecutorUserResponse updateExecutorUser(UpdateExecutorUserRequest request) {
        return updateExecutorUser(System.identityHashCode(request), request);
    }

    default UpdateExecutorUserResponse updateExecutorUser(long requestId,
            UpdateExecutorUserRequest request) {
        return getCaller().call(updateExecutorUser, requestId, request, updateExecutorUserHandlers);
    }

    @Deprecated
    default GetExecutorUserMapResponse getExecutorUserMap(GetExecutorUserMapRequest request) {
        return getExecutorUserMap(System.identityHashCode(request), request);
    }

    default GetExecutorUserMapResponse getExecutorUserMap(long requestId,
            GetExecutorUserMapRequest request) {
        return getCaller().call(getExecutorUserMap, requestId, request, getExecutorUserMapHandlers);
    }

    @Deprecated
    default GetCoordinatorMapResponse getCoordinatorMap(GetCoordinatorMapRequest request) {
        return getCoordinatorMap(System.identityHashCode(request), request);
    }

    default GetCoordinatorMapResponse getCoordinatorMap(long requestId,
            GetCoordinatorMapRequest request) {
        return getCaller().call(getCoordinatorMap, requestId, request, getCoordinatorMapHandlers);
    }

    @Deprecated
    default ConfigCoordinatorResponse configCoordinator(ConfigCoordinatorRequest request) {
        return configCoordinator(System.identityHashCode(request), request);
    }

    default ConfigCoordinatorResponse configCoordinator(long requestId,
            ConfigCoordinatorRequest request) {
        return getCaller().call(configCoordinator, requestId, request, configCoordinatorHandlers);
    }

    @Deprecated
    default CreateRegionIdResponse createRegionId(CreateRegionIdRequest request) {
        return createRegionId(System.identityHashCode(request), request);
    }

    default CreateRegionIdResponse createRegionId(long requestId, CreateRegionIdRequest request) {
        return getCaller().call(createRegionId, requestId, request, createRegionIdHandlers);
    }

    @Deprecated
    default QueryRegionResponse queryRegion(QueryRegionRequest request) {
        return queryRegion(System.identityHashCode(request), request);
    }

    default QueryRegionResponse queryRegion(long requestId, QueryRegionRequest request) {
        return getCaller().call(queryRegion, requestId, request, queryRegionHandlers);
    }

    @Deprecated
    default CreateRegionResponse createRegion(CreateRegionRequest request) {
        return createRegion(System.identityHashCode(request), request);
    }

    default CreateRegionResponse createRegion(long requestId, CreateRegionRequest request) {
        return getCaller().call(createRegion, requestId, request, createRegionHandlers);
    }

    @Deprecated
    default DropRegionResponse dropRegion(DropRegionRequest request) {
        return dropRegion(System.identityHashCode(request), request);
    }

    default DropRegionResponse dropRegion(long requestId, DropRegionRequest request) {
        return getCaller().call(dropRegion, requestId, request, dropRegionHandlers);
    }

    @Deprecated
    default DropRegionPermanentlyResponse dropRegionPermanently(
            DropRegionPermanentlyRequest request) {
        return dropRegionPermanently(System.identityHashCode(request), request);
    }

    default DropRegionPermanentlyResponse dropRegionPermanently(long requestId,
            DropRegionPermanentlyRequest request) {
        return getCaller().call(dropRegionPermanently, requestId, request, dropRegionPermanentlyHandlers);
    }

    @Deprecated
    default SplitRegionResponse splitRegion(SplitRegionRequest request) {
        return splitRegion(System.identityHashCode(request), request);
    }

    default SplitRegionResponse splitRegion(long requestId, SplitRegionRequest request) {
        return getCaller().call(splitRegion, requestId, request, splitRegionHandlers);
    }

    @Deprecated
    default MergeRegionResponse mergeRegion(MergeRegionRequest request) {
        return mergeRegion(System.identityHashCode(request), request);
    }

    default MergeRegionResponse mergeRegion(long requestId, MergeRegionRequest request) {
        return getCaller().call(mergeRegion, requestId, request, mergeRegionHandlers);
    }

    @Deprecated
    default ChangePeerRegionResponse changePeerRegion(ChangePeerRegionRequest request) {
        return changePeerRegion(System.identityHashCode(request), request);
    }

    default ChangePeerRegionResponse changePeerRegion(long requestId,
            ChangePeerRegionRequest request) {
        return getCaller().call(changePeerRegion, requestId, request, changePeerRegionHandlers);
    }

    @Deprecated
    default TransferLeaderRegionResponse transferLeaderRegion(TransferLeaderRegionRequest request) {
        return transferLeaderRegion(System.identityHashCode(request), request);
    }

    default TransferLeaderRegionResponse transferLeaderRegion(long requestId,
            TransferLeaderRegionRequest request) {
        return getCaller().call(transferLeaderRegion, requestId, request, transferLeaderRegionHandlers);
    }

    @Deprecated
    default GetOrphanRegionResponse getOrphanRegion(GetOrphanRegionRequest request) {
        return getOrphanRegion(System.identityHashCode(request), request);
    }

    default GetOrphanRegionResponse getOrphanRegion(long requestId,
            GetOrphanRegionRequest request) {
        return getCaller().call(getOrphanRegion, requestId, request, getOrphanRegionHandlers);
    }

    @Deprecated
    default ScanRegionsResponse scanRegions(ScanRegionsRequest request) {
        return scanRegions(System.identityHashCode(request), request);
    }

    default ScanRegionsResponse scanRegions(long requestId, ScanRegionsRequest request) {
        return getCaller().call(scanRegions, requestId, request, scanRegionsHandlers);
    }

    @Deprecated
    default GetRangeRegionMapResponse getRangeRegionMap(GetRangeRegionMapRequest request) {
        return getRangeRegionMap(System.identityHashCode(request), request);
    }

    default GetRangeRegionMapResponse getRangeRegionMap(long requestId,
            GetRangeRegionMapRequest request) {
        return getCaller().call(getRangeRegionMap, requestId, request, getRangeRegionMapHandlers);
    }

    @Deprecated
    default GetStoreOperationResponse getStoreOperation(GetStoreOperationRequest request) {
        return getStoreOperation(System.identityHashCode(request), request);
    }

    default GetStoreOperationResponse getStoreOperation(long requestId,
            GetStoreOperationRequest request) {
        return getCaller().call(getStoreOperation, requestId, request, getStoreOperationHandlers);
    }

    @Deprecated
    default CleanStoreOperationResponse cleanStoreOperation(CleanStoreOperationRequest request) {
        return cleanStoreOperation(System.identityHashCode(request), request);
    }

    default CleanStoreOperationResponse cleanStoreOperation(long requestId,
            CleanStoreOperationRequest request) {
        return getCaller().call(cleanStoreOperation, requestId, request, cleanStoreOperationHandlers);
    }

    @Deprecated
    default AddStoreOperationResponse addStoreOperation(AddStoreOperationRequest request) {
        return addStoreOperation(System.identityHashCode(request), request);
    }

    default AddStoreOperationResponse addStoreOperation(long requestId,
            AddStoreOperationRequest request) {
        return getCaller().call(addStoreOperation, requestId, request, addStoreOperationHandlers);
    }

    @Deprecated
    default RemoveStoreOperationResponse removeStoreOperation(RemoveStoreOperationRequest request) {
        return removeStoreOperation(System.identityHashCode(request), request);
    }

    default RemoveStoreOperationResponse removeStoreOperation(long requestId,
            RemoveStoreOperationRequest request) {
        return getCaller().call(removeStoreOperation, requestId, request, removeStoreOperationHandlers);
    }

    @Deprecated
    default GetRegionCmdResponse getRegionCmd(GetRegionCmdRequest request) {
        return getRegionCmd(System.identityHashCode(request), request);
    }

    default GetRegionCmdResponse getRegionCmd(long requestId, GetRegionCmdRequest request) {
        return getCaller().call(getRegionCmd, requestId, request, getRegionCmdHandlers);
    }

    @Deprecated
    default GetJobListResponse getJobList(GetJobListRequest request) {
        return getJobList(System.identityHashCode(request), request);
    }

    default GetJobListResponse getJobList(long requestId, GetJobListRequest request) {
        return getCaller().call(getJobList, requestId, request, getJobListHandlers);
    }

    @Deprecated
    default CleanJobListResponse cleanJobList(CleanJobListRequest request) {
        return cleanJobList(System.identityHashCode(request), request);
    }

    default CleanJobListResponse cleanJobList(long requestId, CleanJobListRequest request) {
        return getCaller().call(cleanJobList, requestId, request, cleanJobListHandlers);
    }

    @Deprecated
    default UpdateRegionCmdStatusResponse updateRegionCmdStatus(
            UpdateRegionCmdStatusRequest request) {
        return updateRegionCmdStatus(System.identityHashCode(request), request);
    }

    default UpdateRegionCmdStatusResponse updateRegionCmdStatus(long requestId,
            UpdateRegionCmdStatusRequest request) {
        return getCaller().call(updateRegionCmdStatus, requestId, request, updateRegionCmdStatusHandlers);
    }

    @Deprecated
    default RaftControlResponse raftControl(RaftControlRequest request) {
        return raftControl(System.identityHashCode(request), request);
    }

    default RaftControlResponse raftControl(long requestId, RaftControlRequest request) {
        return getCaller().call(raftControl, requestId, request, raftControlHandlers);
    }

    @Deprecated
    default UpdateGCSafePointResponse updateGCSafePoint(UpdateGCSafePointRequest request) {
        return updateGCSafePoint(System.identityHashCode(request), request);
    }

    default UpdateGCSafePointResponse updateGCSafePoint(long requestId,
            UpdateGCSafePointRequest request) {
        return getCaller().call(updateGCSafePoint, requestId, request, updateGCSafePointHandlers);
    }

    @Deprecated
    default GetGCSafePointResponse getGCSafePoint(GetGCSafePointRequest request) {
        return getGCSafePoint(System.identityHashCode(request), request);
    }

    default GetGCSafePointResponse getGCSafePoint(long requestId, GetGCSafePointRequest request) {
        return getCaller().call(getGCSafePoint, requestId, request, getGCSafePointHandlers);
    }

    @Deprecated
    default BalanceLeaderResponse balanceLeader(BalanceLeaderRequest request) {
        return balanceLeader(System.identityHashCode(request), request);
    }

    default BalanceLeaderResponse balanceLeader(long requestId, BalanceLeaderRequest request) {
        return getCaller().call(balanceLeader, requestId, request, balanceLeaderHandlers);
    }

    @Deprecated
    default BalanceRegionResponse balanceRegion(BalanceRegionRequest request) {
        return balanceRegion(System.identityHashCode(request), request);
    }

    default BalanceRegionResponse balanceRegion(long requestId, BalanceRegionRequest request) {
        return getCaller().call(balanceRegion, requestId, request, balanceRegionHandlers);
    }

    @Deprecated
    default CreateIdsResponse createIds(CreateIdsRequest request) {
        return createIds(System.identityHashCode(request), request);
    }

    default CreateIdsResponse createIds(long requestId, CreateIdsRequest request) {
        return getCaller().call(createIds, requestId, request, createIdsHandlers);
    }

    @Deprecated
    default MDSHeartbeatResponse mDSHeartbeat(MDSHeartbeatRequest request) {
        return mDSHeartbeat(System.identityHashCode(request), request);
    }

    default MDSHeartbeatResponse mDSHeartbeat(long requestId, MDSHeartbeatRequest request) {
        return getCaller().call(mDSHeartbeat, requestId, request, mDSHeartbeatHandlers);
    }

    @Deprecated
    default GetMDSListResponse getMDSList(GetMDSListRequest request) {
        return getMDSList(System.identityHashCode(request), request);
    }

    default GetMDSListResponse getMDSList(long requestId, GetMDSListRequest request) {
        return getCaller().call(getMDSList, requestId, request, getMDSListHandlers);
    }

    @Deprecated
    default RegisterBackupResponse registerBackup(RegisterBackupRequest request) {
        return registerBackup(System.identityHashCode(request), request);
    }

    default RegisterBackupResponse registerBackup(long requestId, RegisterBackupRequest request) {
        return getCaller().call(registerBackup, requestId, request, registerBackupHandlers);
    }

    @Deprecated
    default UnRegisterBackupResponse unRegisterBackup(UnRegisterBackupRequest request) {
        return unRegisterBackup(System.identityHashCode(request), request);
    }

    default UnRegisterBackupResponse unRegisterBackup(long requestId,
            UnRegisterBackupRequest request) {
        return getCaller().call(unRegisterBackup, requestId, request, unRegisterBackupHandlers);
    }

    @Deprecated
    default ControlConfigResponse controlConfig(ControlConfigRequest request) {
        return controlConfig(System.identityHashCode(request), request);
    }

    default ControlConfigResponse controlConfig(long requestId, ControlConfigRequest request) {
        return getCaller().call(controlConfig, requestId, request, controlConfigHandlers);
    }

    @Deprecated
    default RegisterBackupStatusResponse registerBackupStatus(RegisterBackupStatusRequest request) {
        return registerBackupStatus(System.identityHashCode(request), request);
    }

    default RegisterBackupStatusResponse registerBackupStatus(long requestId,
            RegisterBackupStatusRequest request) {
        return getCaller().call(registerBackupStatus, requestId, request, registerBackupStatusHandlers);
    }

    @Deprecated
    default RegisterRestoreResponse registerRestore(RegisterRestoreRequest request) {
        return registerRestore(System.identityHashCode(request), request);
    }

    default RegisterRestoreResponse registerRestore(long requestId,
            RegisterRestoreRequest request) {
        return getCaller().call(registerRestore, requestId, request, registerRestoreHandlers);
    }

    @Deprecated
    default UnRegisterRestoreResponse unRegisterRestore(UnRegisterRestoreRequest request) {
        return unRegisterRestore(System.identityHashCode(request), request);
    }

    default UnRegisterRestoreResponse unRegisterRestore(long requestId,
            UnRegisterRestoreRequest request) {
        return getCaller().call(unRegisterRestore, requestId, request, unRegisterRestoreHandlers);
    }

    @Deprecated
    default RegisterRestoreStatusResponse registerRestoreStatus(
            RegisterRestoreStatusRequest request) {
        return registerRestoreStatus(System.identityHashCode(request), request);
    }

    default RegisterRestoreStatusResponse registerRestoreStatus(long requestId,
            RegisterRestoreStatusRequest request) {
        return getCaller().call(registerRestoreStatus, requestId, request, registerRestoreStatusHandlers);
    }

    Caller<CoordinatorService> getCaller();

    @Getter
    @AllArgsConstructor
    class Impl implements CoordinatorService {
        public final Caller<CoordinatorService> caller;
    }
}
