/*
 * Copyright 2021 DataCanvas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.dingodb.sdk.common.vector;

import io.dingodb.sdk.common.index.VectorIndexParameter;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;

import java.util.List;

@Getter
@NoArgsConstructor
@EqualsAndHashCode
@AllArgsConstructor
public class VectorCalcDistance {

    private Long vectorId;
    private AlgorithmType algorithmType;
    private VectorIndexParameter.MetricType metricType;
    private List<Vector> leftVectors;
    private List<Vector> rightVectors;
    private Boolean isReturnNormalize;

    public enum AlgorithmType {
        ALGORITHM_NONE,
        ALGORITHM_FAISS,
        ALGORITHM_HNSWLIB
    }
}
