/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DigdagMetrics {
    public static final Logger logger = LoggerFactory.getLogger(DigdagMetrics.class);

    public MeterRegistry getRegistry();

    public MeterRegistry getRegistry(Category var1);

    public String mkMetricsName(Category var1, String var2);

    public void increment(Category var1, String var2, Tags var3);

    public void gauge(Category var1, String var2, Tags var3, double var4);

    public void summary(Category var1, String var2, Tags var3, double var4);

    default public void increment(String metricName) {
        this.increment(Category.DEFAULT, metricName);
    }

    default public void increment(String metricName, Tags tags) {
        this.increment(Category.DEFAULT, metricName, tags);
    }

    default public void increment(Category category, String metricName) {
        this.increment(category, metricName, Tags.empty());
    }

    default public void gauge(String metricName, double value) {
        this.gauge(Category.DEFAULT, metricName, Tags.empty(), value);
    }

    default public void gauge(String metricName, Tags tags, double value) {
        this.gauge(Category.DEFAULT, metricName, tags, value);
    }

    default public void summary(String metricName, double value) {
        this.summary(Category.DEFAULT, metricName, value);
    }

    default public void summary(Category category, String metricName, double value) {
        this.summary(category, metricName, Tags.empty(), value);
    }

    default public Timer.Sample timerStart(Category category) {
        return Timer.start((MeterRegistry)this.getRegistry(category));
    }

    default public void timerStop(Category category, String metricsName, Tags tags, Timer.Sample sample) {
        Timer.Builder builder = Timer.builder((String)metricsName).tags((Iterable)tags).publishPercentileHistogram(Boolean.valueOf(true));
        sample.stop(builder.register(this.getRegistry(category)));
    }

    public static enum Category {
        DEFAULT("default"),
        AGENT("agent"),
        API("api"),
        DB("db"),
        EXECUTOR("executor");

        private final String text;

        private Category(String text) {
            this.text = text;
        }

        public String getString() {
            return this.text;
        }

        public static Category fromString(String text) {
            for (Category c : Category.values()) {
                if (c.text.compareToIgnoreCase(text) != 0) continue;
                return c;
            }
            logger.error("Invalid category name {}. Fallback to DEFAULT", (Object)text);
            return DEFAULT;
        }
    }
}

