/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi.ac;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.digdag.spi.ac.SiteTarget;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableSiteTarget
implements SiteTarget {
    private final int siteId;

    private ImmutableSiteTarget(int siteId) {
        this.siteId = siteId;
    }

    @Override
    public int getSiteId() {
        return this.siteId;
    }

    public final ImmutableSiteTarget withSiteId(int value) {
        if (this.siteId == value) {
            return this;
        }
        return new ImmutableSiteTarget(value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSiteTarget && this.equalTo((ImmutableSiteTarget)another);
    }

    private boolean equalTo(ImmutableSiteTarget another) {
        return this.siteId == another.siteId;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.siteId;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SiteTarget").omitNullValues().add("siteId", this.siteId).toString();
    }

    public static ImmutableSiteTarget copyOf(SiteTarget instance) {
        if (instance instanceof ImmutableSiteTarget) {
            return (ImmutableSiteTarget)instance;
        }
        return ImmutableSiteTarget.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SITE_ID = 1L;
        private long initBits = 1L;
        private int siteId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SiteTarget instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.siteId(instance.getSiteId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder siteId(int siteId) {
            this.siteId = siteId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableSiteTarget build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSiteTarget(this.siteId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("siteId");
            }
            return "Cannot build SiteTarget, some of required attributes are not set " + attributes;
        }
    }
}

