/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Optional;
import io.digdag.client.config.Config;
import io.digdag.spi.ImmutableTaskRequest;
import java.time.Instant;
import java.time.ZoneId;
import java.util.UUID;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableTaskRequest.class)
@JsonDeserialize(as=ImmutableTaskRequest.class)
@Value.Immutable
public interface TaskRequest {
    public int getSiteId();

    public int getProjectId();

    public Optional<String> getProjectName();

    public String getWorkflowName();

    public Optional<Long> getWorkflowDefinitionId();

    public Optional<String> getRevision();

    public long getTaskId();

    public long getAttemptId();

    public long getSessionId();

    public Optional<String> getRetryAttemptName();

    public String getTaskName();

    public String getLockId();

    public ZoneId getTimeZone();

    public UUID getSessionUuid();

    public Instant getSessionTime();

    public Instant getCreatedAt();

    public boolean isCancelRequested();

    public Config getLocalConfig();

    public Config getConfig();

    public Config getLastStateParams();

    @Value.Default
    default public int getRetryCount() {
        return 0;
    }

    @Value.Default
    default public Optional<Instant> getStartedAt() {
        return Optional.absent();
    }

    public static ImmutableTaskRequest.Builder builder() {
        return ImmutableTaskRequest.builder();
    }

    public static TaskRequest withLockId(TaskRequest source, String lockId) {
        return ImmutableTaskRequest.builder().from(source).lockId(lockId).build();
    }
}

