/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigElement;
import io.digdag.client.config.ConfigFactory;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class TaskExecutionException
extends RuntimeException {
    private final Optional<ConfigElement> error;
    private final Optional<Integer> retryInterval;
    private final Optional<ConfigElement> stateParams;

    public static ConfigElement buildExceptionErrorConfig(Throwable ex) {
        return TaskExecutionException.buildExceptionErrorConfig(TaskExecutionException.formatExceptionMessage(ex), ex);
    }

    public static ConfigElement buildExceptionErrorConfig(String message, Throwable ex) {
        ImmutableMap map = ImmutableMap.of((Object)"message", (Object)message, (Object)"stacktrace", (Object)Arrays.asList(ex.getStackTrace()).stream().map(it -> it.toString()).collect(Collectors.joining(", ")));
        return ConfigElement.ofMap((Map)map);
    }

    private static String formatExceptionMessage(Throwable ex) {
        return (String)TaskExecutionException.firstNonEmptyMessage(ex).transform(message -> String.format(Locale.ENGLISH, "%s (%s)", message, ex.getClass().getSimpleName().replaceFirst("(?:Exception|Error)$", "").replaceAll("([A-Z]+)([A-Z][a-z])", "$1 $2").replaceAll("([a-z])([A-Z])", "$1 $2").toLowerCase())).or(() -> ex.toString());
    }

    private static Optional<String> firstNonEmptyMessage(Throwable ex) {
        String message = ex.getMessage();
        if (!Strings.isNullOrEmpty((String)message)) {
            return Optional.of((Object)message);
        }
        Throwable cause = ex.getCause();
        if (cause == null) {
            return Optional.absent();
        }
        return TaskExecutionException.firstNonEmptyMessage(cause);
    }

    public static TaskExecutionException ofNextPolling(int interval, ConfigElement nextStateParams) {
        return new TaskExecutionException(interval, nextStateParams);
    }

    public static TaskExecutionException ofNextPollingWithCause(Throwable cause, int interval, ConfigElement nextStateParams) {
        return new TaskExecutionException(cause, TaskExecutionException.buildExceptionErrorConfig(cause), interval, nextStateParams);
    }

    private TaskExecutionException(int retryInterval, ConfigElement stateParams) {
        super("Retrying this task after " + retryInterval + " seconds");
        this.error = Optional.absent();
        this.retryInterval = Optional.of((Object)retryInterval);
        this.stateParams = Optional.of((Object)stateParams);
    }

    private TaskExecutionException(Throwable cause, ConfigElement error, int retryInterval, ConfigElement stateParams) {
        super(cause);
        this.error = Optional.of((Object)error);
        this.retryInterval = Optional.of((Object)retryInterval);
        this.stateParams = Optional.of((Object)stateParams);
    }

    public TaskExecutionException(Throwable cause) {
        this(TaskExecutionException.formatExceptionMessage(cause), cause);
    }

    public TaskExecutionException(String customMessage, Throwable cause) {
        super(customMessage, cause);
        this.error = Optional.of((Object)TaskExecutionException.buildExceptionErrorConfig(customMessage, cause));
        this.retryInterval = Optional.absent();
        this.stateParams = Optional.absent();
    }

    public TaskExecutionException(String message) {
        this(message, (Map<String, String>)ImmutableMap.of());
    }

    public TaskExecutionException(String message, Map<String, String> errorProperties) {
        super(message);
        this.error = Optional.of((Object)TaskExecutionException.buildPropertiesErrorConfig(message, errorProperties));
        this.retryInterval = Optional.absent();
        this.stateParams = Optional.absent();
    }

    private static ConfigElement buildPropertiesErrorConfig(String message, Map<String, String> errorProperties) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(errorProperties);
        builder.put((Object)"message", (Object)message);
        return ConfigElement.ofMap((Map)builder.build());
    }

    @Deprecated
    public TaskExecutionException(String message, ConfigElement error) {
        super(message);
        this.error = Optional.of((Object)error);
        this.retryInterval = Optional.absent();
        this.stateParams = Optional.absent();
    }

    @Deprecated
    public TaskExecutionException(Throwable cause, ConfigElement error) {
        super(TaskExecutionException.formatExceptionMessage(cause), cause);
        this.error = Optional.of((Object)error);
        this.retryInterval = Optional.absent();
        this.stateParams = Optional.absent();
    }

    public Optional<Config> getError(ConfigFactory cf) {
        return this.error.transform(it -> it.toConfig(cf));
    }

    public boolean isError() {
        return this.error.isPresent();
    }

    public Optional<Integer> getRetryInterval() {
        return this.retryInterval;
    }

    public Optional<Config> getStateParams(ConfigFactory cf) {
        return this.stateParams.transform(it -> it.toConfig(cf));
    }
}

