/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.digdag.client.api.SecretValidation;
import io.digdag.spi.SecretNotFoundException;

public interface SecretProvider {
    default public String getSecret(String key) {
        return (String)this.getSecretOptional(key).or(() -> {
            throw new SecretNotFoundException(key);
        });
    }

    public Optional<String> getSecretOptional(String var1);

    default public SecretProvider getSecrets(String path) {
        return new ScopedSecretProvider(this, path);
    }

    public static class ScopedSecretProvider
    implements SecretProvider {
        private final SecretProvider delegate;
        private final String path;

        ScopedSecretProvider(SecretProvider delegate, String path) {
            this.delegate = (SecretProvider)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
            this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path");
            Preconditions.checkArgument((boolean)SecretValidation.isValidSecretKey((String)path), (String)"invalid path: %s", (Object)path);
        }

        @Override
        public Optional<String> getSecretOptional(String key) {
            Preconditions.checkArgument((boolean)SecretValidation.isValidSecretKey((String)key), (String)"invalid key: %s", (Object)key);
            return this.delegate.getSecretOptional(this.path + '.' + key);
        }
    }
}

