/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.digdag.spi.ImmutableScheduleTime;
import java.time.Instant;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableScheduleTime.class)
@JsonDeserialize(as=ImmutableScheduleTime.class)
@Value.Immutable
public interface ScheduleTime {
    public Instant getRunTime();

    public Instant getTime();

    public static ScheduleTime of(Instant time, Instant runTime) {
        return ImmutableScheduleTime.builder().time(time).runTime(runTime).build();
    }

    public static ScheduleTime runNow(Instant time) {
        return ImmutableScheduleTime.builder().time(time).runTime(Instant.now()).build();
    }

    public static Instant alignedNow() {
        return Instant.ofEpochSecond(Instant.now().getEpochSecond());
    }
}

