/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigKey;
import io.digdag.spi.TaskReport;
import io.digdag.spi.TaskResult;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableTaskResult
implements TaskResult {
    private final Config subtaskConfig;
    private final Config exportParams;
    private final ImmutableList<ConfigKey> resetStoreParams;
    private final Config storeParams;
    private final TaskReport report;

    private ImmutableTaskResult(Config subtaskConfig, Config exportParams, ImmutableList<ConfigKey> resetStoreParams, Config storeParams, TaskReport report) {
        this.subtaskConfig = subtaskConfig;
        this.exportParams = exportParams;
        this.resetStoreParams = resetStoreParams;
        this.storeParams = storeParams;
        this.report = report;
    }

    @Override
    @JsonProperty(value="subtaskConfig")
    public Config getSubtaskConfig() {
        return this.subtaskConfig;
    }

    @Override
    @JsonProperty(value="exportParams")
    public Config getExportParams() {
        return this.exportParams;
    }

    @JsonProperty(value="resetStoreParams")
    public ImmutableList<ConfigKey> getResetStoreParams() {
        return this.resetStoreParams;
    }

    @Override
    @JsonProperty(value="storeParams")
    public Config getStoreParams() {
        return this.storeParams;
    }

    @Override
    @JsonProperty(value="report")
    public TaskReport getReport() {
        return this.report;
    }

    public final ImmutableTaskResult withSubtaskConfig(Config value) {
        if (this.subtaskConfig == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"subtaskConfig");
        return new ImmutableTaskResult(newValue, this.exportParams, this.resetStoreParams, this.storeParams, this.report);
    }

    public final ImmutableTaskResult withExportParams(Config value) {
        if (this.exportParams == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"exportParams");
        return new ImmutableTaskResult(this.subtaskConfig, newValue, this.resetStoreParams, this.storeParams, this.report);
    }

    public final ImmutableTaskResult withResetStoreParams(ConfigKey ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTaskResult(this.subtaskConfig, this.exportParams, (ImmutableList<ConfigKey>)newValue, this.storeParams, this.report);
    }

    public final ImmutableTaskResult withResetStoreParams(Iterable<? extends ConfigKey> elements) {
        if (this.resetStoreParams == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTaskResult(this.subtaskConfig, this.exportParams, (ImmutableList<ConfigKey>)newValue, this.storeParams, this.report);
    }

    public final ImmutableTaskResult withStoreParams(Config value) {
        if (this.storeParams == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"storeParams");
        return new ImmutableTaskResult(this.subtaskConfig, this.exportParams, this.resetStoreParams, newValue, this.report);
    }

    public final ImmutableTaskResult withReport(TaskReport value) {
        if (this.report == value) {
            return this;
        }
        TaskReport newValue = (TaskReport)Preconditions.checkNotNull((Object)value, (Object)"report");
        return new ImmutableTaskResult(this.subtaskConfig, this.exportParams, this.resetStoreParams, this.storeParams, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTaskResult && this.equalTo((ImmutableTaskResult)another);
    }

    private boolean equalTo(ImmutableTaskResult another) {
        return this.subtaskConfig.equals((Object)another.subtaskConfig) && this.exportParams.equals((Object)another.exportParams) && this.resetStoreParams.equals(another.resetStoreParams) && this.storeParams.equals((Object)another.storeParams) && this.report.equals(another.report);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.subtaskConfig.hashCode();
        h = h * 17 + this.exportParams.hashCode();
        h = h * 17 + this.resetStoreParams.hashCode();
        h = h * 17 + this.storeParams.hashCode();
        h = h * 17 + this.report.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TaskResult").omitNullValues().add("subtaskConfig", (Object)this.subtaskConfig).add("exportParams", (Object)this.exportParams).add("resetStoreParams", this.resetStoreParams).add("storeParams", (Object)this.storeParams).add("report", (Object)this.report).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTaskResult fromJson(Json json) {
        Builder builder = ImmutableTaskResult.builder();
        if (json.subtaskConfig != null) {
            builder.subtaskConfig(json.subtaskConfig);
        }
        if (json.exportParams != null) {
            builder.exportParams(json.exportParams);
        }
        if (json.resetStoreParams != null) {
            builder.addAllResetStoreParams(json.resetStoreParams);
        }
        if (json.storeParams != null) {
            builder.storeParams(json.storeParams);
        }
        if (json.report != null) {
            builder.report(json.report);
        }
        return builder.build();
    }

    public static ImmutableTaskResult copyOf(TaskResult instance) {
        if (instance instanceof ImmutableTaskResult) {
            return (ImmutableTaskResult)instance;
        }
        return ImmutableTaskResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SUBTASK_CONFIG = 1L;
        private static final long INIT_BIT_EXPORT_PARAMS = 2L;
        private static final long INIT_BIT_STORE_PARAMS = 4L;
        private static final long INIT_BIT_REPORT = 8L;
        private long initBits = 15L;
        @Nullable
        private Config subtaskConfig;
        @Nullable
        private Config exportParams;
        private ImmutableList.Builder<ConfigKey> resetStoreParams = ImmutableList.builder();
        @Nullable
        private Config storeParams;
        @Nullable
        private TaskReport report;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TaskResult instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.subtaskConfig(instance.getSubtaskConfig());
            this.exportParams(instance.getExportParams());
            this.addAllResetStoreParams(instance.getResetStoreParams());
            this.storeParams(instance.getStoreParams());
            this.report(instance.getReport());
            return this;
        }

        @JsonProperty(value="subtaskConfig")
        @CanIgnoreReturnValue
        public final Builder subtaskConfig(Config subtaskConfig) {
            this.subtaskConfig = (Config)Preconditions.checkNotNull((Object)subtaskConfig, (Object)"subtaskConfig");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="exportParams")
        @CanIgnoreReturnValue
        public final Builder exportParams(Config exportParams) {
            this.exportParams = (Config)Preconditions.checkNotNull((Object)exportParams, (Object)"exportParams");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addResetStoreParams(ConfigKey element) {
            this.resetStoreParams.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addResetStoreParams(ConfigKey ... elements) {
            this.resetStoreParams.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="resetStoreParams")
        @CanIgnoreReturnValue
        public final Builder resetStoreParams(Iterable<? extends ConfigKey> elements) {
            this.resetStoreParams = ImmutableList.builder();
            return this.addAllResetStoreParams(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllResetStoreParams(Iterable<? extends ConfigKey> elements) {
            this.resetStoreParams.addAll(elements);
            return this;
        }

        @JsonProperty(value="storeParams")
        @CanIgnoreReturnValue
        public final Builder storeParams(Config storeParams) {
            this.storeParams = (Config)Preconditions.checkNotNull((Object)storeParams, (Object)"storeParams");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="report")
        @CanIgnoreReturnValue
        public final Builder report(TaskReport report) {
            this.report = (TaskReport)Preconditions.checkNotNull((Object)report, (Object)"report");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableTaskResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTaskResult(this.subtaskConfig, this.exportParams, this.resetStoreParams.build(), this.storeParams, this.report);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("subtaskConfig");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("exportParams");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("storeParams");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("report");
            }
            return "Cannot build TaskResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements TaskResult {
        @Nullable
        Config subtaskConfig;
        @Nullable
        Config exportParams;
        List<ConfigKey> resetStoreParams = ImmutableList.of();
        @Nullable
        Config storeParams;
        @Nullable
        TaskReport report;

        Json() {
        }

        @JsonProperty(value="subtaskConfig")
        public void setSubtaskConfig(Config subtaskConfig) {
            this.subtaskConfig = subtaskConfig;
        }

        @JsonProperty(value="exportParams")
        public void setExportParams(Config exportParams) {
            this.exportParams = exportParams;
        }

        @JsonProperty(value="resetStoreParams")
        public void setResetStoreParams(List<ConfigKey> resetStoreParams) {
            this.resetStoreParams = resetStoreParams;
        }

        @JsonProperty(value="storeParams")
        public void setStoreParams(Config storeParams) {
            this.storeParams = storeParams;
        }

        @JsonProperty(value="report")
        public void setReport(TaskReport report) {
            this.report = report;
        }

        @Override
        public Config getSubtaskConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getExportParams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ConfigKey> getResetStoreParams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getStoreParams() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TaskReport getReport() {
            throw new UnsupportedOperationException();
        }
    }
}

