/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.digdag.spi.SecretSelector;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class ImmutableSecretSelector
implements SecretSelector {
    private final String pattern;

    private ImmutableSecretSelector(String pattern) {
        this.pattern = pattern;
    }

    @Override
    @JsonProperty(value="pattern")
    public String pattern() {
        return this.pattern;
    }

    public final ImmutableSecretSelector withPattern(String value) {
        if (this.pattern.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"pattern");
        return ImmutableSecretSelector.validate(new ImmutableSecretSelector(newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSecretSelector && this.equalTo((ImmutableSecretSelector)another);
    }

    private boolean equalTo(ImmutableSecretSelector another) {
        return this.pattern.equals(another.pattern);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.pattern.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SecretSelector").omitNullValues().add("pattern", (Object)this.pattern).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSecretSelector fromJson(Json json) {
        Builder builder = ImmutableSecretSelector.builder();
        if (json.pattern != null) {
            builder.pattern(json.pattern);
        }
        return builder.build();
    }

    private static ImmutableSecretSelector validate(ImmutableSecretSelector instance) {
        instance.check();
        return instance;
    }

    public static ImmutableSecretSelector copyOf(SecretSelector instance) {
        if (instance instanceof ImmutableSecretSelector) {
            return (ImmutableSecretSelector)instance;
        }
        return ImmutableSecretSelector.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder
    implements SecretSelector.Builder {
        private static final long INIT_BIT_PATTERN = 1L;
        private long initBits = 1L;
        @Nullable
        private String pattern;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SecretSelector instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.pattern(instance.pattern());
            return this;
        }

        @Override
        @JsonProperty(value="pattern")
        @CanIgnoreReturnValue
        public final Builder pattern(String pattern) {
            this.pattern = (String)Preconditions.checkNotNull((Object)pattern, (Object)"pattern");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public ImmutableSecretSelector build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableSecretSelector.validate(new ImmutableSecretSelector(this.pattern));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pattern");
            }
            return "Cannot build SecretSelector, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SecretSelector {
        @Nullable
        String pattern;

        Json() {
        }

        @JsonProperty(value="pattern")
        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public String pattern() {
            throw new UnsupportedOperationException();
        }
    }
}

