/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.digdag.spi.SecretAccessContext;
import io.digdag.spi.SecretRequest;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class ImmutableSecretRequest
implements SecretRequest {
    private final SecretAccessContext context;
    private final String key;

    private ImmutableSecretRequest(SecretAccessContext context, String key) {
        this.context = context;
        this.key = key;
    }

    @Override
    public SecretAccessContext context() {
        return this.context;
    }

    @Override
    public String key() {
        return this.key;
    }

    public final ImmutableSecretRequest withContext(SecretAccessContext value) {
        if (this.context == value) {
            return this;
        }
        SecretAccessContext newValue = (SecretAccessContext)Preconditions.checkNotNull((Object)value, (Object)"context");
        return new ImmutableSecretRequest(newValue, this.key);
    }

    public final ImmutableSecretRequest withKey(String value) {
        if (this.key.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"key");
        return new ImmutableSecretRequest(this.context, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSecretRequest && this.equalTo((ImmutableSecretRequest)another);
    }

    private boolean equalTo(ImmutableSecretRequest another) {
        return this.context.equals(another.context) && this.key.equals(another.key);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.context.hashCode();
        h = h * 17 + this.key.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SecretRequest").omitNullValues().add("context", (Object)this.context).add("key", (Object)this.key).toString();
    }

    public static ImmutableSecretRequest copyOf(SecretRequest instance) {
        if (instance instanceof ImmutableSecretRequest) {
            return (ImmutableSecretRequest)instance;
        }
        return ImmutableSecretRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder
    implements SecretRequest.Builder {
        private static final long INIT_BIT_CONTEXT = 1L;
        private static final long INIT_BIT_KEY = 2L;
        private long initBits = 3L;
        @Nullable
        private SecretAccessContext context;
        @Nullable
        private String key;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SecretRequest instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.context(instance.context());
            this.key(instance.key());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder context(SecretAccessContext context) {
            this.context = (SecretAccessContext)Preconditions.checkNotNull((Object)context, (Object)"context");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder key(String key) {
            this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public ImmutableSecretRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSecretRequest(this.context, this.key);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("context");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build SecretRequest, some of required attributes are not set " + attributes;
        }
    }
}

