/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.digdag.spi.ScheduleTime;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableScheduleTime
implements ScheduleTime {
    private final Instant runTime;
    private final Instant time;

    private ImmutableScheduleTime(Instant runTime, Instant time) {
        this.runTime = runTime;
        this.time = time;
    }

    @Override
    @JsonProperty(value="runTime")
    public Instant getRunTime() {
        return this.runTime;
    }

    @Override
    @JsonProperty(value="time")
    public Instant getTime() {
        return this.time;
    }

    public final ImmutableScheduleTime withRunTime(Instant value) {
        if (this.runTime == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"runTime");
        return new ImmutableScheduleTime(newValue, this.time);
    }

    public final ImmutableScheduleTime withTime(Instant value) {
        if (this.time == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"time");
        return new ImmutableScheduleTime(this.runTime, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScheduleTime && this.equalTo((ImmutableScheduleTime)another);
    }

    private boolean equalTo(ImmutableScheduleTime another) {
        return this.runTime.equals(another.runTime) && this.time.equals(another.time);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.runTime.hashCode();
        h = h * 17 + this.time.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ScheduleTime").omitNullValues().add("runTime", (Object)this.runTime).add("time", (Object)this.time).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableScheduleTime fromJson(Json json) {
        Builder builder = ImmutableScheduleTime.builder();
        if (json.runTime != null) {
            builder.runTime(json.runTime);
        }
        if (json.time != null) {
            builder.time(json.time);
        }
        return builder.build();
    }

    public static ImmutableScheduleTime copyOf(ScheduleTime instance) {
        if (instance instanceof ImmutableScheduleTime) {
            return (ImmutableScheduleTime)instance;
        }
        return ImmutableScheduleTime.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_RUN_TIME = 1L;
        private static final long INIT_BIT_TIME = 2L;
        private long initBits = 3L;
        @Nullable
        private Instant runTime;
        @Nullable
        private Instant time;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ScheduleTime instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.runTime(instance.getRunTime());
            this.time(instance.getTime());
            return this;
        }

        @JsonProperty(value="runTime")
        @CanIgnoreReturnValue
        public final Builder runTime(Instant runTime) {
            this.runTime = (Instant)Preconditions.checkNotNull((Object)runTime, (Object)"runTime");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="time")
        @CanIgnoreReturnValue
        public final Builder time(Instant time) {
            this.time = (Instant)Preconditions.checkNotNull((Object)time, (Object)"time");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableScheduleTime build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableScheduleTime(this.runTime, this.time);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("runTime");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("time");
            }
            return "Cannot build ScheduleTime, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ScheduleTime {
        @Nullable
        Instant runTime;
        @Nullable
        Instant time;

        Json() {
        }

        @JsonProperty(value="runTime")
        public void setRunTime(Instant runTime) {
            this.runTime = runTime;
        }

        @JsonProperty(value="time")
        public void setTime(Instant time) {
            this.time = time;
        }

        @Override
        public Instant getRunTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getTime() {
            throw new UnsupportedOperationException();
        }
    }
}

