/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.digdag.spi.AuthenticatedUser;
import io.digdag.spi.Authenticator;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
final class ImmutableResult
implements Authenticator.Result {
    private final Optional<String> errorMessage;
    private final Optional<Supplier<Map<String, String>>> secrets;
    private final Optional<AuthenticatedUser> authenticatedUser;

    private ImmutableResult(Optional<String> errorMessage, Optional<Supplier<Map<String, String>>> secrets, Optional<AuthenticatedUser> authenticatedUser) {
        this.errorMessage = errorMessage;
        this.secrets = secrets;
        this.authenticatedUser = authenticatedUser;
    }

    @Override
    @JsonProperty(value="errorMessage")
    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    @JsonProperty(value="secrets")
    public Optional<Supplier<Map<String, String>>> getSecrets() {
        return this.secrets;
    }

    @Override
    @JsonProperty(value="authenticatedUser")
    public Optional<AuthenticatedUser> getAuthenticatedUser() {
        return this.authenticatedUser;
    }

    public final ImmutableResult withErrorMessage(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.errorMessage.equals((Object)newValue)) {
            return this;
        }
        return ImmutableResult.validate(new ImmutableResult((Optional<String>)newValue, this.secrets, this.authenticatedUser));
    }

    public final ImmutableResult withErrorMessage(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"errorMessage");
        if (this.errorMessage.equals((Object)value)) {
            return this;
        }
        return ImmutableResult.validate(new ImmutableResult((Optional<String>)value, this.secrets, this.authenticatedUser));
    }

    public final ImmutableResult withSecrets(Supplier<Map<String, String>> value) {
        Optional newValue = Optional.of(value);
        if (this.secrets.isPresent() && this.secrets.get() == value) {
            return this;
        }
        return ImmutableResult.validate(new ImmutableResult(this.errorMessage, (Optional<Supplier<Map<String, String>>>)newValue, this.authenticatedUser));
    }

    public final ImmutableResult withSecrets(Optional<Supplier<Map<String, String>>> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"secrets");
        if (!this.secrets.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.secrets.isPresent() && value.isPresent() && this.secrets.get() == value.get()) {
            return this;
        }
        return ImmutableResult.validate(new ImmutableResult(this.errorMessage, (Optional<Supplier<Map<String, String>>>)value, this.authenticatedUser));
    }

    public final ImmutableResult withAuthenticatedUser(AuthenticatedUser value) {
        Optional newValue = Optional.of((Object)value);
        if (this.authenticatedUser.isPresent() && this.authenticatedUser.get() == value) {
            return this;
        }
        return ImmutableResult.validate(new ImmutableResult(this.errorMessage, this.secrets, (Optional<AuthenticatedUser>)newValue));
    }

    public final ImmutableResult withAuthenticatedUser(Optional<AuthenticatedUser> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"authenticatedUser");
        if (!this.authenticatedUser.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.authenticatedUser.isPresent() && value.isPresent() && this.authenticatedUser.get() == value.get()) {
            return this;
        }
        return ImmutableResult.validate(new ImmutableResult(this.errorMessage, this.secrets, (Optional<AuthenticatedUser>)value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResult && this.equalTo((ImmutableResult)another);
    }

    private boolean equalTo(ImmutableResult another) {
        return this.errorMessage.equals(another.errorMessage) && this.secrets.equals(another.secrets) && this.authenticatedUser.equals(another.authenticatedUser);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.errorMessage.hashCode();
        h = h * 17 + this.secrets.hashCode();
        h = h * 17 + this.authenticatedUser.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Result").omitNullValues().add("errorMessage", this.errorMessage.orNull()).add("secrets", this.secrets.orNull()).add("authenticatedUser", this.authenticatedUser.orNull()).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableResult fromJson(Json json) {
        Builder builder = ImmutableResult.builder();
        if (json.errorMessage != null) {
            builder.errorMessage(json.errorMessage);
        }
        if (json.secrets != null) {
            builder.secrets(json.secrets);
        }
        if (json.authenticatedUser != null) {
            builder.authenticatedUser(json.authenticatedUser);
        }
        return builder.build();
    }

    private static ImmutableResult validate(ImmutableResult instance) {
        instance.checkNull();
        return instance;
    }

    public static ImmutableResult copyOf(Authenticator.Result instance) {
        if (instance instanceof ImmutableResult) {
            return (ImmutableResult)instance;
        }
        return ImmutableResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private Optional<String> errorMessage = Optional.absent();
        private Optional<Supplier<Map<String, String>>> secrets = Optional.absent();
        private Optional<AuthenticatedUser> authenticatedUser = Optional.absent();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Authenticator.Result instance) {
            Optional<AuthenticatedUser> authenticatedUserOptional;
            Optional<Supplier<Map<String, String>>> secretsOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            Optional<String> errorMessageOptional = instance.getErrorMessage();
            if (errorMessageOptional.isPresent()) {
                this.errorMessage(errorMessageOptional);
            }
            if ((secretsOptional = instance.getSecrets()).isPresent()) {
                this.secrets(secretsOptional);
            }
            if ((authenticatedUserOptional = instance.getAuthenticatedUser()).isPresent()) {
                this.authenticatedUser(authenticatedUserOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = Optional.of((Object)errorMessage);
            return this;
        }

        @JsonProperty(value="errorMessage")
        @CanIgnoreReturnValue
        public final Builder errorMessage(Optional<String> errorMessage) {
            this.errorMessage = (Optional)Preconditions.checkNotNull(errorMessage, (Object)"errorMessage");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder secrets(Supplier<Map<String, String>> secrets) {
            this.secrets = Optional.of(secrets);
            return this;
        }

        @JsonProperty(value="secrets")
        @CanIgnoreReturnValue
        public final Builder secrets(Optional<Supplier<Map<String, String>>> secrets) {
            this.secrets = (Optional)Preconditions.checkNotNull(secrets, (Object)"secrets");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder authenticatedUser(AuthenticatedUser authenticatedUser) {
            this.authenticatedUser = Optional.of((Object)authenticatedUser);
            return this;
        }

        @JsonProperty(value="authenticatedUser")
        @CanIgnoreReturnValue
        public final Builder authenticatedUser(Optional<AuthenticatedUser> authenticatedUser) {
            this.authenticatedUser = (Optional)Preconditions.checkNotNull(authenticatedUser, (Object)"authenticatedUser");
            return this;
        }

        public ImmutableResult build() {
            return ImmutableResult.validate(new ImmutableResult(this.errorMessage, this.secrets, this.authenticatedUser));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements Authenticator.Result {
        Optional<String> errorMessage = Optional.absent();
        Optional<Supplier<Map<String, String>>> secrets = Optional.absent();
        Optional<AuthenticatedUser> authenticatedUser = Optional.absent();

        Json() {
        }

        @JsonProperty(value="errorMessage")
        public void setErrorMessage(Optional<String> errorMessage) {
            this.errorMessage = errorMessage;
        }

        @JsonProperty(value="secrets")
        public void setSecrets(Optional<Supplier<Map<String, String>>> secrets) {
            this.secrets = secrets;
        }

        @JsonProperty(value="authenticatedUser")
        public void setAuthenticatedUser(Optional<AuthenticatedUser> authenticatedUser) {
            this.authenticatedUser = authenticatedUser;
        }

        @Override
        public Optional<String> getErrorMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Supplier<Map<String, String>>> getSecrets() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<AuthenticatedUser> getAuthenticatedUser() {
            throw new UnsupportedOperationException();
        }
    }
}

