/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.digdag.spi.Notification;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableNotification
implements Notification {
    private final Instant timestamp;
    private final String message;
    private final Optional<Integer> siteId;
    private final Optional<Integer> projectId;
    private final Optional<String> projectName;
    private final Optional<String> workflowName;
    private final Optional<String> revision;
    private final Optional<Long> attemptId;
    private final Optional<Long> sessionId;
    private final Optional<String> taskName;
    private final Optional<ZoneId> timeZone;
    private final Optional<UUID> sessionUuid;
    private final Optional<OffsetDateTime> sessionTime;
    private final Optional<Long> workflowDefinitionId;

    private ImmutableNotification(Instant timestamp, String message, Optional<Integer> siteId, Optional<Integer> projectId, Optional<String> projectName, Optional<String> workflowName, Optional<String> revision, Optional<Long> attemptId, Optional<Long> sessionId, Optional<String> taskName, Optional<ZoneId> timeZone, Optional<UUID> sessionUuid, Optional<OffsetDateTime> sessionTime, Optional<Long> workflowDefinitionId) {
        this.timestamp = timestamp;
        this.message = message;
        this.siteId = siteId;
        this.projectId = projectId;
        this.projectName = projectName;
        this.workflowName = workflowName;
        this.revision = revision;
        this.attemptId = attemptId;
        this.sessionId = sessionId;
        this.taskName = taskName;
        this.timeZone = timeZone;
        this.sessionUuid = sessionUuid;
        this.sessionTime = sessionTime;
        this.workflowDefinitionId = workflowDefinitionId;
    }

    @Override
    @JsonProperty(value="timestamp")
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Override
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @Override
    @JsonProperty(value="site_id")
    public Optional<Integer> getSiteId() {
        return this.siteId;
    }

    @Override
    @JsonProperty(value="project_id")
    public Optional<Integer> getProjectId() {
        return this.projectId;
    }

    @Override
    @JsonProperty(value="project_name")
    public Optional<String> getProjectName() {
        return this.projectName;
    }

    @Override
    @JsonProperty(value="workflow_name")
    public Optional<String> getWorkflowName() {
        return this.workflowName;
    }

    @Override
    @JsonProperty(value="revision")
    public Optional<String> getRevision() {
        return this.revision;
    }

    @Override
    @JsonProperty(value="attempt_id")
    public Optional<Long> getAttemptId() {
        return this.attemptId;
    }

    @Override
    @JsonProperty(value="session_id")
    public Optional<Long> getSessionId() {
        return this.sessionId;
    }

    @Override
    @JsonProperty(value="task_name")
    public Optional<String> getTaskName() {
        return this.taskName;
    }

    @Override
    @JsonProperty(value="timezone")
    public Optional<ZoneId> getTimeZone() {
        return this.timeZone;
    }

    @Override
    @JsonProperty(value="session_uuid")
    public Optional<UUID> getSessionUuid() {
        return this.sessionUuid;
    }

    @Override
    @JsonProperty(value="session_time")
    public Optional<OffsetDateTime> getSessionTime() {
        return this.sessionTime;
    }

    @Override
    @JsonProperty(value="workflow_definition_id")
    public Optional<Long> getWorkflowDefinitionId() {
        return this.workflowDefinitionId;
    }

    public final ImmutableNotification withTimestamp(Instant value) {
        if (this.timestamp == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"timestamp");
        return new ImmutableNotification(newValue, this.message, this.siteId, this.projectId, this.projectName, this.workflowName, this.revision, this.attemptId, this.sessionId, this.taskName, this.timeZone, this.sessionUuid, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withMessage(String value) {
        if (this.message.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"message");
        return new ImmutableNotification(this.timestamp, newValue, this.siteId, this.projectId, this.projectName, this.workflowName, this.revision, this.attemptId, this.sessionId, this.taskName, this.timeZone, this.sessionUuid, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withSiteId(int value) {
        Optional newValue = Optional.of((Object)value);
        if (this.siteId.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, (Optional<Integer>)newValue, this.projectId, this.projectName, this.workflowName, this.revision, this.attemptId, this.sessionId, this.taskName, this.timeZone, this.sessionUuid, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withSiteId(Optional<Integer> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"siteId");
        if (this.siteId.equals((Object)value)) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, (Optional<Integer>)value, this.projectId, this.projectName, this.workflowName, this.revision, this.attemptId, this.sessionId, this.taskName, this.timeZone, this.sessionUuid, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withProjectId(int value) {
        Optional newValue = Optional.of((Object)value);
        if (this.projectId.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, (Optional<Integer>)newValue, this.projectName, this.workflowName, this.revision, this.attemptId, this.sessionId, this.taskName, this.timeZone, this.sessionUuid, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withProjectId(Optional<Integer> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"projectId");
        if (this.projectId.equals((Object)value)) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, (Optional<Integer>)value, this.projectName, this.workflowName, this.revision, this.attemptId, this.sessionId, this.taskName, this.timeZone, this.sessionUuid, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withProjectName(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.projectName.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, this.projectId, (Optional<String>)newValue, this.workflowName, this.revision, this.attemptId, this.sessionId, this.taskName, this.timeZone, this.sessionUuid, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withProjectName(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"projectName");
        if (this.projectName.equals((Object)value)) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, this.projectId, (Optional<String>)value, this.workflowName, this.revision, this.attemptId, this.sessionId, this.taskName, this.timeZone, this.sessionUuid, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withWorkflowName(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.workflowName.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, this.projectId, this.projectName, (Optional<String>)newValue, this.revision, this.attemptId, this.sessionId, this.taskName, this.timeZone, this.sessionUuid, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withWorkflowName(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"workflowName");
        if (this.workflowName.equals((Object)value)) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, this.projectId, this.projectName, (Optional<String>)value, this.revision, this.attemptId, this.sessionId, this.taskName, this.timeZone, this.sessionUuid, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withRevision(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.revision.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, this.projectId, this.projectName, this.workflowName, (Optional<String>)newValue, this.attemptId, this.sessionId, this.taskName, this.timeZone, this.sessionUuid, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withRevision(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"revision");
        if (this.revision.equals((Object)value)) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, this.projectId, this.projectName, this.workflowName, (Optional<String>)value, this.attemptId, this.sessionId, this.taskName, this.timeZone, this.sessionUuid, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withAttemptId(long value) {
        Optional newValue = Optional.of((Object)value);
        if (this.attemptId.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, this.projectId, this.projectName, this.workflowName, this.revision, (Optional<Long>)newValue, this.sessionId, this.taskName, this.timeZone, this.sessionUuid, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withAttemptId(Optional<Long> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"attemptId");
        if (this.attemptId.equals((Object)value)) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, this.projectId, this.projectName, this.workflowName, this.revision, (Optional<Long>)value, this.sessionId, this.taskName, this.timeZone, this.sessionUuid, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withSessionId(long value) {
        Optional newValue = Optional.of((Object)value);
        if (this.sessionId.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, this.projectId, this.projectName, this.workflowName, this.revision, this.attemptId, (Optional<Long>)newValue, this.taskName, this.timeZone, this.sessionUuid, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withSessionId(Optional<Long> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"sessionId");
        if (this.sessionId.equals((Object)value)) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, this.projectId, this.projectName, this.workflowName, this.revision, this.attemptId, (Optional<Long>)value, this.taskName, this.timeZone, this.sessionUuid, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withTaskName(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.taskName.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, this.projectId, this.projectName, this.workflowName, this.revision, this.attemptId, this.sessionId, (Optional<String>)newValue, this.timeZone, this.sessionUuid, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withTaskName(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"taskName");
        if (this.taskName.equals((Object)value)) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, this.projectId, this.projectName, this.workflowName, this.revision, this.attemptId, this.sessionId, (Optional<String>)value, this.timeZone, this.sessionUuid, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withTimeZone(ZoneId value) {
        Optional newValue = Optional.of((Object)value);
        if (this.timeZone.isPresent() && this.timeZone.get() == value) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, this.projectId, this.projectName, this.workflowName, this.revision, this.attemptId, this.sessionId, this.taskName, (Optional<ZoneId>)newValue, this.sessionUuid, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withTimeZone(Optional<ZoneId> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"timeZone");
        if (!this.timeZone.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.timeZone.isPresent() && value.isPresent() && this.timeZone.get() == value.get()) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, this.projectId, this.projectName, this.workflowName, this.revision, this.attemptId, this.sessionId, this.taskName, (Optional<ZoneId>)value, this.sessionUuid, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withSessionUuid(UUID value) {
        Optional newValue = Optional.of((Object)value);
        if (this.sessionUuid.isPresent() && this.sessionUuid.get() == value) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, this.projectId, this.projectName, this.workflowName, this.revision, this.attemptId, this.sessionId, this.taskName, this.timeZone, (Optional<UUID>)newValue, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withSessionUuid(Optional<UUID> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"sessionUuid");
        if (!this.sessionUuid.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.sessionUuid.isPresent() && value.isPresent() && this.sessionUuid.get() == value.get()) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, this.projectId, this.projectName, this.workflowName, this.revision, this.attemptId, this.sessionId, this.taskName, this.timeZone, (Optional<UUID>)value, this.sessionTime, this.workflowDefinitionId);
    }

    public final ImmutableNotification withSessionTime(OffsetDateTime value) {
        Optional newValue = Optional.of((Object)value);
        if (this.sessionTime.isPresent() && this.sessionTime.get() == value) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, this.projectId, this.projectName, this.workflowName, this.revision, this.attemptId, this.sessionId, this.taskName, this.timeZone, this.sessionUuid, (Optional<OffsetDateTime>)newValue, this.workflowDefinitionId);
    }

    public final ImmutableNotification withSessionTime(Optional<OffsetDateTime> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"sessionTime");
        if (!this.sessionTime.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.sessionTime.isPresent() && value.isPresent() && this.sessionTime.get() == value.get()) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, this.projectId, this.projectName, this.workflowName, this.revision, this.attemptId, this.sessionId, this.taskName, this.timeZone, this.sessionUuid, (Optional<OffsetDateTime>)value, this.workflowDefinitionId);
    }

    public final ImmutableNotification withWorkflowDefinitionId(long value) {
        Optional newValue = Optional.of((Object)value);
        if (this.workflowDefinitionId.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, this.projectId, this.projectName, this.workflowName, this.revision, this.attemptId, this.sessionId, this.taskName, this.timeZone, this.sessionUuid, this.sessionTime, (Optional<Long>)newValue);
    }

    public final ImmutableNotification withWorkflowDefinitionId(Optional<Long> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"workflowDefinitionId");
        if (this.workflowDefinitionId.equals((Object)value)) {
            return this;
        }
        return new ImmutableNotification(this.timestamp, this.message, this.siteId, this.projectId, this.projectName, this.workflowName, this.revision, this.attemptId, this.sessionId, this.taskName, this.timeZone, this.sessionUuid, this.sessionTime, (Optional<Long>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNotification && this.equalTo((ImmutableNotification)another);
    }

    private boolean equalTo(ImmutableNotification another) {
        return this.timestamp.equals(another.timestamp) && this.message.equals(another.message) && this.siteId.equals(another.siteId) && this.projectId.equals(another.projectId) && this.projectName.equals(another.projectName) && this.workflowName.equals(another.workflowName) && this.revision.equals(another.revision) && this.attemptId.equals(another.attemptId) && this.sessionId.equals(another.sessionId) && this.taskName.equals(another.taskName) && this.timeZone.equals(another.timeZone) && this.sessionUuid.equals(another.sessionUuid) && this.sessionTime.equals(another.sessionTime) && this.workflowDefinitionId.equals(another.workflowDefinitionId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.timestamp.hashCode();
        h = h * 17 + this.message.hashCode();
        h = h * 17 + this.siteId.hashCode();
        h = h * 17 + this.projectId.hashCode();
        h = h * 17 + this.projectName.hashCode();
        h = h * 17 + this.workflowName.hashCode();
        h = h * 17 + this.revision.hashCode();
        h = h * 17 + this.attemptId.hashCode();
        h = h * 17 + this.sessionId.hashCode();
        h = h * 17 + this.taskName.hashCode();
        h = h * 17 + this.timeZone.hashCode();
        h = h * 17 + this.sessionUuid.hashCode();
        h = h * 17 + this.sessionTime.hashCode();
        h = h * 17 + this.workflowDefinitionId.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Notification").omitNullValues().add("timestamp", (Object)this.timestamp).add("message", (Object)this.message).add("siteId", this.siteId.orNull()).add("projectId", this.projectId.orNull()).add("projectName", this.projectName.orNull()).add("workflowName", this.workflowName.orNull()).add("revision", this.revision.orNull()).add("attemptId", this.attemptId.orNull()).add("sessionId", this.sessionId.orNull()).add("taskName", this.taskName.orNull()).add("timeZone", this.timeZone.orNull()).add("sessionUuid", this.sessionUuid.orNull()).add("sessionTime", this.sessionTime.orNull()).add("workflowDefinitionId", this.workflowDefinitionId.orNull()).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNotification fromJson(Json json) {
        Builder builder = ImmutableNotification.builder();
        if (json.timestamp != null) {
            builder.timestamp(json.timestamp);
        }
        if (json.message != null) {
            builder.message(json.message);
        }
        if (json.siteId != null) {
            builder.siteId(json.siteId);
        }
        if (json.projectId != null) {
            builder.projectId(json.projectId);
        }
        if (json.projectName != null) {
            builder.projectName(json.projectName);
        }
        if (json.workflowName != null) {
            builder.workflowName(json.workflowName);
        }
        if (json.revision != null) {
            builder.revision(json.revision);
        }
        if (json.attemptId != null) {
            builder.attemptId(json.attemptId);
        }
        if (json.sessionId != null) {
            builder.sessionId(json.sessionId);
        }
        if (json.taskName != null) {
            builder.taskName(json.taskName);
        }
        if (json.timeZone != null) {
            builder.timeZone(json.timeZone);
        }
        if (json.sessionUuid != null) {
            builder.sessionUuid(json.sessionUuid);
        }
        if (json.sessionTime != null) {
            builder.sessionTime(json.sessionTime);
        }
        if (json.workflowDefinitionId != null) {
            builder.workflowDefinitionId(json.workflowDefinitionId);
        }
        return builder.build();
    }

    public static ImmutableNotification copyOf(Notification instance) {
        if (instance instanceof ImmutableNotification) {
            return (ImmutableNotification)instance;
        }
        return ImmutableNotification.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TIMESTAMP = 1L;
        private static final long INIT_BIT_MESSAGE = 2L;
        private long initBits = 3L;
        @Nullable
        private Instant timestamp;
        @Nullable
        private String message;
        private Optional<Integer> siteId = Optional.absent();
        private Optional<Integer> projectId = Optional.absent();
        private Optional<String> projectName = Optional.absent();
        private Optional<String> workflowName = Optional.absent();
        private Optional<String> revision = Optional.absent();
        private Optional<Long> attemptId = Optional.absent();
        private Optional<Long> sessionId = Optional.absent();
        private Optional<String> taskName = Optional.absent();
        private Optional<ZoneId> timeZone = Optional.absent();
        private Optional<UUID> sessionUuid = Optional.absent();
        private Optional<OffsetDateTime> sessionTime = Optional.absent();
        private Optional<Long> workflowDefinitionId = Optional.absent();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Notification instance) {
            Optional<Long> workflowDefinitionIdOptional;
            Optional<OffsetDateTime> sessionTimeOptional;
            Optional<UUID> sessionUuidOptional;
            Optional<ZoneId> timeZoneOptional;
            Optional<String> taskNameOptional;
            Optional<Long> sessionIdOptional;
            Optional<Long> attemptIdOptional;
            Optional<String> revisionOptional;
            Optional<String> workflowNameOptional;
            Optional<String> projectNameOptional;
            Optional<Integer> projectIdOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.timestamp(instance.getTimestamp());
            this.message(instance.getMessage());
            Optional<Integer> siteIdOptional = instance.getSiteId();
            if (siteIdOptional.isPresent()) {
                this.siteId(siteIdOptional);
            }
            if ((projectIdOptional = instance.getProjectId()).isPresent()) {
                this.projectId(projectIdOptional);
            }
            if ((projectNameOptional = instance.getProjectName()).isPresent()) {
                this.projectName(projectNameOptional);
            }
            if ((workflowNameOptional = instance.getWorkflowName()).isPresent()) {
                this.workflowName(workflowNameOptional);
            }
            if ((revisionOptional = instance.getRevision()).isPresent()) {
                this.revision(revisionOptional);
            }
            if ((attemptIdOptional = instance.getAttemptId()).isPresent()) {
                this.attemptId(attemptIdOptional);
            }
            if ((sessionIdOptional = instance.getSessionId()).isPresent()) {
                this.sessionId(sessionIdOptional);
            }
            if ((taskNameOptional = instance.getTaskName()).isPresent()) {
                this.taskName(taskNameOptional);
            }
            if ((timeZoneOptional = instance.getTimeZone()).isPresent()) {
                this.timeZone(timeZoneOptional);
            }
            if ((sessionUuidOptional = instance.getSessionUuid()).isPresent()) {
                this.sessionUuid(sessionUuidOptional);
            }
            if ((sessionTimeOptional = instance.getSessionTime()).isPresent()) {
                this.sessionTime(sessionTimeOptional);
            }
            if ((workflowDefinitionIdOptional = instance.getWorkflowDefinitionId()).isPresent()) {
                this.workflowDefinitionId(workflowDefinitionIdOptional);
            }
            return this;
        }

        @JsonProperty(value="timestamp")
        @CanIgnoreReturnValue
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = (Instant)Preconditions.checkNotNull((Object)timestamp, (Object)"timestamp");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="message")
        @CanIgnoreReturnValue
        public final Builder message(String message) {
            this.message = (String)Preconditions.checkNotNull((Object)message, (Object)"message");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder siteId(int siteId) {
            this.siteId = Optional.of((Object)siteId);
            return this;
        }

        @JsonProperty(value="site_id")
        @CanIgnoreReturnValue
        public final Builder siteId(Optional<Integer> siteId) {
            this.siteId = (Optional)Preconditions.checkNotNull(siteId, (Object)"siteId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder projectId(int projectId) {
            this.projectId = Optional.of((Object)projectId);
            return this;
        }

        @JsonProperty(value="project_id")
        @CanIgnoreReturnValue
        public final Builder projectId(Optional<Integer> projectId) {
            this.projectId = (Optional)Preconditions.checkNotNull(projectId, (Object)"projectId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder projectName(String projectName) {
            this.projectName = Optional.of((Object)projectName);
            return this;
        }

        @JsonProperty(value="project_name")
        @CanIgnoreReturnValue
        public final Builder projectName(Optional<String> projectName) {
            this.projectName = (Optional)Preconditions.checkNotNull(projectName, (Object)"projectName");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowName(String workflowName) {
            this.workflowName = Optional.of((Object)workflowName);
            return this;
        }

        @JsonProperty(value="workflow_name")
        @CanIgnoreReturnValue
        public final Builder workflowName(Optional<String> workflowName) {
            this.workflowName = (Optional)Preconditions.checkNotNull(workflowName, (Object)"workflowName");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder revision(String revision) {
            this.revision = Optional.of((Object)revision);
            return this;
        }

        @JsonProperty(value="revision")
        @CanIgnoreReturnValue
        public final Builder revision(Optional<String> revision) {
            this.revision = (Optional)Preconditions.checkNotNull(revision, (Object)"revision");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder attemptId(long attemptId) {
            this.attemptId = Optional.of((Object)attemptId);
            return this;
        }

        @JsonProperty(value="attempt_id")
        @CanIgnoreReturnValue
        public final Builder attemptId(Optional<Long> attemptId) {
            this.attemptId = (Optional)Preconditions.checkNotNull(attemptId, (Object)"attemptId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sessionId(long sessionId) {
            this.sessionId = Optional.of((Object)sessionId);
            return this;
        }

        @JsonProperty(value="session_id")
        @CanIgnoreReturnValue
        public final Builder sessionId(Optional<Long> sessionId) {
            this.sessionId = (Optional)Preconditions.checkNotNull(sessionId, (Object)"sessionId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder taskName(String taskName) {
            this.taskName = Optional.of((Object)taskName);
            return this;
        }

        @JsonProperty(value="task_name")
        @CanIgnoreReturnValue
        public final Builder taskName(Optional<String> taskName) {
            this.taskName = (Optional)Preconditions.checkNotNull(taskName, (Object)"taskName");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timeZone(ZoneId timeZone) {
            this.timeZone = Optional.of((Object)timeZone);
            return this;
        }

        @JsonProperty(value="timezone")
        @CanIgnoreReturnValue
        public final Builder timeZone(Optional<ZoneId> timeZone) {
            this.timeZone = (Optional)Preconditions.checkNotNull(timeZone, (Object)"timeZone");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sessionUuid(UUID sessionUuid) {
            this.sessionUuid = Optional.of((Object)sessionUuid);
            return this;
        }

        @JsonProperty(value="session_uuid")
        @CanIgnoreReturnValue
        public final Builder sessionUuid(Optional<UUID> sessionUuid) {
            this.sessionUuid = (Optional)Preconditions.checkNotNull(sessionUuid, (Object)"sessionUuid");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sessionTime(OffsetDateTime sessionTime) {
            this.sessionTime = Optional.of((Object)sessionTime);
            return this;
        }

        @JsonProperty(value="session_time")
        @CanIgnoreReturnValue
        public final Builder sessionTime(Optional<OffsetDateTime> sessionTime) {
            this.sessionTime = (Optional)Preconditions.checkNotNull(sessionTime, (Object)"sessionTime");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workflowDefinitionId(long workflowDefinitionId) {
            this.workflowDefinitionId = Optional.of((Object)workflowDefinitionId);
            return this;
        }

        @JsonProperty(value="workflow_definition_id")
        @CanIgnoreReturnValue
        public final Builder workflowDefinitionId(Optional<Long> workflowDefinitionId) {
            this.workflowDefinitionId = (Optional)Preconditions.checkNotNull(workflowDefinitionId, (Object)"workflowDefinitionId");
            return this;
        }

        public ImmutableNotification build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNotification(this.timestamp, this.message, this.siteId, this.projectId, this.projectName, this.workflowName, this.revision, this.attemptId, this.sessionId, this.taskName, this.timeZone, this.sessionUuid, this.sessionTime, this.workflowDefinitionId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("timestamp");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build Notification, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements Notification {
        @Nullable
        Instant timestamp;
        @Nullable
        String message;
        Optional<Integer> siteId = Optional.absent();
        Optional<Integer> projectId = Optional.absent();
        Optional<String> projectName = Optional.absent();
        Optional<String> workflowName = Optional.absent();
        Optional<String> revision = Optional.absent();
        Optional<Long> attemptId = Optional.absent();
        Optional<Long> sessionId = Optional.absent();
        Optional<String> taskName = Optional.absent();
        Optional<ZoneId> timeZone = Optional.absent();
        Optional<UUID> sessionUuid = Optional.absent();
        Optional<OffsetDateTime> sessionTime = Optional.absent();
        Optional<Long> workflowDefinitionId = Optional.absent();

        Json() {
        }

        @JsonProperty(value="timestamp")
        public void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @JsonProperty(value="message")
        public void setMessage(String message) {
            this.message = message;
        }

        @JsonProperty(value="site_id")
        public void setSiteId(Optional<Integer> siteId) {
            this.siteId = siteId;
        }

        @JsonProperty(value="project_id")
        public void setProjectId(Optional<Integer> projectId) {
            this.projectId = projectId;
        }

        @JsonProperty(value="project_name")
        public void setProjectName(Optional<String> projectName) {
            this.projectName = projectName;
        }

        @JsonProperty(value="workflow_name")
        public void setWorkflowName(Optional<String> workflowName) {
            this.workflowName = workflowName;
        }

        @JsonProperty(value="revision")
        public void setRevision(Optional<String> revision) {
            this.revision = revision;
        }

        @JsonProperty(value="attempt_id")
        public void setAttemptId(Optional<Long> attemptId) {
            this.attemptId = attemptId;
        }

        @JsonProperty(value="session_id")
        public void setSessionId(Optional<Long> sessionId) {
            this.sessionId = sessionId;
        }

        @JsonProperty(value="task_name")
        public void setTaskName(Optional<String> taskName) {
            this.taskName = taskName;
        }

        @JsonProperty(value="timezone")
        public void setTimeZone(Optional<ZoneId> timeZone) {
            this.timeZone = timeZone;
        }

        @JsonProperty(value="session_uuid")
        public void setSessionUuid(Optional<UUID> sessionUuid) {
            this.sessionUuid = sessionUuid;
        }

        @JsonProperty(value="session_time")
        public void setSessionTime(Optional<OffsetDateTime> sessionTime) {
            this.sessionTime = sessionTime;
        }

        @JsonProperty(value="workflow_definition_id")
        public void setWorkflowDefinitionId(Optional<Long> workflowDefinitionId) {
            this.workflowDefinitionId = workflowDefinitionId;
        }

        @Override
        public Instant getTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getSiteId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getProjectId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getProjectName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getWorkflowName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getRevision() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> getAttemptId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> getSessionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTaskName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ZoneId> getTimeZone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UUID> getSessionUuid() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<OffsetDateTime> getSessionTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> getWorkflowDefinitionId() {
            throw new UnsupportedOperationException();
        }
    }
}

