/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.digdag.spi.DirectDownloadHandle;
import io.digdag.spi.LogFileHandle;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableLogFileHandle
implements LogFileHandle {
    private final String fileName;
    private final long fileSize;
    private final String taskName;
    private final Instant firstLogTime;
    private final String agentId;
    private final Optional<DirectDownloadHandle> direct;

    private ImmutableLogFileHandle(String fileName, long fileSize, String taskName, Instant firstLogTime, String agentId, Optional<DirectDownloadHandle> direct) {
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.taskName = taskName;
        this.firstLogTime = firstLogTime;
        this.agentId = agentId;
        this.direct = direct;
    }

    @Override
    @JsonProperty(value="fileName")
    public String getFileName() {
        return this.fileName;
    }

    @Override
    @JsonProperty(value="fileSize")
    public long getFileSize() {
        return this.fileSize;
    }

    @Override
    @JsonProperty(value="taskName")
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    @JsonProperty(value="firstLogTime")
    public Instant getFirstLogTime() {
        return this.firstLogTime;
    }

    @Override
    @JsonProperty(value="agentId")
    public String getAgentId() {
        return this.agentId;
    }

    @Override
    @JsonProperty(value="direct")
    public Optional<DirectDownloadHandle> getDirect() {
        return this.direct;
    }

    public final ImmutableLogFileHandle withFileName(String value) {
        if (this.fileName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"fileName");
        return new ImmutableLogFileHandle(newValue, this.fileSize, this.taskName, this.firstLogTime, this.agentId, this.direct);
    }

    public final ImmutableLogFileHandle withFileSize(long value) {
        if (this.fileSize == value) {
            return this;
        }
        return new ImmutableLogFileHandle(this.fileName, value, this.taskName, this.firstLogTime, this.agentId, this.direct);
    }

    public final ImmutableLogFileHandle withTaskName(String value) {
        if (this.taskName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"taskName");
        return new ImmutableLogFileHandle(this.fileName, this.fileSize, newValue, this.firstLogTime, this.agentId, this.direct);
    }

    public final ImmutableLogFileHandle withFirstLogTime(Instant value) {
        if (this.firstLogTime == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"firstLogTime");
        return new ImmutableLogFileHandle(this.fileName, this.fileSize, this.taskName, newValue, this.agentId, this.direct);
    }

    public final ImmutableLogFileHandle withAgentId(String value) {
        if (this.agentId.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"agentId");
        return new ImmutableLogFileHandle(this.fileName, this.fileSize, this.taskName, this.firstLogTime, newValue, this.direct);
    }

    public final ImmutableLogFileHandle withDirect(DirectDownloadHandle value) {
        Optional newValue = Optional.of((Object)value);
        if (this.direct.isPresent() && this.direct.get() == value) {
            return this;
        }
        return new ImmutableLogFileHandle(this.fileName, this.fileSize, this.taskName, this.firstLogTime, this.agentId, (Optional<DirectDownloadHandle>)newValue);
    }

    public final ImmutableLogFileHandle withDirect(Optional<DirectDownloadHandle> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"direct");
        if (!this.direct.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.direct.isPresent() && value.isPresent() && this.direct.get() == value.get()) {
            return this;
        }
        return new ImmutableLogFileHandle(this.fileName, this.fileSize, this.taskName, this.firstLogTime, this.agentId, (Optional<DirectDownloadHandle>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLogFileHandle && this.equalTo((ImmutableLogFileHandle)another);
    }

    private boolean equalTo(ImmutableLogFileHandle another) {
        return this.fileName.equals(another.fileName) && this.fileSize == another.fileSize && this.taskName.equals(another.taskName) && this.firstLogTime.equals(another.firstLogTime) && this.agentId.equals(another.agentId) && this.direct.equals(another.direct);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.fileName.hashCode();
        h = h * 17 + Longs.hashCode((long)this.fileSize);
        h = h * 17 + this.taskName.hashCode();
        h = h * 17 + this.firstLogTime.hashCode();
        h = h * 17 + this.agentId.hashCode();
        h = h * 17 + this.direct.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LogFileHandle").omitNullValues().add("fileName", (Object)this.fileName).add("fileSize", this.fileSize).add("taskName", (Object)this.taskName).add("firstLogTime", (Object)this.firstLogTime).add("agentId", (Object)this.agentId).add("direct", this.direct.orNull()).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLogFileHandle fromJson(Json json) {
        Builder builder = ImmutableLogFileHandle.builder();
        if (json.fileName != null) {
            builder.fileName(json.fileName);
        }
        if (json.fileSizeIsSet) {
            builder.fileSize(json.fileSize);
        }
        if (json.taskName != null) {
            builder.taskName(json.taskName);
        }
        if (json.firstLogTime != null) {
            builder.firstLogTime(json.firstLogTime);
        }
        if (json.agentId != null) {
            builder.agentId(json.agentId);
        }
        if (json.direct != null) {
            builder.direct(json.direct);
        }
        return builder.build();
    }

    public static ImmutableLogFileHandle copyOf(LogFileHandle instance) {
        if (instance instanceof ImmutableLogFileHandle) {
            return (ImmutableLogFileHandle)instance;
        }
        return ImmutableLogFileHandle.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FILE_NAME = 1L;
        private static final long INIT_BIT_FILE_SIZE = 2L;
        private static final long INIT_BIT_TASK_NAME = 4L;
        private static final long INIT_BIT_FIRST_LOG_TIME = 8L;
        private static final long INIT_BIT_AGENT_ID = 16L;
        private long initBits = 31L;
        @Nullable
        private String fileName;
        private long fileSize;
        @Nullable
        private String taskName;
        @Nullable
        private Instant firstLogTime;
        @Nullable
        private String agentId;
        private Optional<DirectDownloadHandle> direct = Optional.absent();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(LogFileHandle instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.fileName(instance.getFileName());
            this.fileSize(instance.getFileSize());
            this.taskName(instance.getTaskName());
            this.firstLogTime(instance.getFirstLogTime());
            this.agentId(instance.getAgentId());
            Optional<DirectDownloadHandle> directOptional = instance.getDirect();
            if (directOptional.isPresent()) {
                this.direct(directOptional);
            }
            return this;
        }

        @JsonProperty(value="fileName")
        @CanIgnoreReturnValue
        public final Builder fileName(String fileName) {
            this.fileName = (String)Preconditions.checkNotNull((Object)fileName, (Object)"fileName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="fileSize")
        @CanIgnoreReturnValue
        public final Builder fileSize(long fileSize) {
            this.fileSize = fileSize;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="taskName")
        @CanIgnoreReturnValue
        public final Builder taskName(String taskName) {
            this.taskName = (String)Preconditions.checkNotNull((Object)taskName, (Object)"taskName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="firstLogTime")
        @CanIgnoreReturnValue
        public final Builder firstLogTime(Instant firstLogTime) {
            this.firstLogTime = (Instant)Preconditions.checkNotNull((Object)firstLogTime, (Object)"firstLogTime");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="agentId")
        @CanIgnoreReturnValue
        public final Builder agentId(String agentId) {
            this.agentId = (String)Preconditions.checkNotNull((Object)agentId, (Object)"agentId");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder direct(DirectDownloadHandle direct) {
            this.direct = Optional.of((Object)direct);
            return this;
        }

        @JsonProperty(value="direct")
        @CanIgnoreReturnValue
        public final Builder direct(Optional<DirectDownloadHandle> direct) {
            this.direct = (Optional)Preconditions.checkNotNull(direct, (Object)"direct");
            return this;
        }

        public ImmutableLogFileHandle build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLogFileHandle(this.fileName, this.fileSize, this.taskName, this.firstLogTime, this.agentId, this.direct);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("fileName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fileSize");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("taskName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("firstLogTime");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("agentId");
            }
            return "Cannot build LogFileHandle, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements LogFileHandle {
        @Nullable
        String fileName;
        long fileSize;
        boolean fileSizeIsSet;
        @Nullable
        String taskName;
        @Nullable
        Instant firstLogTime;
        @Nullable
        String agentId;
        Optional<DirectDownloadHandle> direct = Optional.absent();

        Json() {
        }

        @JsonProperty(value="fileName")
        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @JsonProperty(value="fileSize")
        public void setFileSize(long fileSize) {
            this.fileSize = fileSize;
            this.fileSizeIsSet = true;
        }

        @JsonProperty(value="taskName")
        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        @JsonProperty(value="firstLogTime")
        public void setFirstLogTime(Instant firstLogTime) {
            this.firstLogTime = firstLogTime;
        }

        @JsonProperty(value="agentId")
        public void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @JsonProperty(value="direct")
        public void setDirect(Optional<DirectDownloadHandle> direct) {
            this.direct = direct;
        }

        @Override
        public String getFileName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getFileSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTaskName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getFirstLogTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAgentId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<DirectDownloadHandle> getDirect() {
            throw new UnsupportedOperationException();
        }
    }
}

