/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.digdag.spi.CommandRequest;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableCommandRequest
implements CommandRequest {
    private final Path workingDirectory;
    private final ImmutableMap<String, String> environments;
    private final ImmutableList<String> commandLine;
    private final Path ioDirectory;

    private ImmutableCommandRequest(Path workingDirectory, ImmutableMap<String, String> environments, ImmutableList<String> commandLine, Path ioDirectory) {
        this.workingDirectory = workingDirectory;
        this.environments = environments;
        this.commandLine = commandLine;
        this.ioDirectory = ioDirectory;
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public ImmutableMap<String, String> getEnvironments() {
        return this.environments;
    }

    public ImmutableList<String> getCommandLine() {
        return this.commandLine;
    }

    @Override
    public Path getIoDirectory() {
        return this.ioDirectory;
    }

    public final ImmutableCommandRequest withWorkingDirectory(Path value) {
        if (this.workingDirectory == value) {
            return this;
        }
        Path newValue = (Path)Preconditions.checkNotNull((Object)value, (Object)"workingDirectory");
        return new ImmutableCommandRequest(newValue, this.environments, this.commandLine, this.ioDirectory);
    }

    public final ImmutableCommandRequest withEnvironments(Map<String, ? extends String> entries) {
        if (this.environments == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCommandRequest(this.workingDirectory, (ImmutableMap<String, String>)newValue, this.commandLine, this.ioDirectory);
    }

    public final ImmutableCommandRequest withCommandLine(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommandRequest(this.workingDirectory, this.environments, (ImmutableList<String>)newValue, this.ioDirectory);
    }

    public final ImmutableCommandRequest withCommandLine(Iterable<String> elements) {
        if (this.commandLine == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommandRequest(this.workingDirectory, this.environments, (ImmutableList<String>)newValue, this.ioDirectory);
    }

    public final ImmutableCommandRequest withIoDirectory(Path value) {
        if (this.ioDirectory == value) {
            return this;
        }
        Path newValue = (Path)Preconditions.checkNotNull((Object)value, (Object)"ioDirectory");
        return new ImmutableCommandRequest(this.workingDirectory, this.environments, this.commandLine, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommandRequest && this.equalTo((ImmutableCommandRequest)another);
    }

    private boolean equalTo(ImmutableCommandRequest another) {
        return this.workingDirectory.equals(another.workingDirectory) && this.environments.equals(another.environments) && this.commandLine.equals(another.commandLine) && this.ioDirectory.equals(another.ioDirectory);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.workingDirectory.hashCode();
        h = h * 17 + this.environments.hashCode();
        h = h * 17 + this.commandLine.hashCode();
        h = h * 17 + this.ioDirectory.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommandRequest").omitNullValues().add("workingDirectory", (Object)this.workingDirectory).add("environments", this.environments).add("commandLine", this.commandLine).add("ioDirectory", (Object)this.ioDirectory).toString();
    }

    public static ImmutableCommandRequest copyOf(CommandRequest instance) {
        if (instance instanceof ImmutableCommandRequest) {
            return (ImmutableCommandRequest)instance;
        }
        return ImmutableCommandRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_WORKING_DIRECTORY = 1L;
        private static final long INIT_BIT_IO_DIRECTORY = 2L;
        private long initBits = 3L;
        @Nullable
        private Path workingDirectory;
        private ImmutableMap.Builder<String, String> environments = ImmutableMap.builder();
        private ImmutableList.Builder<String> commandLine = ImmutableList.builder();
        @Nullable
        private Path ioDirectory;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommandRequest instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.workingDirectory(instance.getWorkingDirectory());
            this.putAllEnvironments(instance.getEnvironments());
            this.addAllCommandLine(instance.getCommandLine());
            this.ioDirectory(instance.getIoDirectory());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder workingDirectory(Path workingDirectory) {
            this.workingDirectory = (Path)Preconditions.checkNotNull((Object)workingDirectory, (Object)"workingDirectory");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putEnvironments(String key, String value) {
            this.environments.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putEnvironments(Map.Entry<String, ? extends String> entry) {
            this.environments.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder environments(Map<String, ? extends String> environments) {
            this.environments = ImmutableMap.builder();
            return this.putAllEnvironments(environments);
        }

        @CanIgnoreReturnValue
        public final Builder putAllEnvironments(Map<String, ? extends String> environments) {
            this.environments.putAll(environments);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCommandLine(String element) {
            this.commandLine.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCommandLine(String ... elements) {
            this.commandLine.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commandLine(Iterable<String> elements) {
            this.commandLine = ImmutableList.builder();
            return this.addAllCommandLine(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCommandLine(Iterable<String> elements) {
            this.commandLine.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ioDirectory(Path ioDirectory) {
            this.ioDirectory = (Path)Preconditions.checkNotNull((Object)ioDirectory, (Object)"ioDirectory");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableCommandRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommandRequest(this.workingDirectory, this.environments.build(), this.commandLine.build(), this.ioDirectory);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("workingDirectory");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ioDirectory");
            }
            return "Cannot build CommandRequest, some of required attributes are not set " + attributes;
        }
    }
}

