/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.digdag.spi.CommandContext;
import io.digdag.spi.TaskRequest;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableCommandContext
implements CommandContext {
    private final Path localProjectPath;
    private final TaskRequest taskRequest;

    private ImmutableCommandContext(Path localProjectPath, TaskRequest taskRequest) {
        this.localProjectPath = localProjectPath;
        this.taskRequest = taskRequest;
    }

    @Override
    public Path getLocalProjectPath() {
        return this.localProjectPath;
    }

    @Override
    public TaskRequest getTaskRequest() {
        return this.taskRequest;
    }

    public final ImmutableCommandContext withLocalProjectPath(Path value) {
        if (this.localProjectPath == value) {
            return this;
        }
        Path newValue = (Path)Preconditions.checkNotNull((Object)value, (Object)"localProjectPath");
        return new ImmutableCommandContext(newValue, this.taskRequest);
    }

    public final ImmutableCommandContext withTaskRequest(TaskRequest value) {
        if (this.taskRequest == value) {
            return this;
        }
        TaskRequest newValue = (TaskRequest)Preconditions.checkNotNull((Object)value, (Object)"taskRequest");
        return new ImmutableCommandContext(this.localProjectPath, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommandContext && this.equalTo((ImmutableCommandContext)another);
    }

    private boolean equalTo(ImmutableCommandContext another) {
        return this.localProjectPath.equals(another.localProjectPath) && this.taskRequest.equals(another.taskRequest);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.localProjectPath.hashCode();
        h = h * 17 + this.taskRequest.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommandContext").omitNullValues().add("localProjectPath", (Object)this.localProjectPath).add("taskRequest", (Object)this.taskRequest).toString();
    }

    public static ImmutableCommandContext copyOf(CommandContext instance) {
        if (instance instanceof ImmutableCommandContext) {
            return (ImmutableCommandContext)instance;
        }
        return ImmutableCommandContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LOCAL_PROJECT_PATH = 1L;
        private static final long INIT_BIT_TASK_REQUEST = 2L;
        private long initBits = 3L;
        @Nullable
        private Path localProjectPath;
        @Nullable
        private TaskRequest taskRequest;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommandContext instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.localProjectPath(instance.getLocalProjectPath());
            this.taskRequest(instance.getTaskRequest());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder localProjectPath(Path localProjectPath) {
            this.localProjectPath = (Path)Preconditions.checkNotNull((Object)localProjectPath, (Object)"localProjectPath");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder taskRequest(TaskRequest taskRequest) {
            this.taskRequest = (TaskRequest)Preconditions.checkNotNull((Object)taskRequest, (Object)"taskRequest");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableCommandContext build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommandContext(this.localProjectPath, this.taskRequest);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("localProjectPath");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("taskRequest");
            }
            return "Cannot build CommandContext, some of required attributes are not set " + attributes;
        }
    }
}

