/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.digdag.client.config.Config;
import io.digdag.spi.AuthenticatedUser;
import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableAuthenticatedUser
implements AuthenticatedUser {
    private final int siteId;
    private final boolean isAdmin;
    private final Config userInfo;
    private final Config userContext;

    private ImmutableAuthenticatedUser(Builder builder) {
        this.siteId = builder.siteId;
        this.userInfo = builder.userInfo;
        this.userContext = builder.userContext;
        this.isAdmin = builder.isAdminIsSet() ? builder.isAdmin : AuthenticatedUser.super.isAdmin();
    }

    private ImmutableAuthenticatedUser(int siteId, boolean isAdmin, Config userInfo, Config userContext) {
        this.siteId = siteId;
        this.isAdmin = isAdmin;
        this.userInfo = userInfo;
        this.userContext = userContext;
    }

    @Override
    public int getSiteId() {
        return this.siteId;
    }

    @Override
    public boolean isAdmin() {
        return this.isAdmin;
    }

    @Override
    public Config getUserInfo() {
        return this.userInfo;
    }

    @Override
    public Config getUserContext() {
        return this.userContext;
    }

    public final ImmutableAuthenticatedUser withSiteId(int value) {
        if (this.siteId == value) {
            return this;
        }
        return new ImmutableAuthenticatedUser(value, this.isAdmin, this.userInfo, this.userContext);
    }

    public final ImmutableAuthenticatedUser withIsAdmin(boolean value) {
        if (this.isAdmin == value) {
            return this;
        }
        return new ImmutableAuthenticatedUser(this.siteId, value, this.userInfo, this.userContext);
    }

    public final ImmutableAuthenticatedUser withUserInfo(Config value) {
        if (this.userInfo == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"userInfo");
        return new ImmutableAuthenticatedUser(this.siteId, this.isAdmin, newValue, this.userContext);
    }

    public final ImmutableAuthenticatedUser withUserContext(Config value) {
        if (this.userContext == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"userContext");
        return new ImmutableAuthenticatedUser(this.siteId, this.isAdmin, this.userInfo, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthenticatedUser && this.equalTo((ImmutableAuthenticatedUser)another);
    }

    private boolean equalTo(ImmutableAuthenticatedUser another) {
        return this.siteId == another.siteId && this.isAdmin == another.isAdmin && this.userInfo.equals((Object)another.userInfo) && this.userContext.equals((Object)another.userContext);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.siteId;
        h = h * 17 + Booleans.hashCode((boolean)this.isAdmin);
        h = h * 17 + this.userInfo.hashCode();
        h = h * 17 + this.userContext.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AuthenticatedUser").omitNullValues().add("siteId", this.siteId).add("isAdmin", this.isAdmin).add("userInfo", (Object)this.userInfo).add("userContext", (Object)this.userContext).toString();
    }

    public static ImmutableAuthenticatedUser copyOf(AuthenticatedUser instance) {
        if (instance instanceof ImmutableAuthenticatedUser) {
            return (ImmutableAuthenticatedUser)instance;
        }
        return ImmutableAuthenticatedUser.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SITE_ID = 1L;
        private static final long INIT_BIT_USER_INFO = 2L;
        private static final long INIT_BIT_USER_CONTEXT = 4L;
        private static final long OPT_BIT_IS_ADMIN = 1L;
        private long initBits = 7L;
        private long optBits;
        private int siteId;
        private boolean isAdmin;
        @Nullable
        private Config userInfo;
        @Nullable
        private Config userContext;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AuthenticatedUser instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.siteId(instance.getSiteId());
            this.isAdmin(instance.isAdmin());
            this.userInfo(instance.getUserInfo());
            this.userContext(instance.getUserContext());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder siteId(int siteId) {
            this.siteId = siteId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isAdmin(boolean isAdmin) {
            this.isAdmin = isAdmin;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder userInfo(Config userInfo) {
            this.userInfo = (Config)Preconditions.checkNotNull((Object)userInfo, (Object)"userInfo");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder userContext(Config userContext) {
            this.userContext = (Config)Preconditions.checkNotNull((Object)userContext, (Object)"userContext");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableAuthenticatedUser build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAuthenticatedUser(this);
        }

        private boolean isAdminIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("siteId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("userInfo");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("userContext");
            }
            return "Cannot build AuthenticatedUser, some of required attributes are not set " + attributes;
        }
    }
}

