/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi.ac;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.digdag.spi.ac.WorkflowTarget;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableWorkflowTarget
implements WorkflowTarget {
    private final int siteId;
    private final String name;
    private final String projectName;

    private ImmutableWorkflowTarget(int siteId, String name, String projectName) {
        this.siteId = siteId;
        this.name = name;
        this.projectName = projectName;
    }

    @Override
    public int getSiteId() {
        return this.siteId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    public final ImmutableWorkflowTarget withSiteId(int value) {
        if (this.siteId == value) {
            return this;
        }
        return new ImmutableWorkflowTarget(value, this.name, this.projectName);
    }

    public final ImmutableWorkflowTarget withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        return new ImmutableWorkflowTarget(this.siteId, newValue, this.projectName);
    }

    public final ImmutableWorkflowTarget withProjectName(String value) {
        if (this.projectName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"projectName");
        return new ImmutableWorkflowTarget(this.siteId, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWorkflowTarget && this.equalTo((ImmutableWorkflowTarget)another);
    }

    private boolean equalTo(ImmutableWorkflowTarget another) {
        return this.siteId == another.siteId && this.name.equals(another.name) && this.projectName.equals(another.projectName);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.siteId;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.projectName.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WorkflowTarget").omitNullValues().add("siteId", this.siteId).add("name", (Object)this.name).add("projectName", (Object)this.projectName).toString();
    }

    public static ImmutableWorkflowTarget copyOf(WorkflowTarget instance) {
        if (instance instanceof ImmutableWorkflowTarget) {
            return (ImmutableWorkflowTarget)instance;
        }
        return ImmutableWorkflowTarget.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SITE_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_PROJECT_NAME = 4L;
        private long initBits = 7L;
        private int siteId;
        @Nullable
        private String name;
        @Nullable
        private String projectName;

        private Builder() {
        }

        public final Builder from(WorkflowTarget instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.siteId(instance.getSiteId());
            this.name(instance.getName());
            this.projectName(instance.getProjectName());
            return this;
        }

        public final Builder siteId(int siteId) {
            this.siteId = siteId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder projectName(String projectName) {
            this.projectName = (String)Preconditions.checkNotNull((Object)projectName, (Object)"projectName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableWorkflowTarget build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWorkflowTarget(this.siteId, this.name, this.projectName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("siteId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("projectName");
            }
            return "Cannot build WorkflowTarget, some of required attributes are not set " + attributes;
        }
    }
}

