/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi.ac;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.digdag.spi.ac.SecretTarget;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableSecretTarget
implements SecretTarget {
    private final int siteId;
    private final String name;
    private final int projectId;
    private final String projectName;

    private ImmutableSecretTarget(int siteId, String name, int projectId, String projectName) {
        this.siteId = siteId;
        this.name = name;
        this.projectId = projectId;
        this.projectName = projectName;
    }

    @Override
    public int getSiteId() {
        return this.siteId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getProjectId() {
        return this.projectId;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    public final ImmutableSecretTarget withSiteId(int value) {
        if (this.siteId == value) {
            return this;
        }
        return new ImmutableSecretTarget(value, this.name, this.projectId, this.projectName);
    }

    public final ImmutableSecretTarget withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        return new ImmutableSecretTarget(this.siteId, newValue, this.projectId, this.projectName);
    }

    public final ImmutableSecretTarget withProjectId(int value) {
        if (this.projectId == value) {
            return this;
        }
        return new ImmutableSecretTarget(this.siteId, this.name, value, this.projectName);
    }

    public final ImmutableSecretTarget withProjectName(String value) {
        if (this.projectName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"projectName");
        return new ImmutableSecretTarget(this.siteId, this.name, this.projectId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSecretTarget && this.equalTo((ImmutableSecretTarget)another);
    }

    private boolean equalTo(ImmutableSecretTarget another) {
        return this.siteId == another.siteId && this.name.equals(another.name) && this.projectId == another.projectId && this.projectName.equals(another.projectName);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.siteId;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.projectId;
        h = h * 17 + this.projectName.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SecretTarget").omitNullValues().add("siteId", this.siteId).add("name", (Object)this.name).add("projectId", this.projectId).add("projectName", (Object)this.projectName).toString();
    }

    public static ImmutableSecretTarget copyOf(SecretTarget instance) {
        if (instance instanceof ImmutableSecretTarget) {
            return (ImmutableSecretTarget)instance;
        }
        return ImmutableSecretTarget.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SITE_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_PROJECT_ID = 4L;
        private static final long INIT_BIT_PROJECT_NAME = 8L;
        private long initBits = 15L;
        private int siteId;
        @Nullable
        private String name;
        private int projectId;
        @Nullable
        private String projectName;

        private Builder() {
        }

        public final Builder from(SecretTarget instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.siteId(instance.getSiteId());
            this.name(instance.getName());
            this.projectId(instance.getProjectId());
            this.projectName(instance.getProjectName());
            return this;
        }

        public final Builder siteId(int siteId) {
            this.siteId = siteId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder projectId(int projectId) {
            this.projectId = projectId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder projectName(String projectName) {
            this.projectName = (String)Preconditions.checkNotNull((Object)projectName, (Object)"projectName");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableSecretTarget build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSecretTarget(this.siteId, this.name, this.projectId, this.projectName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("siteId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("projectId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("projectName");
            }
            return "Cannot build SecretTarget, some of required attributes are not set " + attributes;
        }
    }
}

