/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi.ac;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.digdag.spi.ac.ProjectTarget;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableProjectTarget
implements ProjectTarget {
    private final int siteId;
    private final String name;
    private final Optional<Integer> id;

    private ImmutableProjectTarget(int siteId, String name, Optional<Integer> id) {
        this.siteId = siteId;
        this.name = name;
        this.id = id;
    }

    @Override
    public int getSiteId() {
        return this.siteId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<Integer> getId() {
        return this.id;
    }

    public final ImmutableProjectTarget withSiteId(int value) {
        if (this.siteId == value) {
            return this;
        }
        return new ImmutableProjectTarget(value, this.name, this.id);
    }

    public final ImmutableProjectTarget withName(String value) {
        if (this.name.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"name");
        return new ImmutableProjectTarget(this.siteId, newValue, this.id);
    }

    public final ImmutableProjectTarget withId(int value) {
        Optional newValue = Optional.of((Object)value);
        if (this.id.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableProjectTarget(this.siteId, this.name, (Optional<Integer>)newValue);
    }

    public final ImmutableProjectTarget withId(Optional<Integer> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"id");
        if (this.id.equals((Object)value)) {
            return this;
        }
        return new ImmutableProjectTarget(this.siteId, this.name, (Optional<Integer>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProjectTarget && this.equalTo((ImmutableProjectTarget)another);
    }

    private boolean equalTo(ImmutableProjectTarget another) {
        return this.siteId == another.siteId && this.name.equals(another.name) && this.id.equals(another.id);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.siteId;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + this.id.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ProjectTarget").omitNullValues().add("siteId", this.siteId).add("name", (Object)this.name).add("id", this.id.orNull()).toString();
    }

    public static ImmutableProjectTarget copyOf(ProjectTarget instance) {
        if (instance instanceof ImmutableProjectTarget) {
            return (ImmutableProjectTarget)instance;
        }
        return ImmutableProjectTarget.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SITE_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        private int siteId;
        @Nullable
        private String name;
        private Optional<Integer> id = Optional.absent();

        private Builder() {
        }

        public final Builder from(ProjectTarget instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.siteId(instance.getSiteId());
            this.name(instance.getName());
            Optional<Integer> idOptional = instance.getId();
            if (idOptional.isPresent()) {
                this.id(idOptional);
            }
            return this;
        }

        public final Builder siteId(int siteId) {
            this.siteId = siteId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder id(int id) {
            this.id = Optional.of((Object)id);
            return this;
        }

        public final Builder id(Optional<Integer> id) {
            this.id = (Optional)Preconditions.checkNotNull(id, (Object)"id");
            return this;
        }

        public ImmutableProjectTarget build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProjectTarget(this.siteId, this.name, this.id);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("siteId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build ProjectTarget, some of required attributes are not set " + attributes;
        }
    }
}

