/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi.ac;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import io.digdag.spi.ac.AttemptTarget;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableAttemptTarget
implements AttemptTarget {
    private final int siteId;
    private final String projectName;
    private final String workflowName;
    private final long sessionId;
    private final long id;

    private ImmutableAttemptTarget(int siteId, String projectName, String workflowName, long sessionId, long id) {
        this.siteId = siteId;
        this.projectName = projectName;
        this.workflowName = workflowName;
        this.sessionId = sessionId;
        this.id = id;
    }

    @Override
    public int getSiteId() {
        return this.siteId;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public String getWorkflowName() {
        return this.workflowName;
    }

    @Override
    public long getSessionId() {
        return this.sessionId;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public final ImmutableAttemptTarget withSiteId(int value) {
        if (this.siteId == value) {
            return this;
        }
        return new ImmutableAttemptTarget(value, this.projectName, this.workflowName, this.sessionId, this.id);
    }

    public final ImmutableAttemptTarget withProjectName(String value) {
        if (this.projectName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"projectName");
        return new ImmutableAttemptTarget(this.siteId, newValue, this.workflowName, this.sessionId, this.id);
    }

    public final ImmutableAttemptTarget withWorkflowName(String value) {
        if (this.workflowName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"workflowName");
        return new ImmutableAttemptTarget(this.siteId, this.projectName, newValue, this.sessionId, this.id);
    }

    public final ImmutableAttemptTarget withSessionId(long value) {
        if (this.sessionId == value) {
            return this;
        }
        return new ImmutableAttemptTarget(this.siteId, this.projectName, this.workflowName, value, this.id);
    }

    public final ImmutableAttemptTarget withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableAttemptTarget(this.siteId, this.projectName, this.workflowName, this.sessionId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAttemptTarget && this.equalTo((ImmutableAttemptTarget)another);
    }

    private boolean equalTo(ImmutableAttemptTarget another) {
        return this.siteId == another.siteId && this.projectName.equals(another.projectName) && this.workflowName.equals(another.workflowName) && this.sessionId == another.sessionId && this.id == another.id;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.siteId;
        h = h * 17 + this.projectName.hashCode();
        h = h * 17 + this.workflowName.hashCode();
        h = h * 17 + Longs.hashCode((long)this.sessionId);
        h = h * 17 + Longs.hashCode((long)this.id);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AttemptTarget").omitNullValues().add("siteId", this.siteId).add("projectName", (Object)this.projectName).add("workflowName", (Object)this.workflowName).add("sessionId", this.sessionId).add("id", this.id).toString();
    }

    public static ImmutableAttemptTarget copyOf(AttemptTarget instance) {
        if (instance instanceof ImmutableAttemptTarget) {
            return (ImmutableAttemptTarget)instance;
        }
        return ImmutableAttemptTarget.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SITE_ID = 1L;
        private static final long INIT_BIT_PROJECT_NAME = 2L;
        private static final long INIT_BIT_WORKFLOW_NAME = 4L;
        private static final long INIT_BIT_SESSION_ID = 8L;
        private static final long INIT_BIT_ID = 16L;
        private long initBits = 31L;
        private int siteId;
        @Nullable
        private String projectName;
        @Nullable
        private String workflowName;
        private long sessionId;
        private long id;

        private Builder() {
        }

        public final Builder from(AttemptTarget instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.siteId(instance.getSiteId());
            this.projectName(instance.getProjectName());
            this.workflowName(instance.getWorkflowName());
            this.sessionId(instance.getSessionId());
            this.id(instance.getId());
            return this;
        }

        public final Builder siteId(int siteId) {
            this.siteId = siteId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder projectName(String projectName) {
            this.projectName = (String)Preconditions.checkNotNull((Object)projectName, (Object)"projectName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder workflowName(String workflowName) {
            this.workflowName = (String)Preconditions.checkNotNull((Object)workflowName, (Object)"workflowName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder sessionId(long sessionId) {
            this.sessionId = sessionId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableAttemptTarget build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAttemptTarget(this.siteId, this.projectName, this.workflowName, this.sessionId, this.id);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("siteId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("projectName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("workflowName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("sessionId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build AttemptTarget, some of required attributes are not set " + attributes;
        }
    }
}

