/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import io.digdag.client.config.Config;
import io.digdag.client.config.ConfigFactory;
import io.digdag.client.config.ConfigKey;
import io.digdag.spi.ImmutableTaskResult;
import io.digdag.spi.TaskReport;
import io.digdag.spi.TaskRequest;
import java.util.List;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableTaskResult.class)
@JsonDeserialize(as=ImmutableTaskResult.class)
@Value.Immutable
public interface TaskResult {
    public Config getSubtaskConfig();

    public Config getExportParams();

    public List<ConfigKey> getResetStoreParams();

    public Config getStoreParams();

    public TaskReport getReport();

    public static ImmutableTaskResult.Builder builder() {
        return ImmutableTaskResult.builder();
    }

    public static ImmutableTaskResult.Builder defaultBuilder(TaskRequest request) {
        return TaskResult.defaultBuilder(request.getConfig().getFactory());
    }

    public static ImmutableTaskResult.Builder defaultBuilder(ConfigFactory cf) {
        return TaskResult.builder().subtaskConfig(cf.create()).exportParams(cf.create()).resetStoreParams((Iterable<? extends ConfigKey>)ImmutableList.of()).storeParams(cf.create()).report(TaskReport.empty());
    }

    public static TaskResult empty(TaskRequest request) {
        return TaskResult.empty(request.getConfig().getFactory());
    }

    public static TaskResult empty(ConfigFactory cf) {
        return TaskResult.defaultBuilder(cf).build();
    }
}

