/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.digdag.spi.ImmutableSecretSelector;
import java.util.regex.Pattern;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableSecretSelector.class)
@JsonDeserialize(as=ImmutableSecretSelector.class)
@Value.Immutable
@Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE)
public interface SecretSelector {
    public static final Pattern VALID_PATTERN = Pattern.compile("^(\\w+\\.)*(\\w+|\\*)$");

    public String pattern();

    @Value.Check
    default public void check() {
        Preconditions.checkState((boolean)VALID_PATTERN.matcher(this.pattern()).matches(), (Object)("Bad secret selector: '" + this.pattern() + "'"));
    }

    default public boolean match(String key) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"key");
        if (this.pattern().endsWith("*")) {
            String prefix = this.pattern().substring(0, this.pattern().length() - 1);
            return key.startsWith(prefix);
        }
        return this.pattern().equals(key);
    }

    public static SecretSelector of(String pattern) {
        try {
            return SecretSelector.builder().pattern(pattern).build();
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Builder builder() {
        return ImmutableSecretSelector.builder();
    }

    public static interface Builder {
        public Builder pattern(String var1);

        public SecretSelector build();
    }
}

