/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Optional;
import io.digdag.spi.ImmutableNotification;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.UUID;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableNotification.class)
@JsonDeserialize(as=ImmutableNotification.class)
@Value.Immutable
public interface Notification {
    @JsonProperty(value="timestamp")
    public Instant getTimestamp();

    @JsonProperty(value="message")
    public String getMessage();

    @JsonProperty(value="site_id")
    public Optional<Integer> getSiteId();

    @JsonProperty(value="project_id")
    public Optional<Integer> getProjectId();

    @JsonProperty(value="project_name")
    public Optional<String> getProjectName();

    @JsonProperty(value="workflow_name")
    public Optional<String> getWorkflowName();

    @JsonProperty(value="revision")
    public Optional<String> getRevision();

    @JsonProperty(value="attempt_id")
    public Optional<Long> getAttemptId();

    @JsonProperty(value="session_id")
    public Optional<Long> getSessionId();

    @JsonProperty(value="task_name")
    public Optional<String> getTaskName();

    @JsonProperty(value="timezone")
    public Optional<ZoneId> getTimeZone();

    @JsonProperty(value="session_uuid")
    public Optional<UUID> getSessionUuid();

    @JsonProperty(value="session_time")
    public Optional<OffsetDateTime> getSessionTime();

    @JsonProperty(value="workflow_definition_id")
    public Optional<Long> getWorkflowDefinitionId();

    public static ImmutableNotification.Builder builder(Instant timestamp, String message) {
        return ImmutableNotification.builder().timestamp(timestamp).message(message);
    }
}

