/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Longs;
import io.digdag.client.config.Config;
import io.digdag.spi.TaskRequest;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableTaskRequest
implements TaskRequest {
    private final int siteId;
    private final int projectId;
    private final Optional<String> projectName;
    private final String workflowName;
    private final Optional<Long> workflowDefinitionId;
    private final Optional<String> revision;
    private final long taskId;
    private final long attemptId;
    private final long sessionId;
    private final Optional<String> retryAttemptName;
    private final String taskName;
    private final String lockId;
    private final ZoneId timeZone;
    private final UUID sessionUuid;
    private final Instant sessionTime;
    private final Instant createdAt;
    private final boolean isCancelRequested;
    private final Config localConfig;
    private final Config config;
    private final Config lastStateParams;

    private ImmutableTaskRequest(int siteId, int projectId, Optional<String> projectName, String workflowName, Optional<Long> workflowDefinitionId, Optional<String> revision, long taskId, long attemptId, long sessionId, Optional<String> retryAttemptName, String taskName, String lockId, ZoneId timeZone, UUID sessionUuid, Instant sessionTime, Instant createdAt, boolean isCancelRequested, Config localConfig, Config config, Config lastStateParams) {
        this.siteId = siteId;
        this.projectId = projectId;
        this.projectName = projectName;
        this.workflowName = workflowName;
        this.workflowDefinitionId = workflowDefinitionId;
        this.revision = revision;
        this.taskId = taskId;
        this.attemptId = attemptId;
        this.sessionId = sessionId;
        this.retryAttemptName = retryAttemptName;
        this.taskName = taskName;
        this.lockId = lockId;
        this.timeZone = timeZone;
        this.sessionUuid = sessionUuid;
        this.sessionTime = sessionTime;
        this.createdAt = createdAt;
        this.isCancelRequested = isCancelRequested;
        this.localConfig = localConfig;
        this.config = config;
        this.lastStateParams = lastStateParams;
    }

    @Override
    @JsonProperty(value="siteId")
    public int getSiteId() {
        return this.siteId;
    }

    @Override
    @JsonProperty(value="projectId")
    public int getProjectId() {
        return this.projectId;
    }

    @Override
    @JsonProperty(value="projectName")
    public Optional<String> getProjectName() {
        return this.projectName;
    }

    @Override
    @JsonProperty(value="workflowName")
    public String getWorkflowName() {
        return this.workflowName;
    }

    @Override
    @JsonProperty(value="workflowDefinitionId")
    public Optional<Long> getWorkflowDefinitionId() {
        return this.workflowDefinitionId;
    }

    @Override
    @JsonProperty(value="revision")
    public Optional<String> getRevision() {
        return this.revision;
    }

    @Override
    @JsonProperty(value="taskId")
    public long getTaskId() {
        return this.taskId;
    }

    @Override
    @JsonProperty(value="attemptId")
    public long getAttemptId() {
        return this.attemptId;
    }

    @Override
    @JsonProperty(value="sessionId")
    public long getSessionId() {
        return this.sessionId;
    }

    @Override
    @JsonProperty(value="retryAttemptName")
    public Optional<String> getRetryAttemptName() {
        return this.retryAttemptName;
    }

    @Override
    @JsonProperty(value="taskName")
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    @JsonProperty(value="lockId")
    public String getLockId() {
        return this.lockId;
    }

    @Override
    @JsonProperty(value="timeZone")
    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    @Override
    @JsonProperty(value="sessionUuid")
    public UUID getSessionUuid() {
        return this.sessionUuid;
    }

    @Override
    @JsonProperty(value="sessionTime")
    public Instant getSessionTime() {
        return this.sessionTime;
    }

    @Override
    @JsonProperty(value="createdAt")
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="isCancelRequested")
    public boolean isCancelRequested() {
        return this.isCancelRequested;
    }

    @Override
    @JsonProperty(value="localConfig")
    public Config getLocalConfig() {
        return this.localConfig;
    }

    @Override
    @JsonProperty(value="config")
    public Config getConfig() {
        return this.config;
    }

    @Override
    @JsonProperty(value="lastStateParams")
    public Config getLastStateParams() {
        return this.lastStateParams;
    }

    public final ImmutableTaskRequest withSiteId(int value) {
        if (this.siteId == value) {
            return this;
        }
        return new ImmutableTaskRequest(value, this.projectId, this.projectName, this.workflowName, this.workflowDefinitionId, this.revision, this.taskId, this.attemptId, this.sessionId, this.retryAttemptName, this.taskName, this.lockId, this.timeZone, this.sessionUuid, this.sessionTime, this.createdAt, this.isCancelRequested, this.localConfig, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withProjectId(int value) {
        if (this.projectId == value) {
            return this;
        }
        return new ImmutableTaskRequest(this.siteId, value, this.projectName, this.workflowName, this.workflowDefinitionId, this.revision, this.taskId, this.attemptId, this.sessionId, this.retryAttemptName, this.taskName, this.lockId, this.timeZone, this.sessionUuid, this.sessionTime, this.createdAt, this.isCancelRequested, this.localConfig, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withProjectName(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.projectName.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableTaskRequest(this.siteId, this.projectId, (Optional<String>)newValue, this.workflowName, this.workflowDefinitionId, this.revision, this.taskId, this.attemptId, this.sessionId, this.retryAttemptName, this.taskName, this.lockId, this.timeZone, this.sessionUuid, this.sessionTime, this.createdAt, this.isCancelRequested, this.localConfig, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withProjectName(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"projectName");
        if (this.projectName.equals((Object)value)) {
            return this;
        }
        return new ImmutableTaskRequest(this.siteId, this.projectId, (Optional<String>)value, this.workflowName, this.workflowDefinitionId, this.revision, this.taskId, this.attemptId, this.sessionId, this.retryAttemptName, this.taskName, this.lockId, this.timeZone, this.sessionUuid, this.sessionTime, this.createdAt, this.isCancelRequested, this.localConfig, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withWorkflowName(String value) {
        if (this.workflowName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"workflowName");
        return new ImmutableTaskRequest(this.siteId, this.projectId, this.projectName, newValue, this.workflowDefinitionId, this.revision, this.taskId, this.attemptId, this.sessionId, this.retryAttemptName, this.taskName, this.lockId, this.timeZone, this.sessionUuid, this.sessionTime, this.createdAt, this.isCancelRequested, this.localConfig, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withWorkflowDefinitionId(long value) {
        Optional newValue = Optional.of((Object)value);
        if (this.workflowDefinitionId.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableTaskRequest(this.siteId, this.projectId, this.projectName, this.workflowName, (Optional<Long>)newValue, this.revision, this.taskId, this.attemptId, this.sessionId, this.retryAttemptName, this.taskName, this.lockId, this.timeZone, this.sessionUuid, this.sessionTime, this.createdAt, this.isCancelRequested, this.localConfig, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withWorkflowDefinitionId(Optional<Long> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"workflowDefinitionId");
        if (this.workflowDefinitionId.equals((Object)value)) {
            return this;
        }
        return new ImmutableTaskRequest(this.siteId, this.projectId, this.projectName, this.workflowName, (Optional<Long>)value, this.revision, this.taskId, this.attemptId, this.sessionId, this.retryAttemptName, this.taskName, this.lockId, this.timeZone, this.sessionUuid, this.sessionTime, this.createdAt, this.isCancelRequested, this.localConfig, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withRevision(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.revision.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableTaskRequest(this.siteId, this.projectId, this.projectName, this.workflowName, this.workflowDefinitionId, (Optional<String>)newValue, this.taskId, this.attemptId, this.sessionId, this.retryAttemptName, this.taskName, this.lockId, this.timeZone, this.sessionUuid, this.sessionTime, this.createdAt, this.isCancelRequested, this.localConfig, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withRevision(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"revision");
        if (this.revision.equals((Object)value)) {
            return this;
        }
        return new ImmutableTaskRequest(this.siteId, this.projectId, this.projectName, this.workflowName, this.workflowDefinitionId, (Optional<String>)value, this.taskId, this.attemptId, this.sessionId, this.retryAttemptName, this.taskName, this.lockId, this.timeZone, this.sessionUuid, this.sessionTime, this.createdAt, this.isCancelRequested, this.localConfig, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withTaskId(long value) {
        if (this.taskId == value) {
            return this;
        }
        return new ImmutableTaskRequest(this.siteId, this.projectId, this.projectName, this.workflowName, this.workflowDefinitionId, this.revision, value, this.attemptId, this.sessionId, this.retryAttemptName, this.taskName, this.lockId, this.timeZone, this.sessionUuid, this.sessionTime, this.createdAt, this.isCancelRequested, this.localConfig, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withAttemptId(long value) {
        if (this.attemptId == value) {
            return this;
        }
        return new ImmutableTaskRequest(this.siteId, this.projectId, this.projectName, this.workflowName, this.workflowDefinitionId, this.revision, this.taskId, value, this.sessionId, this.retryAttemptName, this.taskName, this.lockId, this.timeZone, this.sessionUuid, this.sessionTime, this.createdAt, this.isCancelRequested, this.localConfig, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withSessionId(long value) {
        if (this.sessionId == value) {
            return this;
        }
        return new ImmutableTaskRequest(this.siteId, this.projectId, this.projectName, this.workflowName, this.workflowDefinitionId, this.revision, this.taskId, this.attemptId, value, this.retryAttemptName, this.taskName, this.lockId, this.timeZone, this.sessionUuid, this.sessionTime, this.createdAt, this.isCancelRequested, this.localConfig, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withRetryAttemptName(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.retryAttemptName.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableTaskRequest(this.siteId, this.projectId, this.projectName, this.workflowName, this.workflowDefinitionId, this.revision, this.taskId, this.attemptId, this.sessionId, (Optional<String>)newValue, this.taskName, this.lockId, this.timeZone, this.sessionUuid, this.sessionTime, this.createdAt, this.isCancelRequested, this.localConfig, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withRetryAttemptName(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"retryAttemptName");
        if (this.retryAttemptName.equals((Object)value)) {
            return this;
        }
        return new ImmutableTaskRequest(this.siteId, this.projectId, this.projectName, this.workflowName, this.workflowDefinitionId, this.revision, this.taskId, this.attemptId, this.sessionId, (Optional<String>)value, this.taskName, this.lockId, this.timeZone, this.sessionUuid, this.sessionTime, this.createdAt, this.isCancelRequested, this.localConfig, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withTaskName(String value) {
        if (this.taskName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"taskName");
        return new ImmutableTaskRequest(this.siteId, this.projectId, this.projectName, this.workflowName, this.workflowDefinitionId, this.revision, this.taskId, this.attemptId, this.sessionId, this.retryAttemptName, newValue, this.lockId, this.timeZone, this.sessionUuid, this.sessionTime, this.createdAt, this.isCancelRequested, this.localConfig, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withLockId(String value) {
        if (this.lockId.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"lockId");
        return new ImmutableTaskRequest(this.siteId, this.projectId, this.projectName, this.workflowName, this.workflowDefinitionId, this.revision, this.taskId, this.attemptId, this.sessionId, this.retryAttemptName, this.taskName, newValue, this.timeZone, this.sessionUuid, this.sessionTime, this.createdAt, this.isCancelRequested, this.localConfig, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withTimeZone(ZoneId value) {
        if (this.timeZone == value) {
            return this;
        }
        ZoneId newValue = (ZoneId)Preconditions.checkNotNull((Object)value, (Object)"timeZone");
        return new ImmutableTaskRequest(this.siteId, this.projectId, this.projectName, this.workflowName, this.workflowDefinitionId, this.revision, this.taskId, this.attemptId, this.sessionId, this.retryAttemptName, this.taskName, this.lockId, newValue, this.sessionUuid, this.sessionTime, this.createdAt, this.isCancelRequested, this.localConfig, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withSessionUuid(UUID value) {
        if (this.sessionUuid == value) {
            return this;
        }
        UUID newValue = (UUID)Preconditions.checkNotNull((Object)value, (Object)"sessionUuid");
        return new ImmutableTaskRequest(this.siteId, this.projectId, this.projectName, this.workflowName, this.workflowDefinitionId, this.revision, this.taskId, this.attemptId, this.sessionId, this.retryAttemptName, this.taskName, this.lockId, this.timeZone, newValue, this.sessionTime, this.createdAt, this.isCancelRequested, this.localConfig, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withSessionTime(Instant value) {
        if (this.sessionTime == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"sessionTime");
        return new ImmutableTaskRequest(this.siteId, this.projectId, this.projectName, this.workflowName, this.workflowDefinitionId, this.revision, this.taskId, this.attemptId, this.sessionId, this.retryAttemptName, this.taskName, this.lockId, this.timeZone, this.sessionUuid, newValue, this.createdAt, this.isCancelRequested, this.localConfig, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withCreatedAt(Instant value) {
        if (this.createdAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"createdAt");
        return new ImmutableTaskRequest(this.siteId, this.projectId, this.projectName, this.workflowName, this.workflowDefinitionId, this.revision, this.taskId, this.attemptId, this.sessionId, this.retryAttemptName, this.taskName, this.lockId, this.timeZone, this.sessionUuid, this.sessionTime, newValue, this.isCancelRequested, this.localConfig, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withIsCancelRequested(boolean value) {
        if (this.isCancelRequested == value) {
            return this;
        }
        return new ImmutableTaskRequest(this.siteId, this.projectId, this.projectName, this.workflowName, this.workflowDefinitionId, this.revision, this.taskId, this.attemptId, this.sessionId, this.retryAttemptName, this.taskName, this.lockId, this.timeZone, this.sessionUuid, this.sessionTime, this.createdAt, value, this.localConfig, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withLocalConfig(Config value) {
        if (this.localConfig == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"localConfig");
        return new ImmutableTaskRequest(this.siteId, this.projectId, this.projectName, this.workflowName, this.workflowDefinitionId, this.revision, this.taskId, this.attemptId, this.sessionId, this.retryAttemptName, this.taskName, this.lockId, this.timeZone, this.sessionUuid, this.sessionTime, this.createdAt, this.isCancelRequested, newValue, this.config, this.lastStateParams);
    }

    public final ImmutableTaskRequest withConfig(Config value) {
        if (this.config == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"config");
        return new ImmutableTaskRequest(this.siteId, this.projectId, this.projectName, this.workflowName, this.workflowDefinitionId, this.revision, this.taskId, this.attemptId, this.sessionId, this.retryAttemptName, this.taskName, this.lockId, this.timeZone, this.sessionUuid, this.sessionTime, this.createdAt, this.isCancelRequested, this.localConfig, newValue, this.lastStateParams);
    }

    public final ImmutableTaskRequest withLastStateParams(Config value) {
        if (this.lastStateParams == value) {
            return this;
        }
        Config newValue = (Config)Preconditions.checkNotNull((Object)value, (Object)"lastStateParams");
        return new ImmutableTaskRequest(this.siteId, this.projectId, this.projectName, this.workflowName, this.workflowDefinitionId, this.revision, this.taskId, this.attemptId, this.sessionId, this.retryAttemptName, this.taskName, this.lockId, this.timeZone, this.sessionUuid, this.sessionTime, this.createdAt, this.isCancelRequested, this.localConfig, this.config, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTaskRequest && this.equalTo((ImmutableTaskRequest)another);
    }

    private boolean equalTo(ImmutableTaskRequest another) {
        return this.siteId == another.siteId && this.projectId == another.projectId && this.projectName.equals(another.projectName) && this.workflowName.equals(another.workflowName) && this.workflowDefinitionId.equals(another.workflowDefinitionId) && this.revision.equals(another.revision) && this.taskId == another.taskId && this.attemptId == another.attemptId && this.sessionId == another.sessionId && this.retryAttemptName.equals(another.retryAttemptName) && this.taskName.equals(another.taskName) && this.lockId.equals(another.lockId) && this.timeZone.equals(another.timeZone) && this.sessionUuid.equals(another.sessionUuid) && this.sessionTime.equals(another.sessionTime) && this.createdAt.equals(another.createdAt) && this.isCancelRequested == another.isCancelRequested && this.localConfig.equals((Object)another.localConfig) && this.config.equals((Object)another.config) && this.lastStateParams.equals((Object)another.lastStateParams);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.siteId;
        h = h * 17 + this.projectId;
        h = h * 17 + this.projectName.hashCode();
        h = h * 17 + this.workflowName.hashCode();
        h = h * 17 + this.workflowDefinitionId.hashCode();
        h = h * 17 + this.revision.hashCode();
        h = h * 17 + Longs.hashCode((long)this.taskId);
        h = h * 17 + Longs.hashCode((long)this.attemptId);
        h = h * 17 + Longs.hashCode((long)this.sessionId);
        h = h * 17 + this.retryAttemptName.hashCode();
        h = h * 17 + this.taskName.hashCode();
        h = h * 17 + this.lockId.hashCode();
        h = h * 17 + this.timeZone.hashCode();
        h = h * 17 + this.sessionUuid.hashCode();
        h = h * 17 + this.sessionTime.hashCode();
        h = h * 17 + this.createdAt.hashCode();
        h = h * 17 + Booleans.hashCode((boolean)this.isCancelRequested);
        h = h * 17 + this.localConfig.hashCode();
        h = h * 17 + this.config.hashCode();
        h = h * 17 + this.lastStateParams.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TaskRequest").omitNullValues().add("siteId", this.siteId).add("projectId", this.projectId).add("projectName", this.projectName.orNull()).add("workflowName", (Object)this.workflowName).add("workflowDefinitionId", this.workflowDefinitionId.orNull()).add("revision", this.revision.orNull()).add("taskId", this.taskId).add("attemptId", this.attemptId).add("sessionId", this.sessionId).add("retryAttemptName", this.retryAttemptName.orNull()).add("taskName", (Object)this.taskName).add("lockId", (Object)this.lockId).add("timeZone", (Object)this.timeZone).add("sessionUuid", (Object)this.sessionUuid).add("sessionTime", (Object)this.sessionTime).add("createdAt", (Object)this.createdAt).add("isCancelRequested", this.isCancelRequested).add("localConfig", (Object)this.localConfig).add("config", (Object)this.config).add("lastStateParams", (Object)this.lastStateParams).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTaskRequest fromJson(Json json) {
        Builder builder = ImmutableTaskRequest.builder();
        if (json.siteIdIsSet) {
            builder.siteId(json.siteId);
        }
        if (json.projectIdIsSet) {
            builder.projectId(json.projectId);
        }
        if (json.projectName != null) {
            builder.projectName(json.projectName);
        }
        if (json.workflowName != null) {
            builder.workflowName(json.workflowName);
        }
        if (json.workflowDefinitionId != null) {
            builder.workflowDefinitionId(json.workflowDefinitionId);
        }
        if (json.revision != null) {
            builder.revision(json.revision);
        }
        if (json.taskIdIsSet) {
            builder.taskId(json.taskId);
        }
        if (json.attemptIdIsSet) {
            builder.attemptId(json.attemptId);
        }
        if (json.sessionIdIsSet) {
            builder.sessionId(json.sessionId);
        }
        if (json.retryAttemptName != null) {
            builder.retryAttemptName(json.retryAttemptName);
        }
        if (json.taskName != null) {
            builder.taskName(json.taskName);
        }
        if (json.lockId != null) {
            builder.lockId(json.lockId);
        }
        if (json.timeZone != null) {
            builder.timeZone(json.timeZone);
        }
        if (json.sessionUuid != null) {
            builder.sessionUuid(json.sessionUuid);
        }
        if (json.sessionTime != null) {
            builder.sessionTime(json.sessionTime);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        if (json.isCancelRequestedIsSet) {
            builder.isCancelRequested(json.isCancelRequested);
        }
        if (json.localConfig != null) {
            builder.localConfig(json.localConfig);
        }
        if (json.config != null) {
            builder.config(json.config);
        }
        if (json.lastStateParams != null) {
            builder.lastStateParams(json.lastStateParams);
        }
        return builder.build();
    }

    public static ImmutableTaskRequest copyOf(TaskRequest instance) {
        if (instance instanceof ImmutableTaskRequest) {
            return (ImmutableTaskRequest)instance;
        }
        return ImmutableTaskRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SITE_ID = 1L;
        private static final long INIT_BIT_PROJECT_ID = 2L;
        private static final long INIT_BIT_WORKFLOW_NAME = 4L;
        private static final long INIT_BIT_TASK_ID = 8L;
        private static final long INIT_BIT_ATTEMPT_ID = 16L;
        private static final long INIT_BIT_SESSION_ID = 32L;
        private static final long INIT_BIT_TASK_NAME = 64L;
        private static final long INIT_BIT_LOCK_ID = 128L;
        private static final long INIT_BIT_TIME_ZONE = 256L;
        private static final long INIT_BIT_SESSION_UUID = 512L;
        private static final long INIT_BIT_SESSION_TIME = 1024L;
        private static final long INIT_BIT_CREATED_AT = 2048L;
        private static final long INIT_BIT_IS_CANCEL_REQUESTED = 4096L;
        private static final long INIT_BIT_LOCAL_CONFIG = 8192L;
        private static final long INIT_BIT_CONFIG = 16384L;
        private static final long INIT_BIT_LAST_STATE_PARAMS = 32768L;
        private long initBits = 65535L;
        private int siteId;
        private int projectId;
        private Optional<String> projectName = Optional.absent();
        @Nullable
        private String workflowName;
        private Optional<Long> workflowDefinitionId = Optional.absent();
        private Optional<String> revision = Optional.absent();
        private long taskId;
        private long attemptId;
        private long sessionId;
        private Optional<String> retryAttemptName = Optional.absent();
        @Nullable
        private String taskName;
        @Nullable
        private String lockId;
        @Nullable
        private ZoneId timeZone;
        @Nullable
        private UUID sessionUuid;
        @Nullable
        private Instant sessionTime;
        @Nullable
        private Instant createdAt;
        private boolean isCancelRequested;
        @Nullable
        private Config localConfig;
        @Nullable
        private Config config;
        @Nullable
        private Config lastStateParams;

        private Builder() {
        }

        public final Builder from(TaskRequest instance) {
            Optional<String> revisionOptional;
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.siteId(instance.getSiteId());
            this.projectId(instance.getProjectId());
            Optional<String> projectNameOptional = instance.getProjectName();
            if (projectNameOptional.isPresent()) {
                this.projectName(projectNameOptional);
            }
            this.workflowName(instance.getWorkflowName());
            Optional<Long> workflowDefinitionIdOptional = instance.getWorkflowDefinitionId();
            if (workflowDefinitionIdOptional.isPresent()) {
                this.workflowDefinitionId(workflowDefinitionIdOptional);
            }
            if ((revisionOptional = instance.getRevision()).isPresent()) {
                this.revision(revisionOptional);
            }
            this.taskId(instance.getTaskId());
            this.attemptId(instance.getAttemptId());
            this.sessionId(instance.getSessionId());
            Optional<String> retryAttemptNameOptional = instance.getRetryAttemptName();
            if (retryAttemptNameOptional.isPresent()) {
                this.retryAttemptName(retryAttemptNameOptional);
            }
            this.taskName(instance.getTaskName());
            this.lockId(instance.getLockId());
            this.timeZone(instance.getTimeZone());
            this.sessionUuid(instance.getSessionUuid());
            this.sessionTime(instance.getSessionTime());
            this.createdAt(instance.getCreatedAt());
            this.isCancelRequested(instance.isCancelRequested());
            this.localConfig(instance.getLocalConfig());
            this.config(instance.getConfig());
            this.lastStateParams(instance.getLastStateParams());
            return this;
        }

        @JsonProperty(value="siteId")
        public final Builder siteId(int siteId) {
            this.siteId = siteId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="projectId")
        public final Builder projectId(int projectId) {
            this.projectId = projectId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder projectName(String projectName) {
            this.projectName = Optional.of((Object)projectName);
            return this;
        }

        @JsonProperty(value="projectName")
        public final Builder projectName(Optional<String> projectName) {
            this.projectName = (Optional)Preconditions.checkNotNull(projectName, (Object)"projectName");
            return this;
        }

        @JsonProperty(value="workflowName")
        public final Builder workflowName(String workflowName) {
            this.workflowName = (String)Preconditions.checkNotNull((Object)workflowName, (Object)"workflowName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder workflowDefinitionId(long workflowDefinitionId) {
            this.workflowDefinitionId = Optional.of((Object)workflowDefinitionId);
            return this;
        }

        @JsonProperty(value="workflowDefinitionId")
        public final Builder workflowDefinitionId(Optional<Long> workflowDefinitionId) {
            this.workflowDefinitionId = (Optional)Preconditions.checkNotNull(workflowDefinitionId, (Object)"workflowDefinitionId");
            return this;
        }

        public final Builder revision(String revision) {
            this.revision = Optional.of((Object)revision);
            return this;
        }

        @JsonProperty(value="revision")
        public final Builder revision(Optional<String> revision) {
            this.revision = (Optional)Preconditions.checkNotNull(revision, (Object)"revision");
            return this;
        }

        @JsonProperty(value="taskId")
        public final Builder taskId(long taskId) {
            this.taskId = taskId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="attemptId")
        public final Builder attemptId(long attemptId) {
            this.attemptId = attemptId;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="sessionId")
        public final Builder sessionId(long sessionId) {
            this.sessionId = sessionId;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder retryAttemptName(String retryAttemptName) {
            this.retryAttemptName = Optional.of((Object)retryAttemptName);
            return this;
        }

        @JsonProperty(value="retryAttemptName")
        public final Builder retryAttemptName(Optional<String> retryAttemptName) {
            this.retryAttemptName = (Optional)Preconditions.checkNotNull(retryAttemptName, (Object)"retryAttemptName");
            return this;
        }

        @JsonProperty(value="taskName")
        public final Builder taskName(String taskName) {
            this.taskName = (String)Preconditions.checkNotNull((Object)taskName, (Object)"taskName");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="lockId")
        public final Builder lockId(String lockId) {
            this.lockId = (String)Preconditions.checkNotNull((Object)lockId, (Object)"lockId");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty(value="timeZone")
        public final Builder timeZone(ZoneId timeZone) {
            this.timeZone = (ZoneId)Preconditions.checkNotNull((Object)timeZone, (Object)"timeZone");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @JsonProperty(value="sessionUuid")
        public final Builder sessionUuid(UUID sessionUuid) {
            this.sessionUuid = (UUID)Preconditions.checkNotNull((Object)sessionUuid, (Object)"sessionUuid");
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        @JsonProperty(value="sessionTime")
        public final Builder sessionTime(Instant sessionTime) {
            this.sessionTime = (Instant)Preconditions.checkNotNull((Object)sessionTime, (Object)"sessionTime");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        @JsonProperty(value="createdAt")
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = (Instant)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        @JsonProperty(value="isCancelRequested")
        public final Builder isCancelRequested(boolean isCancelRequested) {
            this.isCancelRequested = isCancelRequested;
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return this;
        }

        @JsonProperty(value="localConfig")
        public final Builder localConfig(Config localConfig) {
            this.localConfig = (Config)Preconditions.checkNotNull((Object)localConfig, (Object)"localConfig");
            this.initBits &= 0xFFFFFFFFFFFFDFFFL;
            return this;
        }

        @JsonProperty(value="config")
        public final Builder config(Config config) {
            this.config = (Config)Preconditions.checkNotNull((Object)config, (Object)"config");
            this.initBits &= 0xFFFFFFFFFFFFBFFFL;
            return this;
        }

        @JsonProperty(value="lastStateParams")
        public final Builder lastStateParams(Config lastStateParams) {
            this.lastStateParams = (Config)Preconditions.checkNotNull((Object)lastStateParams, (Object)"lastStateParams");
            this.initBits &= 0xFFFFFFFFFFFF7FFFL;
            return this;
        }

        public ImmutableTaskRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTaskRequest(this.siteId, this.projectId, this.projectName, this.workflowName, this.workflowDefinitionId, this.revision, this.taskId, this.attemptId, this.sessionId, this.retryAttemptName, this.taskName, this.lockId, this.timeZone, this.sessionUuid, this.sessionTime, this.createdAt, this.isCancelRequested, this.localConfig, this.config, this.lastStateParams);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("siteId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("projectId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("workflowName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("taskId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("attemptId");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("sessionId");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("taskName");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("lockId");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("timeZone");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("sessionUuid");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("sessionTime");
            }
            if ((this.initBits & 0x800L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 0x1000L) != 0L) {
                attributes.add("isCancelRequested");
            }
            if ((this.initBits & 0x2000L) != 0L) {
                attributes.add("localConfig");
            }
            if ((this.initBits & 0x4000L) != 0L) {
                attributes.add("config");
            }
            if ((this.initBits & 0x8000L) != 0L) {
                attributes.add("lastStateParams");
            }
            return "Cannot build TaskRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements TaskRequest {
        int siteId;
        boolean siteIdIsSet;
        int projectId;
        boolean projectIdIsSet;
        Optional<String> projectName = Optional.absent();
        @Nullable
        String workflowName;
        Optional<Long> workflowDefinitionId = Optional.absent();
        Optional<String> revision = Optional.absent();
        long taskId;
        boolean taskIdIsSet;
        long attemptId;
        boolean attemptIdIsSet;
        long sessionId;
        boolean sessionIdIsSet;
        Optional<String> retryAttemptName = Optional.absent();
        @Nullable
        String taskName;
        @Nullable
        String lockId;
        @Nullable
        ZoneId timeZone;
        @Nullable
        UUID sessionUuid;
        @Nullable
        Instant sessionTime;
        @Nullable
        Instant createdAt;
        boolean isCancelRequested;
        boolean isCancelRequestedIsSet;
        @Nullable
        Config localConfig;
        @Nullable
        Config config;
        @Nullable
        Config lastStateParams;

        Json() {
        }

        @JsonProperty(value="siteId")
        public void setSiteId(int siteId) {
            this.siteId = siteId;
            this.siteIdIsSet = true;
        }

        @JsonProperty(value="projectId")
        public void setProjectId(int projectId) {
            this.projectId = projectId;
            this.projectIdIsSet = true;
        }

        @JsonProperty(value="projectName")
        public void setProjectName(Optional<String> projectName) {
            this.projectName = projectName;
        }

        @JsonProperty(value="workflowName")
        public void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @JsonProperty(value="workflowDefinitionId")
        public void setWorkflowDefinitionId(Optional<Long> workflowDefinitionId) {
            this.workflowDefinitionId = workflowDefinitionId;
        }

        @JsonProperty(value="revision")
        public void setRevision(Optional<String> revision) {
            this.revision = revision;
        }

        @JsonProperty(value="taskId")
        public void setTaskId(long taskId) {
            this.taskId = taskId;
            this.taskIdIsSet = true;
        }

        @JsonProperty(value="attemptId")
        public void setAttemptId(long attemptId) {
            this.attemptId = attemptId;
            this.attemptIdIsSet = true;
        }

        @JsonProperty(value="sessionId")
        public void setSessionId(long sessionId) {
            this.sessionId = sessionId;
            this.sessionIdIsSet = true;
        }

        @JsonProperty(value="retryAttemptName")
        public void setRetryAttemptName(Optional<String> retryAttemptName) {
            this.retryAttemptName = retryAttemptName;
        }

        @JsonProperty(value="taskName")
        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        @JsonProperty(value="lockId")
        public void setLockId(String lockId) {
            this.lockId = lockId;
        }

        @JsonProperty(value="timeZone")
        public void setTimeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
        }

        @JsonProperty(value="sessionUuid")
        public void setSessionUuid(UUID sessionUuid) {
            this.sessionUuid = sessionUuid;
        }

        @JsonProperty(value="sessionTime")
        public void setSessionTime(Instant sessionTime) {
            this.sessionTime = sessionTime;
        }

        @JsonProperty(value="createdAt")
        public void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @JsonProperty(value="isCancelRequested")
        public void setIsCancelRequested(boolean isCancelRequested) {
            this.isCancelRequested = isCancelRequested;
            this.isCancelRequestedIsSet = true;
        }

        @JsonProperty(value="localConfig")
        public void setLocalConfig(Config localConfig) {
            this.localConfig = localConfig;
        }

        @JsonProperty(value="config")
        public void setConfig(Config config) {
            this.config = config;
        }

        @JsonProperty(value="lastStateParams")
        public void setLastStateParams(Config lastStateParams) {
            this.lastStateParams = lastStateParams;
        }

        @Override
        public int getSiteId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getProjectId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getProjectName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getWorkflowName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> getWorkflowDefinitionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getRevision() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getTaskId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getAttemptId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSessionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getRetryAttemptName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTaskName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLockId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZoneId getTimeZone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UUID getSessionUuid() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getSessionTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCancelRequested() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getLocalConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Config getLastStateParams() {
            throw new UnsupportedOperationException();
        }
    }
}

