/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.digdag.client.config.Config;
import io.digdag.spi.TaskReport;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableTaskReport
implements TaskReport {
    private final ImmutableList<Config> inputs;
    private final ImmutableList<Config> outputs;

    private ImmutableTaskReport(ImmutableList<Config> inputs, ImmutableList<Config> outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
    }

    @JsonProperty(value="inputs")
    public ImmutableList<Config> getInputs() {
        return this.inputs;
    }

    @JsonProperty(value="outputs")
    public ImmutableList<Config> getOutputs() {
        return this.outputs;
    }

    public final ImmutableTaskReport withInputs(Config ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTaskReport((ImmutableList<Config>)newValue, this.outputs);
    }

    public final ImmutableTaskReport withInputs(Iterable<? extends Config> elements) {
        if (this.inputs == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTaskReport((ImmutableList<Config>)newValue, this.outputs);
    }

    public final ImmutableTaskReport withOutputs(Config ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTaskReport(this.inputs, (ImmutableList<Config>)newValue);
    }

    public final ImmutableTaskReport withOutputs(Iterable<? extends Config> elements) {
        if (this.outputs == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTaskReport(this.inputs, (ImmutableList<Config>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTaskReport && this.equalTo((ImmutableTaskReport)another);
    }

    private boolean equalTo(ImmutableTaskReport another) {
        return this.inputs.equals(another.inputs) && this.outputs.equals(another.outputs);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.inputs.hashCode();
        h = h * 17 + this.outputs.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TaskReport").omitNullValues().add("inputs", this.inputs).add("outputs", this.outputs).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTaskReport fromJson(Json json) {
        Builder builder = ImmutableTaskReport.builder();
        if (json.inputs != null) {
            builder.addAllInputs(json.inputs);
        }
        if (json.outputs != null) {
            builder.addAllOutputs(json.outputs);
        }
        return builder.build();
    }

    public static ImmutableTaskReport copyOf(TaskReport instance) {
        if (instance instanceof ImmutableTaskReport) {
            return (ImmutableTaskReport)instance;
        }
        return ImmutableTaskReport.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<Config> inputs = ImmutableList.builder();
        private ImmutableList.Builder<Config> outputs = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(TaskReport instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.addAllInputs(instance.getInputs());
            this.addAllOutputs(instance.getOutputs());
            return this;
        }

        public final Builder addInputs(Config element) {
            this.inputs.add((Object)element);
            return this;
        }

        public final Builder addInputs(Config ... elements) {
            this.inputs.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="inputs")
        public final Builder inputs(Iterable<? extends Config> elements) {
            this.inputs = ImmutableList.builder();
            return this.addAllInputs(elements);
        }

        public final Builder addAllInputs(Iterable<? extends Config> elements) {
            this.inputs.addAll(elements);
            return this;
        }

        public final Builder addOutputs(Config element) {
            this.outputs.add((Object)element);
            return this;
        }

        public final Builder addOutputs(Config ... elements) {
            this.outputs.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="outputs")
        public final Builder outputs(Iterable<? extends Config> elements) {
            this.outputs = ImmutableList.builder();
            return this.addAllOutputs(elements);
        }

        public final Builder addAllOutputs(Iterable<? extends Config> elements) {
            this.outputs.addAll(elements);
            return this;
        }

        public ImmutableTaskReport build() {
            return new ImmutableTaskReport(this.inputs.build(), this.outputs.build());
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements TaskReport {
        List<Config> inputs = ImmutableList.of();
        List<Config> outputs = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="inputs")
        public void setInputs(List<Config> inputs) {
            this.inputs = inputs;
        }

        @JsonProperty(value="outputs")
        public void setOutputs(List<Config> outputs) {
            this.outputs = outputs;
        }

        @Override
        public List<Config> getInputs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Config> getOutputs() {
            throw new UnsupportedOperationException();
        }
    }
}

