/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.digdag.spi.TaskQueueData;
import io.digdag.spi.TaskQueueRequest;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableTaskQueueRequest
implements TaskQueueRequest {
    private final int priority;
    private final String uniqueName;
    private final Optional<byte[]> data;

    private ImmutableTaskQueueRequest(int priority, String uniqueName, Optional<byte[]> data) {
        this.priority = priority;
        this.uniqueName = uniqueName;
        this.data = data;
    }

    @Override
    @JsonProperty(value="priority")
    public int getPriority() {
        return this.priority;
    }

    @Override
    @JsonProperty(value="uniqueName")
    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    @JsonProperty(value="data")
    public Optional<byte[]> getData() {
        return this.data;
    }

    public final ImmutableTaskQueueRequest withPriority(int value) {
        if (this.priority == value) {
            return this;
        }
        return new ImmutableTaskQueueRequest(value, this.uniqueName, this.data);
    }

    public final ImmutableTaskQueueRequest withUniqueName(String value) {
        if (this.uniqueName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"uniqueName");
        return new ImmutableTaskQueueRequest(this.priority, newValue, this.data);
    }

    public final ImmutableTaskQueueRequest withData(byte[] value) {
        Optional newValue = Optional.of((Object)value);
        if (this.data.isPresent() && this.data.get() == value) {
            return this;
        }
        return new ImmutableTaskQueueRequest(this.priority, this.uniqueName, (Optional<byte[]>)newValue);
    }

    public final ImmutableTaskQueueRequest withData(Optional<byte[]> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"data");
        if (!this.data.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.data.isPresent() && value.isPresent() && this.data.get() == value.get()) {
            return this;
        }
        return new ImmutableTaskQueueRequest(this.priority, this.uniqueName, (Optional<byte[]>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTaskQueueRequest && this.equalTo((ImmutableTaskQueueRequest)another);
    }

    private boolean equalTo(ImmutableTaskQueueRequest another) {
        return this.priority == another.priority && this.uniqueName.equals(another.uniqueName) && this.data.equals(another.data);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.priority;
        h = h * 17 + this.uniqueName.hashCode();
        h = h * 17 + this.data.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TaskQueueRequest").omitNullValues().add("priority", this.priority).add("uniqueName", (Object)this.uniqueName).add("data", this.data.orNull()).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTaskQueueRequest fromJson(Json json) {
        Builder builder = ImmutableTaskQueueRequest.builder();
        if (json.priorityIsSet) {
            builder.priority(json.priority);
        }
        if (json.uniqueName != null) {
            builder.uniqueName(json.uniqueName);
        }
        if (json.data != null) {
            builder.data(json.data);
        }
        return builder.build();
    }

    public static ImmutableTaskQueueRequest copyOf(TaskQueueRequest instance) {
        if (instance instanceof ImmutableTaskQueueRequest) {
            return (ImmutableTaskQueueRequest)instance;
        }
        return ImmutableTaskQueueRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PRIORITY = 1L;
        private static final long INIT_BIT_UNIQUE_NAME = 2L;
        private long initBits = 3L;
        private int priority;
        @Nullable
        private String uniqueName;
        private Optional<byte[]> data = Optional.absent();

        private Builder() {
        }

        public final Builder from(TaskQueueData instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TaskQueueRequest instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TaskQueueData instance;
            if (object instanceof TaskQueueData) {
                instance = (TaskQueueData)object;
                Optional<byte[]> dataOptional = instance.getData();
                if (dataOptional.isPresent()) {
                    this.data(dataOptional);
                }
                this.uniqueName(instance.getUniqueName());
            }
            if (object instanceof TaskQueueRequest) {
                instance = (TaskQueueRequest)object;
                this.priority(instance.getPriority());
            }
        }

        @JsonProperty(value="priority")
        public final Builder priority(int priority) {
            this.priority = priority;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="uniqueName")
        public final Builder uniqueName(String uniqueName) {
            this.uniqueName = (String)Preconditions.checkNotNull((Object)uniqueName, (Object)"uniqueName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder data(byte[] data) {
            this.data = Optional.of((Object)data);
            return this;
        }

        @JsonProperty(value="data")
        public final Builder data(Optional<byte[]> data) {
            this.data = (Optional)Preconditions.checkNotNull(data, (Object)"data");
            return this;
        }

        public ImmutableTaskQueueRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTaskQueueRequest(this.priority, this.uniqueName, this.data);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("priority");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("uniqueName");
            }
            return "Cannot build TaskQueueRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements TaskQueueRequest {
        int priority;
        boolean priorityIsSet;
        @Nullable
        String uniqueName;
        Optional<byte[]> data = Optional.absent();

        Json() {
        }

        @JsonProperty(value="priority")
        public void setPriority(int priority) {
            this.priority = priority;
            this.priorityIsSet = true;
        }

        @JsonProperty(value="uniqueName")
        public void setUniqueName(String uniqueName) {
            this.uniqueName = uniqueName;
        }

        @JsonProperty(value="data")
        public void setData(Optional<byte[]> data) {
            this.data = data;
        }

        @Override
        public int getPriority() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUniqueName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<byte[]> getData() {
            throw new UnsupportedOperationException();
        }
    }
}

