/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.digdag.spi.TaskQueueData;
import io.digdag.spi.TaskQueueLock;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableTaskQueueLock
implements TaskQueueLock {
    private final String lockId;
    private final String uniqueName;
    private final Optional<byte[]> data;

    private ImmutableTaskQueueLock(String lockId, String uniqueName, Optional<byte[]> data) {
        this.lockId = lockId;
        this.uniqueName = uniqueName;
        this.data = data;
    }

    @Override
    @JsonProperty(value="lockId")
    public String getLockId() {
        return this.lockId;
    }

    @Override
    @JsonProperty(value="uniqueName")
    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    @JsonProperty(value="data")
    public Optional<byte[]> getData() {
        return this.data;
    }

    public final ImmutableTaskQueueLock withLockId(String value) {
        if (this.lockId.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"lockId");
        return new ImmutableTaskQueueLock(newValue, this.uniqueName, this.data);
    }

    public final ImmutableTaskQueueLock withUniqueName(String value) {
        if (this.uniqueName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"uniqueName");
        return new ImmutableTaskQueueLock(this.lockId, newValue, this.data);
    }

    public final ImmutableTaskQueueLock withData(byte[] value) {
        Optional newValue = Optional.of((Object)value);
        if (this.data.isPresent() && this.data.get() == value) {
            return this;
        }
        return new ImmutableTaskQueueLock(this.lockId, this.uniqueName, (Optional<byte[]>)newValue);
    }

    public final ImmutableTaskQueueLock withData(Optional<byte[]> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"data");
        if (!this.data.isPresent() && !value.isPresent()) {
            return this;
        }
        if (this.data.isPresent() && value.isPresent() && this.data.get() == value.get()) {
            return this;
        }
        return new ImmutableTaskQueueLock(this.lockId, this.uniqueName, (Optional<byte[]>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTaskQueueLock && this.equalTo((ImmutableTaskQueueLock)another);
    }

    private boolean equalTo(ImmutableTaskQueueLock another) {
        return this.lockId.equals(another.lockId) && this.uniqueName.equals(another.uniqueName) && this.data.equals(another.data);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.lockId.hashCode();
        h = h * 17 + this.uniqueName.hashCode();
        h = h * 17 + this.data.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TaskQueueLock").omitNullValues().add("lockId", (Object)this.lockId).add("uniqueName", (Object)this.uniqueName).add("data", this.data.orNull()).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTaskQueueLock fromJson(Json json) {
        Builder builder = ImmutableTaskQueueLock.builder();
        if (json.lockId != null) {
            builder.lockId(json.lockId);
        }
        if (json.uniqueName != null) {
            builder.uniqueName(json.uniqueName);
        }
        if (json.data != null) {
            builder.data(json.data);
        }
        return builder.build();
    }

    public static ImmutableTaskQueueLock copyOf(TaskQueueLock instance) {
        if (instance instanceof ImmutableTaskQueueLock) {
            return (ImmutableTaskQueueLock)instance;
        }
        return ImmutableTaskQueueLock.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LOCK_ID = 1L;
        private static final long INIT_BIT_UNIQUE_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private String lockId;
        @Nullable
        private String uniqueName;
        private Optional<byte[]> data = Optional.absent();

        private Builder() {
        }

        public final Builder from(TaskQueueLock instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TaskQueueData instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TaskQueueData instance;
            if (object instanceof TaskQueueLock) {
                instance = (TaskQueueLock)object;
                this.lockId(instance.getLockId());
            }
            if (object instanceof TaskQueueData) {
                instance = (TaskQueueData)object;
                Optional<byte[]> dataOptional = instance.getData();
                if (dataOptional.isPresent()) {
                    this.data(dataOptional);
                }
                this.uniqueName(instance.getUniqueName());
            }
        }

        @JsonProperty(value="lockId")
        public final Builder lockId(String lockId) {
            this.lockId = (String)Preconditions.checkNotNull((Object)lockId, (Object)"lockId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="uniqueName")
        public final Builder uniqueName(String uniqueName) {
            this.uniqueName = (String)Preconditions.checkNotNull((Object)uniqueName, (Object)"uniqueName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder data(byte[] data) {
            this.data = Optional.of((Object)data);
            return this;
        }

        @JsonProperty(value="data")
        public final Builder data(Optional<byte[]> data) {
            this.data = (Optional)Preconditions.checkNotNull(data, (Object)"data");
            return this;
        }

        public ImmutableTaskQueueLock build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTaskQueueLock(this.lockId, this.uniqueName, this.data);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("lockId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("uniqueName");
            }
            return "Cannot build TaskQueueLock, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements TaskQueueLock {
        @Nullable
        String lockId;
        @Nullable
        String uniqueName;
        Optional<byte[]> data = Optional.absent();

        Json() {
        }

        @JsonProperty(value="lockId")
        public void setLockId(String lockId) {
            this.lockId = lockId;
        }

        @JsonProperty(value="uniqueName")
        public void setUniqueName(String uniqueName) {
            this.uniqueName = uniqueName;
        }

        @JsonProperty(value="data")
        public void setData(Optional<byte[]> data) {
            this.data = data;
        }

        @Override
        public String getLockId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUniqueName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<byte[]> getData() {
            throw new UnsupportedOperationException();
        }
    }
}

