/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import io.digdag.spi.StorageObjectSummary;
import java.time.Instant;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableStorageObjectSummary
implements StorageObjectSummary {
    private final String key;
    private final long contentLength;
    private final Instant lastModified;

    private ImmutableStorageObjectSummary(String key, long contentLength, Instant lastModified) {
        this.key = key;
        this.contentLength = contentLength;
        this.lastModified = lastModified;
    }

    @Override
    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @Override
    @JsonProperty(value="contentLength")
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    @JsonProperty(value="lastModified")
    public Instant getLastModified() {
        return this.lastModified;
    }

    public final ImmutableStorageObjectSummary withKey(String value) {
        if (this.key.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"key");
        return new ImmutableStorageObjectSummary(newValue, this.contentLength, this.lastModified);
    }

    public final ImmutableStorageObjectSummary withContentLength(long value) {
        if (this.contentLength == value) {
            return this;
        }
        return new ImmutableStorageObjectSummary(this.key, value, this.lastModified);
    }

    public final ImmutableStorageObjectSummary withLastModified(Instant value) {
        if (this.lastModified == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"lastModified");
        return new ImmutableStorageObjectSummary(this.key, this.contentLength, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStorageObjectSummary && this.equalTo((ImmutableStorageObjectSummary)another);
    }

    private boolean equalTo(ImmutableStorageObjectSummary another) {
        return this.key.equals(another.key) && this.contentLength == another.contentLength && this.lastModified.equals(another.lastModified);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.key.hashCode();
        h = h * 17 + Longs.hashCode((long)this.contentLength);
        h = h * 17 + this.lastModified.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"StorageObjectSummary").omitNullValues().add("key", (Object)this.key).add("contentLength", this.contentLength).add("lastModified", (Object)this.lastModified).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStorageObjectSummary fromJson(Json json) {
        Builder builder = ImmutableStorageObjectSummary.builder();
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.contentLengthIsSet) {
            builder.contentLength(json.contentLength);
        }
        if (json.lastModified != null) {
            builder.lastModified(json.lastModified);
        }
        return builder.build();
    }

    public static ImmutableStorageObjectSummary copyOf(StorageObjectSummary instance) {
        if (instance instanceof ImmutableStorageObjectSummary) {
            return (ImmutableStorageObjectSummary)instance;
        }
        return ImmutableStorageObjectSummary.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_CONTENT_LENGTH = 2L;
        private static final long INIT_BIT_LAST_MODIFIED = 4L;
        private long initBits = 7L;
        @Nullable
        private String key;
        private long contentLength;
        @Nullable
        private Instant lastModified;

        private Builder() {
        }

        public final Builder from(StorageObjectSummary instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.key(instance.getKey());
            this.contentLength(instance.getContentLength());
            this.lastModified(instance.getLastModified());
            return this;
        }

        @JsonProperty(value="key")
        public final Builder key(String key) {
            this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="contentLength")
        public final Builder contentLength(long contentLength) {
            this.contentLength = contentLength;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="lastModified")
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = (Instant)Preconditions.checkNotNull((Object)lastModified, (Object)"lastModified");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableStorageObjectSummary build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStorageObjectSummary(this.key, this.contentLength, this.lastModified);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("contentLength");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("lastModified");
            }
            return "Cannot build StorageObjectSummary, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements StorageObjectSummary {
        @Nullable
        String key;
        long contentLength;
        boolean contentLengthIsSet;
        @Nullable
        Instant lastModified;

        Json() {
        }

        @JsonProperty(value="key")
        public void setKey(String key) {
            this.key = key;
        }

        @JsonProperty(value="contentLength")
        public void setContentLength(long contentLength) {
            this.contentLength = contentLength;
            this.contentLengthIsSet = true;
        }

        @JsonProperty(value="lastModified")
        public void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public String getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getContentLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getLastModified() {
            throw new UnsupportedOperationException();
        }
    }
}

