/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.digdag.spi.SecretAccessContext;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableSecretAccessContext
implements SecretAccessContext {
    private final int siteId;
    private final int projectId;
    private final String revision;
    private final String workflowName;
    private final String taskName;
    private final String operatorType;

    private ImmutableSecretAccessContext(int siteId, int projectId, String revision, String workflowName, String taskName, String operatorType) {
        this.siteId = siteId;
        this.projectId = projectId;
        this.revision = revision;
        this.workflowName = workflowName;
        this.taskName = taskName;
        this.operatorType = operatorType;
    }

    @Override
    @JsonProperty(value="siteId")
    public int siteId() {
        return this.siteId;
    }

    @Override
    @JsonProperty(value="projectId")
    public int projectId() {
        return this.projectId;
    }

    @Override
    @JsonProperty(value="revision")
    public String revision() {
        return this.revision;
    }

    @Override
    @JsonProperty(value="workflowName")
    public String workflowName() {
        return this.workflowName;
    }

    @Override
    @JsonProperty(value="taskName")
    public String taskName() {
        return this.taskName;
    }

    @Override
    @JsonProperty(value="operatorType")
    public String operatorType() {
        return this.operatorType;
    }

    public final ImmutableSecretAccessContext withSiteId(int value) {
        if (this.siteId == value) {
            return this;
        }
        return new ImmutableSecretAccessContext(value, this.projectId, this.revision, this.workflowName, this.taskName, this.operatorType);
    }

    public final ImmutableSecretAccessContext withProjectId(int value) {
        if (this.projectId == value) {
            return this;
        }
        return new ImmutableSecretAccessContext(this.siteId, value, this.revision, this.workflowName, this.taskName, this.operatorType);
    }

    public final ImmutableSecretAccessContext withRevision(String value) {
        if (this.revision.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"revision");
        return new ImmutableSecretAccessContext(this.siteId, this.projectId, newValue, this.workflowName, this.taskName, this.operatorType);
    }

    public final ImmutableSecretAccessContext withWorkflowName(String value) {
        if (this.workflowName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"workflowName");
        return new ImmutableSecretAccessContext(this.siteId, this.projectId, this.revision, newValue, this.taskName, this.operatorType);
    }

    public final ImmutableSecretAccessContext withTaskName(String value) {
        if (this.taskName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"taskName");
        return new ImmutableSecretAccessContext(this.siteId, this.projectId, this.revision, this.workflowName, newValue, this.operatorType);
    }

    public final ImmutableSecretAccessContext withOperatorType(String value) {
        if (this.operatorType.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"operatorType");
        return new ImmutableSecretAccessContext(this.siteId, this.projectId, this.revision, this.workflowName, this.taskName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSecretAccessContext && this.equalTo((ImmutableSecretAccessContext)another);
    }

    private boolean equalTo(ImmutableSecretAccessContext another) {
        return this.siteId == another.siteId && this.projectId == another.projectId && this.revision.equals(another.revision) && this.workflowName.equals(another.workflowName) && this.taskName.equals(another.taskName) && this.operatorType.equals(another.operatorType);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.siteId;
        h = h * 17 + this.projectId;
        h = h * 17 + this.revision.hashCode();
        h = h * 17 + this.workflowName.hashCode();
        h = h * 17 + this.taskName.hashCode();
        h = h * 17 + this.operatorType.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SecretAccessContext").omitNullValues().add("siteId", this.siteId).add("projectId", this.projectId).add("revision", (Object)this.revision).add("workflowName", (Object)this.workflowName).add("taskName", (Object)this.taskName).add("operatorType", (Object)this.operatorType).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSecretAccessContext fromJson(Json json) {
        Builder builder = ImmutableSecretAccessContext.builder();
        if (json.siteIdIsSet) {
            builder.siteId(json.siteId);
        }
        if (json.projectIdIsSet) {
            builder.projectId(json.projectId);
        }
        if (json.revision != null) {
            builder.revision(json.revision);
        }
        if (json.workflowName != null) {
            builder.workflowName(json.workflowName);
        }
        if (json.taskName != null) {
            builder.taskName(json.taskName);
        }
        if (json.operatorType != null) {
            builder.operatorType(json.operatorType);
        }
        return builder.build();
    }

    public static ImmutableSecretAccessContext copyOf(SecretAccessContext instance) {
        if (instance instanceof ImmutableSecretAccessContext) {
            return (ImmutableSecretAccessContext)instance;
        }
        return ImmutableSecretAccessContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder
    implements SecretAccessContext.Builder {
        private static final long INIT_BIT_SITE_ID = 1L;
        private static final long INIT_BIT_PROJECT_ID = 2L;
        private static final long INIT_BIT_REVISION = 4L;
        private static final long INIT_BIT_WORKFLOW_NAME = 8L;
        private static final long INIT_BIT_TASK_NAME = 16L;
        private static final long INIT_BIT_OPERATOR_TYPE = 32L;
        private long initBits = 63L;
        private int siteId;
        private int projectId;
        @Nullable
        private String revision;
        @Nullable
        private String workflowName;
        @Nullable
        private String taskName;
        @Nullable
        private String operatorType;

        private Builder() {
        }

        public final Builder from(SecretAccessContext instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.siteId(instance.siteId());
            this.projectId(instance.projectId());
            this.revision(instance.revision());
            this.workflowName(instance.workflowName());
            this.taskName(instance.taskName());
            this.operatorType(instance.operatorType());
            return this;
        }

        @Override
        @JsonProperty(value="siteId")
        public final Builder siteId(int siteId) {
            this.siteId = siteId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty(value="projectId")
        public final Builder projectId(int projectId) {
            this.projectId = projectId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @JsonProperty(value="revision")
        public final Builder revision(String revision) {
            this.revision = (String)Preconditions.checkNotNull((Object)revision, (Object)"revision");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        @JsonProperty(value="workflowName")
        public final Builder workflowName(String workflowName) {
            this.workflowName = (String)Preconditions.checkNotNull((Object)workflowName, (Object)"workflowName");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @Override
        @JsonProperty(value="taskName")
        public final Builder taskName(String taskName) {
            this.taskName = (String)Preconditions.checkNotNull((Object)taskName, (Object)"taskName");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @Override
        @JsonProperty(value="operatorType")
        public final Builder operatorType(String operatorType) {
            this.operatorType = (String)Preconditions.checkNotNull((Object)operatorType, (Object)"operatorType");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @Override
        public ImmutableSecretAccessContext build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSecretAccessContext(this.siteId, this.projectId, this.revision, this.workflowName, this.taskName, this.operatorType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("siteId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("projectId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("revision");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("workflowName");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("taskName");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("operatorType");
            }
            return "Cannot build SecretAccessContext, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SecretAccessContext {
        int siteId;
        boolean siteIdIsSet;
        int projectId;
        boolean projectIdIsSet;
        @Nullable
        String revision;
        @Nullable
        String workflowName;
        @Nullable
        String taskName;
        @Nullable
        String operatorType;

        Json() {
        }

        @JsonProperty(value="siteId")
        public void setSiteId(int siteId) {
            this.siteId = siteId;
            this.siteIdIsSet = true;
        }

        @JsonProperty(value="projectId")
        public void setProjectId(int projectId) {
            this.projectId = projectId;
            this.projectIdIsSet = true;
        }

        @JsonProperty(value="revision")
        public void setRevision(String revision) {
            this.revision = revision;
        }

        @JsonProperty(value="workflowName")
        public void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @JsonProperty(value="taskName")
        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        @JsonProperty(value="operatorType")
        public void setOperatorType(String operatorType) {
            this.operatorType = operatorType;
        }

        @Override
        public int siteId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int projectId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String revision() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String workflowName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String taskName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String operatorType() {
            throw new UnsupportedOperationException();
        }
    }
}

