/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.digdag.spi.Record;
import io.digdag.spi.ValueType;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRecord
implements Record {
    private final String key;
    private final JsonNode value;
    private final ValueType valueType;

    private ImmutableRecord(String key, JsonNode value, ValueType valueType) {
        this.key = key;
        this.value = value;
        this.valueType = valueType;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public JsonNode value() {
        return this.value;
    }

    @Override
    public ValueType valueType() {
        return this.valueType;
    }

    public final ImmutableRecord withKey(String value) {
        if (this.key.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"key");
        return new ImmutableRecord(newValue, this.value, this.valueType);
    }

    public final ImmutableRecord withValue(JsonNode value) {
        if (this.value == value) {
            return this;
        }
        JsonNode newValue = (JsonNode)Preconditions.checkNotNull((Object)value, (Object)"value");
        return new ImmutableRecord(this.key, newValue, this.valueType);
    }

    public final ImmutableRecord withValueType(ValueType value) {
        if (this.valueType == value) {
            return this;
        }
        ValueType newValue = (ValueType)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"valueType"));
        return new ImmutableRecord(this.key, this.value, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRecord && this.equalTo((ImmutableRecord)another);
    }

    private boolean equalTo(ImmutableRecord another) {
        return this.key.equals(another.key) && this.value.equals((Object)another.value) && this.valueType.equals((Object)another.valueType);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.key.hashCode();
        h = h * 17 + this.value.hashCode();
        h = h * 17 + this.valueType.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Record").omitNullValues().add("key", (Object)this.key).add("value", (Object)this.value).add("valueType", (Object)this.valueType).toString();
    }

    public static ImmutableRecord copyOf(Record instance) {
        if (instance instanceof ImmutableRecord) {
            return (ImmutableRecord)instance;
        }
        return ImmutableRecord.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private static final long INIT_BIT_VALUE_TYPE = 4L;
        private long initBits = 7L;
        @Nullable
        private String key;
        @Nullable
        private JsonNode value;
        @Nullable
        private ValueType valueType;

        private Builder() {
        }

        public final Builder from(Record instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.key(instance.key());
            this.value(instance.value());
            this.valueType(instance.valueType());
            return this;
        }

        public final Builder key(String key) {
            this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder value(JsonNode value) {
            this.value = (JsonNode)Preconditions.checkNotNull((Object)value, (Object)"value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder valueType(ValueType valueType) {
            this.valueType = (ValueType)((Object)Preconditions.checkNotNull((Object)((Object)valueType), (Object)"valueType"));
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableRecord build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRecord(this.key, this.value, this.valueType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("valueType");
            }
            return "Cannot build Record, some of required attributes are not set " + attributes;
        }
    }
}

