/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.digdag.spi.LogFilePrefix;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableLogFilePrefix
implements LogFilePrefix {
    private final int siteId;
    private final int projectId;
    private final String workflowName;
    private final Instant sessionTime;
    private final ZoneId timeZone;
    private final Optional<String> retryAttemptName;
    private final Instant createdAt;

    private ImmutableLogFilePrefix(int siteId, int projectId, String workflowName, Instant sessionTime, ZoneId timeZone, Optional<String> retryAttemptName, Instant createdAt) {
        this.siteId = siteId;
        this.projectId = projectId;
        this.workflowName = workflowName;
        this.sessionTime = sessionTime;
        this.timeZone = timeZone;
        this.retryAttemptName = retryAttemptName;
        this.createdAt = createdAt;
    }

    @Override
    @JsonProperty(value="siteId")
    public int getSiteId() {
        return this.siteId;
    }

    @Override
    @JsonProperty(value="projectId")
    public int getProjectId() {
        return this.projectId;
    }

    @Override
    @JsonProperty(value="workflowName")
    public String getWorkflowName() {
        return this.workflowName;
    }

    @Override
    @JsonProperty(value="sessionTime")
    public Instant getSessionTime() {
        return this.sessionTime;
    }

    @Override
    @JsonProperty(value="timeZone")
    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    @Override
    @JsonProperty(value="retryAttemptName")
    public Optional<String> getRetryAttemptName() {
        return this.retryAttemptName;
    }

    @Override
    @JsonProperty(value="createdAt")
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public final ImmutableLogFilePrefix withSiteId(int value) {
        if (this.siteId == value) {
            return this;
        }
        return new ImmutableLogFilePrefix(value, this.projectId, this.workflowName, this.sessionTime, this.timeZone, this.retryAttemptName, this.createdAt);
    }

    public final ImmutableLogFilePrefix withProjectId(int value) {
        if (this.projectId == value) {
            return this;
        }
        return new ImmutableLogFilePrefix(this.siteId, value, this.workflowName, this.sessionTime, this.timeZone, this.retryAttemptName, this.createdAt);
    }

    public final ImmutableLogFilePrefix withWorkflowName(String value) {
        if (this.workflowName.equals(value)) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value, (Object)"workflowName");
        return new ImmutableLogFilePrefix(this.siteId, this.projectId, newValue, this.sessionTime, this.timeZone, this.retryAttemptName, this.createdAt);
    }

    public final ImmutableLogFilePrefix withSessionTime(Instant value) {
        if (this.sessionTime == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"sessionTime");
        return new ImmutableLogFilePrefix(this.siteId, this.projectId, this.workflowName, newValue, this.timeZone, this.retryAttemptName, this.createdAt);
    }

    public final ImmutableLogFilePrefix withTimeZone(ZoneId value) {
        if (this.timeZone == value) {
            return this;
        }
        ZoneId newValue = (ZoneId)Preconditions.checkNotNull((Object)value, (Object)"timeZone");
        return new ImmutableLogFilePrefix(this.siteId, this.projectId, this.workflowName, this.sessionTime, newValue, this.retryAttemptName, this.createdAt);
    }

    public final ImmutableLogFilePrefix withRetryAttemptName(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.retryAttemptName.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableLogFilePrefix(this.siteId, this.projectId, this.workflowName, this.sessionTime, this.timeZone, (Optional<String>)newValue, this.createdAt);
    }

    public final ImmutableLogFilePrefix withRetryAttemptName(Optional<String> optional) {
        Optional value = (Optional)Preconditions.checkNotNull(optional, (Object)"retryAttemptName");
        if (this.retryAttemptName.equals((Object)value)) {
            return this;
        }
        return new ImmutableLogFilePrefix(this.siteId, this.projectId, this.workflowName, this.sessionTime, this.timeZone, (Optional<String>)value, this.createdAt);
    }

    public final ImmutableLogFilePrefix withCreatedAt(Instant value) {
        if (this.createdAt == value) {
            return this;
        }
        Instant newValue = (Instant)Preconditions.checkNotNull((Object)value, (Object)"createdAt");
        return new ImmutableLogFilePrefix(this.siteId, this.projectId, this.workflowName, this.sessionTime, this.timeZone, this.retryAttemptName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLogFilePrefix && this.equalTo((ImmutableLogFilePrefix)another);
    }

    private boolean equalTo(ImmutableLogFilePrefix another) {
        return this.siteId == another.siteId && this.projectId == another.projectId && this.workflowName.equals(another.workflowName) && this.sessionTime.equals(another.sessionTime) && this.timeZone.equals(another.timeZone) && this.retryAttemptName.equals(another.retryAttemptName) && this.createdAt.equals(another.createdAt);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.siteId;
        h = h * 17 + this.projectId;
        h = h * 17 + this.workflowName.hashCode();
        h = h * 17 + this.sessionTime.hashCode();
        h = h * 17 + this.timeZone.hashCode();
        h = h * 17 + this.retryAttemptName.hashCode();
        h = h * 17 + this.createdAt.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LogFilePrefix").omitNullValues().add("siteId", this.siteId).add("projectId", this.projectId).add("workflowName", (Object)this.workflowName).add("sessionTime", (Object)this.sessionTime).add("timeZone", (Object)this.timeZone).add("retryAttemptName", this.retryAttemptName.orNull()).add("createdAt", (Object)this.createdAt).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableLogFilePrefix fromJson(Json json) {
        Builder builder = ImmutableLogFilePrefix.builder();
        if (json.siteIdIsSet) {
            builder.siteId(json.siteId);
        }
        if (json.projectIdIsSet) {
            builder.projectId(json.projectId);
        }
        if (json.workflowName != null) {
            builder.workflowName(json.workflowName);
        }
        if (json.sessionTime != null) {
            builder.sessionTime(json.sessionTime);
        }
        if (json.timeZone != null) {
            builder.timeZone(json.timeZone);
        }
        if (json.retryAttemptName != null) {
            builder.retryAttemptName(json.retryAttemptName);
        }
        if (json.createdAt != null) {
            builder.createdAt(json.createdAt);
        }
        return builder.build();
    }

    public static ImmutableLogFilePrefix copyOf(LogFilePrefix instance) {
        if (instance instanceof ImmutableLogFilePrefix) {
            return (ImmutableLogFilePrefix)instance;
        }
        return ImmutableLogFilePrefix.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SITE_ID = 1L;
        private static final long INIT_BIT_PROJECT_ID = 2L;
        private static final long INIT_BIT_WORKFLOW_NAME = 4L;
        private static final long INIT_BIT_SESSION_TIME = 8L;
        private static final long INIT_BIT_TIME_ZONE = 16L;
        private static final long INIT_BIT_CREATED_AT = 32L;
        private long initBits = 63L;
        private int siteId;
        private int projectId;
        @Nullable
        private String workflowName;
        @Nullable
        private Instant sessionTime;
        @Nullable
        private ZoneId timeZone;
        private Optional<String> retryAttemptName = Optional.absent();
        @Nullable
        private Instant createdAt;

        private Builder() {
        }

        public final Builder from(LogFilePrefix instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.siteId(instance.getSiteId());
            this.projectId(instance.getProjectId());
            this.workflowName(instance.getWorkflowName());
            this.sessionTime(instance.getSessionTime());
            this.timeZone(instance.getTimeZone());
            Optional<String> retryAttemptNameOptional = instance.getRetryAttemptName();
            if (retryAttemptNameOptional.isPresent()) {
                this.retryAttemptName(retryAttemptNameOptional);
            }
            this.createdAt(instance.getCreatedAt());
            return this;
        }

        @JsonProperty(value="siteId")
        public final Builder siteId(int siteId) {
            this.siteId = siteId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="projectId")
        public final Builder projectId(int projectId) {
            this.projectId = projectId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="workflowName")
        public final Builder workflowName(String workflowName) {
            this.workflowName = (String)Preconditions.checkNotNull((Object)workflowName, (Object)"workflowName");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="sessionTime")
        public final Builder sessionTime(Instant sessionTime) {
            this.sessionTime = (Instant)Preconditions.checkNotNull((Object)sessionTime, (Object)"sessionTime");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="timeZone")
        public final Builder timeZone(ZoneId timeZone) {
            this.timeZone = (ZoneId)Preconditions.checkNotNull((Object)timeZone, (Object)"timeZone");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder retryAttemptName(String retryAttemptName) {
            this.retryAttemptName = Optional.of((Object)retryAttemptName);
            return this;
        }

        @JsonProperty(value="retryAttemptName")
        public final Builder retryAttemptName(Optional<String> retryAttemptName) {
            this.retryAttemptName = (Optional)Preconditions.checkNotNull(retryAttemptName, (Object)"retryAttemptName");
            return this;
        }

        @JsonProperty(value="createdAt")
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = (Instant)Preconditions.checkNotNull((Object)createdAt, (Object)"createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImmutableLogFilePrefix build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLogFilePrefix(this.siteId, this.projectId, this.workflowName, this.sessionTime, this.timeZone, this.retryAttemptName, this.createdAt);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("siteId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("projectId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("workflowName");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("sessionTime");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("timeZone");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("createdAt");
            }
            return "Cannot build LogFilePrefix, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements LogFilePrefix {
        int siteId;
        boolean siteIdIsSet;
        int projectId;
        boolean projectIdIsSet;
        @Nullable
        String workflowName;
        @Nullable
        Instant sessionTime;
        @Nullable
        ZoneId timeZone;
        Optional<String> retryAttemptName = Optional.absent();
        @Nullable
        Instant createdAt;

        Json() {
        }

        @JsonProperty(value="siteId")
        public void setSiteId(int siteId) {
            this.siteId = siteId;
            this.siteIdIsSet = true;
        }

        @JsonProperty(value="projectId")
        public void setProjectId(int projectId) {
            this.projectId = projectId;
            this.projectIdIsSet = true;
        }

        @JsonProperty(value="workflowName")
        public void setWorkflowName(String workflowName) {
            this.workflowName = workflowName;
        }

        @JsonProperty(value="sessionTime")
        public void setSessionTime(Instant sessionTime) {
            this.sessionTime = sessionTime;
        }

        @JsonProperty(value="timeZone")
        public void setTimeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
        }

        @JsonProperty(value="retryAttemptName")
        public void setRetryAttemptName(Optional<String> retryAttemptName) {
            this.retryAttemptName = retryAttemptName;
        }

        @JsonProperty(value="createdAt")
        public void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public int getSiteId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getProjectId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getWorkflowName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getSessionTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ZoneId getTimeZone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getRetryAttemptName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getCreatedAt() {
            throw new UnsupportedOperationException();
        }
    }
}

