/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.digdag.spi.DirectDownloadHandle;
import java.net.URL;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableDirectDownloadHandle
implements DirectDownloadHandle {
    private final URL url;

    private ImmutableDirectDownloadHandle(URL url) {
        this.url = url;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    public final ImmutableDirectDownloadHandle withUrl(URL value) {
        if (this.url == value) {
            return this;
        }
        URL newValue = (URL)Preconditions.checkNotNull((Object)value, (Object)"url");
        return new ImmutableDirectDownloadHandle(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDirectDownloadHandle && this.equalTo((ImmutableDirectDownloadHandle)another);
    }

    private boolean equalTo(ImmutableDirectDownloadHandle another) {
        return this.url.equals(another.url);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.url.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DirectDownloadHandle").omitNullValues().add("url", (Object)this.url).toString();
    }

    public static ImmutableDirectDownloadHandle copyOf(DirectDownloadHandle instance) {
        if (instance instanceof ImmutableDirectDownloadHandle) {
            return (ImmutableDirectDownloadHandle)instance;
        }
        return ImmutableDirectDownloadHandle.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private long initBits = 1L;
        @Nullable
        private URL url;

        private Builder() {
        }

        public final Builder from(DirectDownloadHandle instance) {
            Preconditions.checkNotNull((Object)instance, (Object)"instance");
            this.url(instance.getUrl());
            return this;
        }

        public final Builder url(URL url) {
            this.url = (URL)Preconditions.checkNotNull((Object)url, (Object)"url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableDirectDownloadHandle build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDirectDownloadHandle(this.url);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            return "Cannot build DirectDownloadHandle, some of required attributes are not set " + attributes;
        }
    }
}

