/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.spi;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import io.digdag.spi.AuthenticatedUser;
import io.digdag.spi.ImmutableResult;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import org.immutables.value.Value;

public interface Authenticator {
    public Result authenticate(ContainerRequestContext var1);

    @JsonSerialize(as=ImmutableResult.class)
    @JsonDeserialize(as=ImmutableResult.class)
    @Value.Immutable
    @Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE)
    public static interface Result {
        public static Result accept(AuthenticatedUser user) {
            return Result.accept(user, (Supplier<Map<String, String>>)((Supplier)() -> ImmutableMap.of()));
        }

        public static Result accept(AuthenticatedUser user, Supplier<Map<String, String>> secrets) {
            return ImmutableResult.builder().secrets(secrets).authenticatedUser(user).build();
        }

        public static Result reject(String message) {
            return ImmutableResult.builder().errorMessage(message).build();
        }

        default public boolean isAccepted() {
            return !this.getErrorMessage().isPresent();
        }

        @Value.Check
        default public void checkNull() {
            if (this.isAccepted()) {
                Preconditions.checkState((this.getSecrets().isPresent() && this.getAuthenticatedUser().isPresent() ? 1 : 0) != 0);
            } else {
                Preconditions.checkState((!this.getSecrets().isPresent() || !this.getAuthenticatedUser().isPresent() ? 1 : 0) != 0);
            }
        }

        public Optional<String> getErrorMessage();

        public Optional<Supplier<Map<String, String>>> getSecrets();

        public Optional<AuthenticatedUser> getAuthenticatedUser();
    }
}

