/*
 * Decompiled with CFR 0.152.
 */
package io.digdag.metrics;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.digdag.spi.metrics.DigdagMetrics;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdDigdagMetrics
implements DigdagMetrics {
    private static final Logger logger = LoggerFactory.getLogger(StdDigdagMetrics.class);
    final MeterRegistry registry;
    final MeterRegistry registryAgent;
    final MeterRegistry registryApi;
    final MeterRegistry registryDb;
    final MeterRegistry registryExecutor;
    final Map<DigdagMetrics.Category, MeterRegistry> mapRegistries;

    @Inject
    public StdDigdagMetrics(@Named(value="default") MeterRegistry registry, @Named(value="agent") MeterRegistry registryAgent, @Named(value="api") MeterRegistry registryApi, @Named(value="db") MeterRegistry registryDb, @Named(value="executor") MeterRegistry registryExecutor) {
        this.registry = registry;
        this.registryAgent = registryAgent;
        this.registryApi = registryApi;
        this.registryDb = registryDb;
        this.registryExecutor = registryExecutor;
        this.mapRegistries = ImmutableMap.of((Object)((Object)DigdagMetrics.Category.DEFAULT), (Object)registry, (Object)((Object)DigdagMetrics.Category.AGENT), (Object)registryAgent, (Object)((Object)DigdagMetrics.Category.API), (Object)registryApi, (Object)((Object)DigdagMetrics.Category.DB), (Object)registryDb, (Object)((Object)DigdagMetrics.Category.EXECUTOR), (Object)registryExecutor);
    }

    @Override
    public MeterRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public MeterRegistry getRegistry(DigdagMetrics.Category category) {
        MeterRegistry mreg = this.mapRegistries.get((Object)category);
        if (mreg == null) {
            logger.warn("Cannot get MeterRegistry for {}", (Object)category);
            mreg = this.registry;
        }
        return mreg;
    }

    @Override
    public String mkMetricsName(DigdagMetrics.Category category, String metricsName) {
        return this.metricsPrefix(category) + metricsName;
    }

    private String metricsPrefix(DigdagMetrics.Category category) {
        if (category.getString().compareTo("default") == 0) {
            return "";
        }
        return category.getString() + "_";
    }

    @Override
    public void increment(DigdagMetrics.Category category, String metricName, Tags tags) {
        this.getRegistry(category).counter(this.mkMetricsName(category, metricName), (Iterable)tags).increment();
    }

    @Override
    public void gauge(DigdagMetrics.Category category, String metricName, Tags tags, double value) {
        this.getRegistry(category).gauge(this.mkMetricsName(category, metricName), (Iterable)tags, (Number)value);
    }

    @Override
    public void summary(DigdagMetrics.Category category, String metricName, Tags tags, double value) {
        this.getRegistry(category).summary(this.mkMetricsName(category, metricName), (Iterable)tags).record(value);
    }

    public static StdDigdagMetrics empty() {
        SimpleMeterRegistry registry = new SimpleMeterRegistry();
        StdDigdagMetrics metrics = new StdDigdagMetrics((MeterRegistry)registry, (MeterRegistry)registry, (MeterRegistry)registry, (MeterRegistry)registry, (MeterRegistry)registry);
        return metrics;
    }
}

